-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MKrunFwInfoTable = {}

---@class MKrunFwInfoTable.ActiveModeEnabled
---@field ActiveModeEnabled boolean
local TActiveModeEnabled = {}
TActiveModeEnabled.__index = TActiveModeEnabled
TActiveModeEnabled.group = {}

local function TActiveModeEnabled_from_obj(obj)
    return setmetatable(obj, TActiveModeEnabled)
end

function TActiveModeEnabled.new(ActiveModeEnabled)
    return TActiveModeEnabled_from_obj({ActiveModeEnabled = ActiveModeEnabled == nil and true or ActiveModeEnabled})
end
---@param obj MKrunFwInfoTable.ActiveModeEnabled
function TActiveModeEnabled:init_from_obj(obj)
    self.ActiveModeEnabled = obj.ActiveModeEnabled == nil and true or obj.ActiveModeEnabled
end

function TActiveModeEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActiveModeEnabled.group)
end

TActiveModeEnabled.from_obj = TActiveModeEnabled_from_obj

TActiveModeEnabled.proto_property = {'ActiveModeEnabled'}

TActiveModeEnabled.default = {false}

TActiveModeEnabled.struct = {{name = 'ActiveModeEnabled', is_array = false, struct = nil}}

function TActiveModeEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActiveModeEnabled', self.ActiveModeEnabled, 'bool', false, errs, need_convert)

    TActiveModeEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActiveModeEnabled.proto_property, errs, need_convert)
    return self
end

function TActiveModeEnabled:unpack(_)
    return self.ActiveModeEnabled
end

MKrunFwInfoTable.ActiveModeEnabled = TActiveModeEnabled

---@class MKrunFwInfoTable.ActiveModeSupported
---@field ActiveModeSupported boolean
local TActiveModeSupported = {}
TActiveModeSupported.__index = TActiveModeSupported
TActiveModeSupported.group = {}

local function TActiveModeSupported_from_obj(obj)
    return setmetatable(obj, TActiveModeSupported)
end

function TActiveModeSupported.new(ActiveModeSupported)
    return TActiveModeSupported_from_obj({
        ActiveModeSupported = ActiveModeSupported == nil and true or ActiveModeSupported
    })
end
---@param obj MKrunFwInfoTable.ActiveModeSupported
function TActiveModeSupported:init_from_obj(obj)
    self.ActiveModeSupported = obj.ActiveModeSupported == nil and true or obj.ActiveModeSupported
end

function TActiveModeSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActiveModeSupported.group)
end

TActiveModeSupported.from_obj = TActiveModeSupported_from_obj

TActiveModeSupported.proto_property = {'ActiveModeSupported'}

TActiveModeSupported.default = {false}

TActiveModeSupported.struct = {{name = 'ActiveModeSupported', is_array = false, struct = nil}}

function TActiveModeSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActiveModeSupported', self.ActiveModeSupported, 'bool', false, errs, need_convert)

    TActiveModeSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActiveModeSupported.proto_property, errs, need_convert)
    return self
end

function TActiveModeSupported:unpack(_)
    return self.ActiveModeSupported
end

MKrunFwInfoTable.ActiveModeSupported = TActiveModeSupported

---@class MKrunFwInfoTable.ActiveMode
---@field ActiveMode string
local TActiveMode = {}
TActiveMode.__index = TActiveMode
TActiveMode.group = {}

local function TActiveMode_from_obj(obj)
    return setmetatable(obj, TActiveMode)
end

function TActiveMode.new(ActiveMode)
    return TActiveMode_from_obj({ActiveMode = ActiveMode or [=[]=]})
end
---@param obj MKrunFwInfoTable.ActiveMode
function TActiveMode:init_from_obj(obj)
    self.ActiveMode = obj.ActiveMode or [=[]=]
end

function TActiveMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActiveMode.group)
end

TActiveMode.from_obj = TActiveMode_from_obj

TActiveMode.proto_property = {'ActiveMode'}

TActiveMode.default = {''}

TActiveMode.struct = {{name = 'ActiveMode', is_array = false, struct = nil}}

function TActiveMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActiveMode', self.ActiveMode, 'string', false, errs, need_convert)

    TActiveMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActiveMode.proto_property, errs, need_convert)
    return self
end

function TActiveMode:unpack(_)
    return self.ActiveMode
end

MKrunFwInfoTable.ActiveMode = TActiveMode

---@class MKrunFwInfoTable.State
---@field State string
local TState = {}
TState.__index = TState
TState.group = {}

local function TState_from_obj(obj)
    return setmetatable(obj, TState)
end

function TState.new(State)
    return TState_from_obj({State = State or [=[Enabled]=]})
end
---@param obj MKrunFwInfoTable.State
function TState:init_from_obj(obj)
    self.State = obj.State or [=[Enabled]=]
end

function TState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TState.group)
end

TState.from_obj = TState_from_obj

TState.proto_property = {'State'}

TState.default = {''}

TState.struct = {{name = 'State', is_array = false, struct = nil}}

function TState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'string', false, errs, need_convert)

    TState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TState.proto_property, errs, need_convert)
    return self
end

function TState:unpack(_)
    return self.State
end

MKrunFwInfoTable.State = TState

---@class MKrunFwInfoTable.Capability
---@field Capability integer
local TCapability = {}
TCapability.__index = TCapability
TCapability.group = {}

local function TCapability_from_obj(obj)
    return setmetatable(obj, TCapability)
end

function TCapability.new(Capability)
    return TCapability_from_obj({Capability = Capability or 5})
end
---@param obj MKrunFwInfoTable.Capability
function TCapability:init_from_obj(obj)
    self.Capability = obj.Capability or 5
end

function TCapability:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCapability.group)
end

TCapability.from_obj = TCapability_from_obj

TCapability.proto_property = {'Capability'}

TCapability.default = {0}

TCapability.struct = {{name = 'Capability', is_array = false, struct = nil}}

function TCapability:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Capability', self.Capability, 'uint16', false, errs, need_convert)

    TCapability:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCapability.proto_property, errs, need_convert)
    return self
end

function TCapability:unpack(_)
    return self.Capability
end

MKrunFwInfoTable.Capability = TCapability

---@class MKrunFwInfoTable.Location
---@field Location string
local TLocation = {}
TLocation.__index = TLocation
TLocation.group = {}

local function TLocation_from_obj(obj)
    return setmetatable(obj, TLocation)
end

function TLocation.new(Location)
    return TLocation_from_obj({Location = Location or [=[U75]=]})
end
---@param obj MKrunFwInfoTable.Location
function TLocation:init_from_obj(obj)
    self.Location = obj.Location or [=[U75]=]
end

function TLocation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocation.group)
end

TLocation.from_obj = TLocation_from_obj

TLocation.proto_property = {'Location'}

TLocation.default = {''}

TLocation.struct = {{name = 'Location', is_array = false, struct = nil}}

function TLocation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Location', self.Location, 'string', false, errs, need_convert)

    TLocation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocation.proto_property, errs, need_convert)
    return self
end

function TLocation:unpack(_)
    return self.Location
end

MKrunFwInfoTable.Location = TLocation

---@class MKrunFwInfoTable.Updateable
---@field Updateable boolean
local TUpdateable = {}
TUpdateable.__index = TUpdateable
TUpdateable.group = {}

local function TUpdateable_from_obj(obj)
    return setmetatable(obj, TUpdateable)
end

function TUpdateable.new(Updateable)
    return TUpdateable_from_obj({Updateable = Updateable == nil and true or Updateable})
end
---@param obj MKrunFwInfoTable.Updateable
function TUpdateable:init_from_obj(obj)
    self.Updateable = obj.Updateable == nil and true or obj.Updateable
end

function TUpdateable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateable.group)
end

TUpdateable.from_obj = TUpdateable_from_obj

TUpdateable.proto_property = {'Updateable'}

TUpdateable.default = {false}

TUpdateable.struct = {{name = 'Updateable', is_array = false, struct = nil}}

function TUpdateable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Updateable', self.Updateable, 'bool', false, errs, need_convert)

    TUpdateable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateable.proto_property, errs, need_convert)
    return self
end

function TUpdateable:unpack(_)
    return self.Updateable
end

MKrunFwInfoTable.Updateable = TUpdateable

---@class MKrunFwInfoTable.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer or [=[Huawei]=]})
end
---@param obj MKrunFwInfoTable.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer or [=[Huawei]=]
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', false, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

MKrunFwInfoTable.Manufacturer = TManufacturer

---@class MKrunFwInfoTable.SoftwareId
---@field SoftwareId string
local TSoftwareId = {}
TSoftwareId.__index = TSoftwareId
TSoftwareId.group = {}

local function TSoftwareId_from_obj(obj)
    return setmetatable(obj, TSoftwareId)
end

function TSoftwareId.new(SoftwareId)
    return TSoftwareId_from_obj({SoftwareId = SoftwareId or [=[Krun-Krun]=]})
end
---@param obj MKrunFwInfoTable.SoftwareId
function TSoftwareId:init_from_obj(obj)
    self.SoftwareId = obj.SoftwareId or [=[Krun-Krun]=]
end

function TSoftwareId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSoftwareId.group)
end

TSoftwareId.from_obj = TSoftwareId_from_obj

TSoftwareId.proto_property = {'SoftwareId'}

TSoftwareId.default = {''}

TSoftwareId.struct = {{name = 'SoftwareId', is_array = false, struct = nil}}

function TSoftwareId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SoftwareId', self.SoftwareId, 'string', false, errs, need_convert)

    TSoftwareId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSoftwareId.proto_property, errs, need_convert)
    return self
end

function TSoftwareId:unpack(_)
    return self.SoftwareId
end

MKrunFwInfoTable.SoftwareId = TSoftwareId

---@class MKrunFwInfoTable.LowestSupportedVersion
---@field LowestSupportedVersion string
local TLowestSupportedVersion = {}
TLowestSupportedVersion.__index = TLowestSupportedVersion
TLowestSupportedVersion.group = {}

local function TLowestSupportedVersion_from_obj(obj)
    return setmetatable(obj, TLowestSupportedVersion)
end

function TLowestSupportedVersion.new(LowestSupportedVersion)
    return TLowestSupportedVersion_from_obj({LowestSupportedVersion = LowestSupportedVersion or [=[]=]})
end
---@param obj MKrunFwInfoTable.LowestSupportedVersion
function TLowestSupportedVersion:init_from_obj(obj)
    self.LowestSupportedVersion = obj.LowestSupportedVersion or [=[]=]
end

function TLowestSupportedVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLowestSupportedVersion.group)
end

TLowestSupportedVersion.from_obj = TLowestSupportedVersion_from_obj

TLowestSupportedVersion.proto_property = {'LowestSupportedVersion'}

TLowestSupportedVersion.default = {''}

TLowestSupportedVersion.struct = {{name = 'LowestSupportedVersion', is_array = false, struct = nil}}

function TLowestSupportedVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LowestSupportedVersion', self.LowestSupportedVersion, 'string', false, errs,
        need_convert)

    TLowestSupportedVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLowestSupportedVersion.proto_property, errs, need_convert)
    return self
end

function TLowestSupportedVersion:unpack(_)
    return self.LowestSupportedVersion
end

MKrunFwInfoTable.LowestSupportedVersion = TLowestSupportedVersion

---@class MKrunFwInfoTable.ReleaseDate
---@field ReleaseDate string
local TReleaseDate = {}
TReleaseDate.__index = TReleaseDate
TReleaseDate.group = {}

local function TReleaseDate_from_obj(obj)
    return setmetatable(obj, TReleaseDate)
end

function TReleaseDate.new(ReleaseDate)
    return TReleaseDate_from_obj({ReleaseDate = ReleaseDate or [=[]=]})
end
---@param obj MKrunFwInfoTable.ReleaseDate
function TReleaseDate:init_from_obj(obj)
    self.ReleaseDate = obj.ReleaseDate or [=[]=]
end

function TReleaseDate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReleaseDate.group)
end

TReleaseDate.from_obj = TReleaseDate_from_obj

TReleaseDate.proto_property = {'ReleaseDate'}

TReleaseDate.default = {''}

TReleaseDate.struct = {{name = 'ReleaseDate', is_array = false, struct = nil}}

function TReleaseDate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReleaseDate', self.ReleaseDate, 'string', false, errs, need_convert)

    TReleaseDate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReleaseDate.proto_property, errs, need_convert)
    return self
end

function TReleaseDate:unpack(_)
    return self.ReleaseDate
end

MKrunFwInfoTable.ReleaseDate = TReleaseDate

---@class MKrunFwInfoTable.BuildNum
---@field BuildNum string
local TBuildNum = {}
TBuildNum.__index = TBuildNum
TBuildNum.group = {}

local function TBuildNum_from_obj(obj)
    return setmetatable(obj, TBuildNum)
end

function TBuildNum.new(BuildNum)
    return TBuildNum_from_obj({BuildNum = BuildNum or [=[]=]})
end
---@param obj MKrunFwInfoTable.BuildNum
function TBuildNum:init_from_obj(obj)
    self.BuildNum = obj.BuildNum or [=[]=]
end

function TBuildNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBuildNum.group)
end

TBuildNum.from_obj = TBuildNum_from_obj

TBuildNum.proto_property = {'BuildNum'}

TBuildNum.default = {''}

TBuildNum.struct = {{name = 'BuildNum', is_array = false, struct = nil}}

function TBuildNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BuildNum', self.BuildNum, 'string', false, errs, need_convert)

    TBuildNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBuildNum.proto_property, errs, need_convert)
    return self
end

function TBuildNum:unpack(_)
    return self.BuildNum
end

MKrunFwInfoTable.BuildNum = TBuildNum

---@class MKrunFwInfoTable.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version or [=[0.00]=]})
end
---@param obj MKrunFwInfoTable.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version or [=[0.00]=]
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', false, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

MKrunFwInfoTable.Version = TVersion

---@class MKrunFwInfoTable.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name or [=[Krun]=]})
end
---@param obj MKrunFwInfoTable.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name or [=[Krun]=]
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', false, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

MKrunFwInfoTable.Name = TName

---@class MKrunFwInfoTable.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id or [=[Krun]=]})
end
---@param obj MKrunFwInfoTable.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id or [=[Krun]=]
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MKrunFwInfoTable.Id = TId

return MKrunFwInfoTable
