-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MKrunFirmware = {}

---@class MKrunFirmware.RelatedSystems
---@field RelatedSystems integer[]
local TRelatedSystems = {}
TRelatedSystems.__index = TRelatedSystems
TRelatedSystems.group = {}

local function TRelatedSystems_from_obj(obj)
    return setmetatable(obj, TRelatedSystems)
end

function TRelatedSystems.new(RelatedSystems)
    return TRelatedSystems_from_obj({RelatedSystems = RelatedSystems})
end
---@param obj MKrunFirmware.RelatedSystems
function TRelatedSystems:init_from_obj(obj)
    self.RelatedSystems = obj.RelatedSystems
end

function TRelatedSystems:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRelatedSystems.group)
end

TRelatedSystems.from_obj = TRelatedSystems_from_obj

TRelatedSystems.proto_property = {'RelatedSystems'}

TRelatedSystems.default = {{}}

TRelatedSystems.struct = {{name = 'RelatedSystems', is_array = true, struct = nil}}

function TRelatedSystems:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RelatedSystems', self.RelatedSystems, 'uint8', false, errs, need_convert)

    TRelatedSystems:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRelatedSystems.proto_property, errs, need_convert)
    return self
end

function TRelatedSystems:unpack(_)
    return self.RelatedSystems
end

MKrunFirmware.RelatedSystems = TRelatedSystems

---@class MKrunFirmware.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj MKrunFirmware.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', false, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

MKrunFirmware.Version = TVersion

---@class MKrunFirmware.FlashChip
---@field FlashChip integer[]
local TFlashChip = {}
TFlashChip.__index = TFlashChip
TFlashChip.group = {}

local function TFlashChip_from_obj(obj)
    return setmetatable(obj, TFlashChip)
end

function TFlashChip.new(FlashChip)
    return TFlashChip_from_obj({FlashChip = FlashChip})
end
---@param obj MKrunFirmware.FlashChip
function TFlashChip:init_from_obj(obj)
    self.FlashChip = obj.FlashChip
end

function TFlashChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFlashChip.group)
end

TFlashChip.from_obj = TFlashChip_from_obj

TFlashChip.proto_property = {'FlashChip'}

TFlashChip.default = {{}}

TFlashChip.struct = {{name = 'FlashChip', is_array = true, struct = nil}}

function TFlashChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'FlashChip', self.FlashChip, 'uint8', false, errs, need_convert)

    TFlashChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFlashChip.proto_property, errs, need_convert)
    return self
end

function TFlashChip:unpack(_)
    return self.FlashChip
end

MKrunFirmware.FlashChip = TFlashChip

---@class MKrunFirmware.RefChip
---@field RefChip integer[]
local TRefChip = {}
TRefChip.__index = TRefChip
TRefChip.group = {}

local function TRefChip_from_obj(obj)
    return setmetatable(obj, TRefChip)
end

function TRefChip.new(RefChip)
    return TRefChip_from_obj({RefChip = RefChip})
end
---@param obj MKrunFirmware.RefChip
function TRefChip:init_from_obj(obj)
    self.RefChip = obj.RefChip
end

function TRefChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefChip.group)
end

TRefChip.from_obj = TRefChip_from_obj

TRefChip.proto_property = {'RefChip'}

TRefChip.default = {{}}

TRefChip.struct = {{name = 'RefChip', is_array = true, struct = nil}}

function TRefChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefChip', self.RefChip, 'uint8', false, errs, need_convert)

    TRefChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefChip.proto_property, errs, need_convert)
    return self
end

function TRefChip:unpack(_)
    return self.RefChip
end

MKrunFirmware.RefChip = TRefChip

---@class MKrunFirmware.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj MKrunFirmware.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', false, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

MKrunFirmware.Name = TName

---@class MKrunFirmware.UId
---@field UId string
local TUId = {}
TUId.__index = TUId
TUId.group = {}

local function TUId_from_obj(obj)
    return setmetatable(obj, TUId)
end

function TUId.new(UId)
    return TUId_from_obj({UId = UId})
end
---@param obj MKrunFirmware.UId
function TUId:init_from_obj(obj)
    self.UId = obj.UId
end

function TUId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUId.group)
end

TUId.from_obj = TUId_from_obj

TUId.proto_property = {'UId'}

TUId.default = {''}

TUId.struct = {{name = 'UId', is_array = false, struct = nil}}

function TUId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UId', self.UId, 'string', false, errs, need_convert)

    TUId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUId.proto_property, errs, need_convert)
    return self
end

function TUId:unpack(_)
    return self.UId
end

MKrunFirmware.UId = TUId

---@class MKrunFirmware.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MKrunFirmware.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MKrunFirmware.Id = TId

return MKrunFirmware
