-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MEventMsg = {}

---@class MEventMsg.SubjectType
---@field SubjectType string
local TSubjectType = {}
TSubjectType.__index = TSubjectType
TSubjectType.group = {}

local function TSubjectType_from_obj(obj)
    return setmetatable(obj, TSubjectType)
end

function TSubjectType.new(SubjectType)
    return TSubjectType_from_obj({SubjectType = SubjectType})
end
---@param obj MEventMsg.SubjectType
function TSubjectType:init_from_obj(obj)
    self.SubjectType = obj.SubjectType
end

function TSubjectType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubjectType.group)
end

TSubjectType.from_obj = TSubjectType_from_obj

TSubjectType.proto_property = {'SubjectType'}

TSubjectType.default = {''}

TSubjectType.struct = {{name = 'SubjectType', is_array = false, struct = nil}}

function TSubjectType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SubjectType', self.SubjectType, 'string', false, errs, need_convert)

    TSubjectType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubjectType.proto_property, errs, need_convert)
    return self
end

function TSubjectType:unpack(_)
    return self.SubjectType
end

MEventMsg.SubjectType = TSubjectType

---@class MEventMsg.NodeId
---@field NodeId string
local TNodeId = {}
TNodeId.__index = TNodeId
TNodeId.group = {}

local function TNodeId_from_obj(obj)
    return setmetatable(obj, TNodeId)
end

function TNodeId.new(NodeId)
    return TNodeId_from_obj({NodeId = NodeId})
end
---@param obj MEventMsg.NodeId
function TNodeId:init_from_obj(obj)
    self.NodeId = obj.NodeId
end

function TNodeId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNodeId.group)
end

TNodeId.from_obj = TNodeId_from_obj

TNodeId.proto_property = {'NodeId'}

TNodeId.default = {''}

TNodeId.struct = {{name = 'NodeId', is_array = false, struct = nil}}

function TNodeId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'NodeId', self.NodeId, 'string', false, errs, need_convert)

    TNodeId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNodeId.proto_property, errs, need_convert)
    return self
end

function TNodeId:unpack(_)
    return self.NodeId
end

MEventMsg.NodeId = TNodeId

---@class MEventMsg.ChassisId
---@field ChassisId string
local TChassisId = {}
TChassisId.__index = TChassisId
TChassisId.group = {}

local function TChassisId_from_obj(obj)
    return setmetatable(obj, TChassisId)
end

function TChassisId.new(ChassisId)
    return TChassisId_from_obj({ChassisId = ChassisId})
end
---@param obj MEventMsg.ChassisId
function TChassisId:init_from_obj(obj)
    self.ChassisId = obj.ChassisId
end

function TChassisId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChassisId.group)
end

TChassisId.from_obj = TChassisId_from_obj

TChassisId.proto_property = {'ChassisId'}

TChassisId.default = {''}

TChassisId.struct = {{name = 'ChassisId', is_array = false, struct = nil}}

function TChassisId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'ChassisId', self.ChassisId, 'string', false, errs, need_convert)

    TChassisId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChassisId.proto_property, errs, need_convert)
    return self
end

function TChassisId:unpack(_)
    return self.ChassisId
end

MEventMsg.ChassisId = TChassisId

---@class MEventMsg.ManagerId
---@field ManagerId string
local TManagerId = {}
TManagerId.__index = TManagerId
TManagerId.group = {}

local function TManagerId_from_obj(obj)
    return setmetatable(obj, TManagerId)
end

function TManagerId.new(ManagerId)
    return TManagerId_from_obj({ManagerId = ManagerId})
end
---@param obj MEventMsg.ManagerId
function TManagerId:init_from_obj(obj)
    self.ManagerId = obj.ManagerId
end

function TManagerId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManagerId.group)
end

TManagerId.from_obj = TManagerId_from_obj

TManagerId.proto_property = {'ManagerId'}

TManagerId.default = {''}

TManagerId.struct = {{name = 'ManagerId', is_array = false, struct = nil}}

function TManagerId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'ManagerId', self.ManagerId, 'string', false, errs, need_convert)

    TManagerId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManagerId.proto_property, errs, need_convert)
    return self
end

function TManagerId:unpack(_)
    return self.ManagerId
end

MEventMsg.ManagerId = TManagerId

---@class MEventMsg.SystemId
---@field SystemId string
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj MEventMsg.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {''}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'string', false, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

MEventMsg.SystemId = TSystemId

---@class MEventMsg.MessageArgs
---@field MessageArgs string
local TMessageArgs = {}
TMessageArgs.__index = TMessageArgs
TMessageArgs.group = {}

local function TMessageArgs_from_obj(obj)
    return setmetatable(obj, TMessageArgs)
end

function TMessageArgs.new(MessageArgs)
    return TMessageArgs_from_obj({MessageArgs = MessageArgs})
end
---@param obj MEventMsg.MessageArgs
function TMessageArgs:init_from_obj(obj)
    self.MessageArgs = obj.MessageArgs
end

function TMessageArgs:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMessageArgs.group)
end

TMessageArgs.from_obj = TMessageArgs_from_obj

TMessageArgs.proto_property = {'MessageArgs'}

TMessageArgs.default = {''}

TMessageArgs.struct = {{name = 'MessageArgs', is_array = false, struct = nil}}

function TMessageArgs:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'MessageArgs', self.MessageArgs, 'string', false, errs, need_convert)

    TMessageArgs:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMessageArgs.proto_property, errs, need_convert)
    return self
end

function TMessageArgs:unpack(_)
    return self.MessageArgs
end

MEventMsg.MessageArgs = TMessageArgs

---@class MEventMsg.EventKeyId
---@field EventKeyId string
local TEventKeyId = {}
TEventKeyId.__index = TEventKeyId
TEventKeyId.group = {}

local function TEventKeyId_from_obj(obj)
    return setmetatable(obj, TEventKeyId)
end

function TEventKeyId.new(EventKeyId)
    return TEventKeyId_from_obj({EventKeyId = EventKeyId})
end
---@param obj MEventMsg.EventKeyId
function TEventKeyId:init_from_obj(obj)
    self.EventKeyId = obj.EventKeyId
end

function TEventKeyId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventKeyId.group)
end

TEventKeyId.from_obj = TEventKeyId_from_obj

TEventKeyId.proto_property = {'EventKeyId'}

TEventKeyId.default = {''}

TEventKeyId.struct = {{name = 'EventKeyId', is_array = false, struct = nil}}

function TEventKeyId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'EventKeyId', self.EventKeyId, 'string', false, errs, need_convert)

    TEventKeyId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventKeyId.proto_property, errs, need_convert)
    return self
end

function TEventKeyId:unpack(_)
    return self.EventKeyId
end

MEventMsg.EventKeyId = TEventKeyId

---@class MEventMsg.State
---@field State string
local TState = {}
TState.__index = TState
TState.group = {}

local function TState_from_obj(obj)
    return setmetatable(obj, TState)
end

function TState.new(State)
    return TState_from_obj({State = State})
end
---@param obj MEventMsg.State
function TState:init_from_obj(obj)
    self.State = obj.State
end

function TState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TState.group)
end

TState.from_obj = TState_from_obj

TState.proto_property = {'State'}

TState.default = {''}

TState.struct = {{name = 'State', is_array = false, struct = nil}}

function TState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'State', self.State, 'string', false, errs, need_convert)

    TState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TState.proto_property, errs, need_convert)
    return self
end

function TState:unpack(_)
    return self.State
end

MEventMsg.State = TState

---@class MEventMsg.ComponentName
---@field ComponentName string
local TComponentName = {}
TComponentName.__index = TComponentName
TComponentName.group = {}

local function TComponentName_from_obj(obj)
    return setmetatable(obj, TComponentName)
end

function TComponentName.new(ComponentName)
    return TComponentName_from_obj({ComponentName = ComponentName})
end
---@param obj MEventMsg.ComponentName
function TComponentName:init_from_obj(obj)
    self.ComponentName = obj.ComponentName
end

function TComponentName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComponentName.group)
end

TComponentName.from_obj = TComponentName_from_obj

TComponentName.proto_property = {'ComponentName'}

TComponentName.default = {''}

TComponentName.struct = {{name = 'ComponentName', is_array = false, struct = nil}}

function TComponentName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'ComponentName', self.ComponentName, 'string', false, errs, need_convert)

    TComponentName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComponentName.proto_property, errs, need_convert)
    return self
end

function TComponentName:unpack(_)
    return self.ComponentName
end

MEventMsg.ComponentName = TComponentName

---@class MEventMsg.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MEventMsg.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MEventMsg.Id = TId

return MEventMsg
