-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MBiosInfoTable = {}

---@class MBiosInfoTable.ResetBiosToDefaultsPending
---@field ResetBiosToDefaultsPending boolean
local TResetBiosToDefaultsPending = {}
TResetBiosToDefaultsPending.__index = TResetBiosToDefaultsPending
TResetBiosToDefaultsPending.group = {}

local function TResetBiosToDefaultsPending_from_obj(obj)
    return setmetatable(obj, TResetBiosToDefaultsPending)
end

function TResetBiosToDefaultsPending.new(ResetBiosToDefaultsPending)
    return TResetBiosToDefaultsPending_from_obj({ResetBiosToDefaultsPending = ResetBiosToDefaultsPending or false})
end
---@param obj MBiosInfoTable.ResetBiosToDefaultsPending
function TResetBiosToDefaultsPending:init_from_obj(obj)
    self.ResetBiosToDefaultsPending = obj.ResetBiosToDefaultsPending or false
end

function TResetBiosToDefaultsPending:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetBiosToDefaultsPending.group)
end

TResetBiosToDefaultsPending.from_obj = TResetBiosToDefaultsPending_from_obj

TResetBiosToDefaultsPending.proto_property = {'ResetBiosToDefaultsPending'}

TResetBiosToDefaultsPending.default = {false}

TResetBiosToDefaultsPending.struct = {{name = 'ResetBiosToDefaultsPending', is_array = false, struct = nil}}

function TResetBiosToDefaultsPending:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetBiosToDefaultsPending', self.ResetBiosToDefaultsPending, 'bool', false, errs,
        need_convert)

    TResetBiosToDefaultsPending:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetBiosToDefaultsPending.proto_property, errs, need_convert)
    return self
end

function TResetBiosToDefaultsPending:unpack(_)
    return self.ResetBiosToDefaultsPending
end

MBiosInfoTable.ResetBiosToDefaultsPending = TResetBiosToDefaultsPending

---@class MBiosInfoTable.TeeOSVersion
---@field TeeOSVersion string
local TTeeOSVersion = {}
TTeeOSVersion.__index = TTeeOSVersion
TTeeOSVersion.group = {}

local function TTeeOSVersion_from_obj(obj)
    return setmetatable(obj, TTeeOSVersion)
end

function TTeeOSVersion.new(TeeOSVersion)
    return TTeeOSVersion_from_obj({TeeOSVersion = TeeOSVersion or [=[]=]})
end
---@param obj MBiosInfoTable.TeeOSVersion
function TTeeOSVersion:init_from_obj(obj)
    self.TeeOSVersion = obj.TeeOSVersion or [=[]=]
end

function TTeeOSVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTeeOSVersion.group)
end

TTeeOSVersion.from_obj = TTeeOSVersion_from_obj

TTeeOSVersion.proto_property = {'TeeOSVersion'}

TTeeOSVersion.default = {''}

TTeeOSVersion.struct = {{name = 'TeeOSVersion', is_array = false, struct = nil}}

function TTeeOSVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TeeOSVersion', self.TeeOSVersion, 'string', false, errs, need_convert)

    TTeeOSVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTeeOSVersion.proto_property, errs, need_convert)
    return self
end

function TTeeOSVersion:unpack(_)
    return self.TeeOSVersion
end

MBiosInfoTable.TeeOSVersion = TTeeOSVersion

---@class MBiosInfoTable.BiosBootStage
---@field BiosBootStage integer
local TBiosBootStage = {}
TBiosBootStage.__index = TBiosBootStage
TBiosBootStage.group = {}

local function TBiosBootStage_from_obj(obj)
    return setmetatable(obj, TBiosBootStage)
end

function TBiosBootStage.new(BiosBootStage)
    return TBiosBootStage_from_obj({BiosBootStage = BiosBootStage or 0})
end
---@param obj MBiosInfoTable.BiosBootStage
function TBiosBootStage:init_from_obj(obj)
    self.BiosBootStage = obj.BiosBootStage or 0
end

function TBiosBootStage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBiosBootStage.group)
end

TBiosBootStage.from_obj = TBiosBootStage_from_obj

TBiosBootStage.proto_property = {'BiosBootStage'}

TBiosBootStage.default = {0}

TBiosBootStage.struct = {{name = 'BiosBootStage', is_array = false, struct = nil}}

function TBiosBootStage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BiosBootStage', self.BiosBootStage, 'uint8', false, errs, need_convert)

    TBiosBootStage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBiosBootStage.proto_property, errs, need_convert)
    return self
end

function TBiosBootStage:unpack(_)
    return self.BiosBootStage
end

MBiosInfoTable.BiosBootStage = TBiosBootStage

---@class MBiosInfoTable.SystemStartupState
---@field SystemStartupState integer
local TSystemStartupState = {}
TSystemStartupState.__index = TSystemStartupState
TSystemStartupState.group = {}

local function TSystemStartupState_from_obj(obj)
    return setmetatable(obj, TSystemStartupState)
end

function TSystemStartupState.new(SystemStartupState)
    return TSystemStartupState_from_obj({SystemStartupState = SystemStartupState or 0})
end
---@param obj MBiosInfoTable.SystemStartupState
function TSystemStartupState:init_from_obj(obj)
    self.SystemStartupState = obj.SystemStartupState or 0
end

function TSystemStartupState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemStartupState.group)
end

TSystemStartupState.from_obj = TSystemStartupState_from_obj

TSystemStartupState.proto_property = {'SystemStartupState'}

TSystemStartupState.default = {0}

TSystemStartupState.struct = {{name = 'SystemStartupState', is_array = false, struct = nil}}

function TSystemStartupState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemStartupState', self.SystemStartupState, 'uint8', false, errs, need_convert)

    TSystemStartupState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemStartupState.proto_property, errs, need_convert)
    return self
end

function TSystemStartupState:unpack(_)
    return self.SystemStartupState
end

MBiosInfoTable.SystemStartupState = TSystemStartupState

---@class MBiosInfoTable.RegistryVersion
---@field RegistryVersion string
local TRegistryVersion = {}
TRegistryVersion.__index = TRegistryVersion
TRegistryVersion.group = {}

local function TRegistryVersion_from_obj(obj)
    return setmetatable(obj, TRegistryVersion)
end

function TRegistryVersion.new(RegistryVersion)
    return TRegistryVersion_from_obj({RegistryVersion = RegistryVersion or [=[V0.00]=]})
end
---@param obj MBiosInfoTable.RegistryVersion
function TRegistryVersion:init_from_obj(obj)
    self.RegistryVersion = obj.RegistryVersion or [=[V0.00]=]
end

function TRegistryVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRegistryVersion.group)
end

TRegistryVersion.from_obj = TRegistryVersion_from_obj

TRegistryVersion.proto_property = {'RegistryVersion'}

TRegistryVersion.default = {''}

TRegistryVersion.struct = {{name = 'RegistryVersion', is_array = false, struct = nil}}

function TRegistryVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RegistryVersion', self.RegistryVersion, 'string', false, errs, need_convert)

    TRegistryVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRegistryVersion.proto_property, errs, need_convert)
    return self
end

function TRegistryVersion:unpack(_)
    return self.RegistryVersion
end

MBiosInfoTable.RegistryVersion = TRegistryVersion

---@class MBiosInfoTable.BiosLogPrintEnabled
---@field BiosLogPrintEnabled integer
local TBiosLogPrintEnabled = {}
TBiosLogPrintEnabled.__index = TBiosLogPrintEnabled
TBiosLogPrintEnabled.group = {}

local function TBiosLogPrintEnabled_from_obj(obj)
    return setmetatable(obj, TBiosLogPrintEnabled)
end

function TBiosLogPrintEnabled.new(BiosLogPrintEnabled)
    return TBiosLogPrintEnabled_from_obj({BiosLogPrintEnabled = BiosLogPrintEnabled})
end
---@param obj MBiosInfoTable.BiosLogPrintEnabled
function TBiosLogPrintEnabled:init_from_obj(obj)
    self.BiosLogPrintEnabled = obj.BiosLogPrintEnabled
end

function TBiosLogPrintEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBiosLogPrintEnabled.group)
end

TBiosLogPrintEnabled.from_obj = TBiosLogPrintEnabled_from_obj

TBiosLogPrintEnabled.proto_property = {'BiosLogPrintEnabled'}

TBiosLogPrintEnabled.default = {0}

TBiosLogPrintEnabled.struct = {{name = 'BiosLogPrintEnabled', is_array = false, struct = nil}}

function TBiosLogPrintEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BiosLogPrintEnabled', self.BiosLogPrintEnabled, 'uint8', false, errs, need_convert)

    TBiosLogPrintEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBiosLogPrintEnabled.proto_property, errs, need_convert)
    return self
end

function TBiosLogPrintEnabled:unpack(_)
    return self.BiosLogPrintEnabled
end

MBiosInfoTable.BiosLogPrintEnabled = TBiosLogPrintEnabled

---@class MBiosInfoTable.RecoverFailed
---@field RecoverFailed integer
local TRecoverFailed = {}
TRecoverFailed.__index = TRecoverFailed
TRecoverFailed.group = {}

local function TRecoverFailed_from_obj(obj)
    return setmetatable(obj, TRecoverFailed)
end

function TRecoverFailed.new(RecoverFailed)
    return TRecoverFailed_from_obj({RecoverFailed = RecoverFailed})
end
---@param obj MBiosInfoTable.RecoverFailed
function TRecoverFailed:init_from_obj(obj)
    self.RecoverFailed = obj.RecoverFailed
end

function TRecoverFailed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecoverFailed.group)
end

TRecoverFailed.from_obj = TRecoverFailed_from_obj

TRecoverFailed.proto_property = {'RecoverFailed'}

TRecoverFailed.default = {0}

TRecoverFailed.struct = {{name = 'RecoverFailed', is_array = false, struct = nil}}

function TRecoverFailed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RecoverFailed', self.RecoverFailed, 'uint8', false, errs, need_convert)

    TRecoverFailed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecoverFailed.proto_property, errs, need_convert)
    return self
end

function TRecoverFailed:unpack(_)
    return self.RecoverFailed
end

MBiosInfoTable.RecoverFailed = TRecoverFailed

---@class MBiosInfoTable.UpgradeFailed
---@field UpgradeFailed integer
local TUpgradeFailed = {}
TUpgradeFailed.__index = TUpgradeFailed
TUpgradeFailed.group = {}

local function TUpgradeFailed_from_obj(obj)
    return setmetatable(obj, TUpgradeFailed)
end

function TUpgradeFailed.new(UpgradeFailed)
    return TUpgradeFailed_from_obj({UpgradeFailed = UpgradeFailed})
end
---@param obj MBiosInfoTable.UpgradeFailed
function TUpgradeFailed:init_from_obj(obj)
    self.UpgradeFailed = obj.UpgradeFailed
end

function TUpgradeFailed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeFailed.group)
end

TUpgradeFailed.from_obj = TUpgradeFailed_from_obj

TUpgradeFailed.proto_property = {'UpgradeFailed'}

TUpgradeFailed.default = {0}

TUpgradeFailed.struct = {{name = 'UpgradeFailed', is_array = false, struct = nil}}

function TUpgradeFailed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpgradeFailed', self.UpgradeFailed, 'uint8', false, errs, need_convert)

    TUpgradeFailed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeFailed.proto_property, errs, need_convert)
    return self
end

function TUpgradeFailed:unpack(_)
    return self.UpgradeFailed
end

MBiosInfoTable.UpgradeFailed = TUpgradeFailed

---@class MBiosInfoTable.UserNewSetupPassword
---@field UserNewSetupPassword string
local TUserNewSetupPassword = {}
TUserNewSetupPassword.__index = TUserNewSetupPassword
TUserNewSetupPassword.group = {}

local function TUserNewSetupPassword_from_obj(obj)
    return setmetatable(obj, TUserNewSetupPassword)
end

function TUserNewSetupPassword.new(UserNewSetupPassword)
    return TUserNewSetupPassword_from_obj({UserNewSetupPassword = UserNewSetupPassword})
end
---@param obj MBiosInfoTable.UserNewSetupPassword
function TUserNewSetupPassword:init_from_obj(obj)
    self.UserNewSetupPassword = obj.UserNewSetupPassword
end

function TUserNewSetupPassword:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUserNewSetupPassword.group)
end

TUserNewSetupPassword.from_obj = TUserNewSetupPassword_from_obj

TUserNewSetupPassword.proto_property = {'UserNewSetupPassword'}

TUserNewSetupPassword.default = {''}

TUserNewSetupPassword.struct = {{name = 'UserNewSetupPassword', is_array = false, struct = nil}}

function TUserNewSetupPassword:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UserNewSetupPassword', self.UserNewSetupPassword, 'string', false, errs, need_convert)

    TUserNewSetupPassword:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUserNewSetupPassword.proto_property, errs, need_convert)
    return self
end

function TUserNewSetupPassword:unpack(_)
    return self.UserNewSetupPassword
end

MBiosInfoTable.UserNewSetupPassword = TUserNewSetupPassword

---@class MBiosInfoTable.UserOldSetupPassword
---@field UserOldSetupPassword string
local TUserOldSetupPassword = {}
TUserOldSetupPassword.__index = TUserOldSetupPassword
TUserOldSetupPassword.group = {}

local function TUserOldSetupPassword_from_obj(obj)
    return setmetatable(obj, TUserOldSetupPassword)
end

function TUserOldSetupPassword.new(UserOldSetupPassword)
    return TUserOldSetupPassword_from_obj({UserOldSetupPassword = UserOldSetupPassword})
end
---@param obj MBiosInfoTable.UserOldSetupPassword
function TUserOldSetupPassword:init_from_obj(obj)
    self.UserOldSetupPassword = obj.UserOldSetupPassword
end

function TUserOldSetupPassword:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUserOldSetupPassword.group)
end

TUserOldSetupPassword.from_obj = TUserOldSetupPassword_from_obj

TUserOldSetupPassword.proto_property = {'UserOldSetupPassword'}

TUserOldSetupPassword.default = {''}

TUserOldSetupPassword.struct = {{name = 'UserOldSetupPassword', is_array = false, struct = nil}}

function TUserOldSetupPassword:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UserOldSetupPassword', self.UserOldSetupPassword, 'string', false, errs, need_convert)

    TUserOldSetupPassword:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUserOldSetupPassword.proto_property, errs, need_convert)
    return self
end

function TUserOldSetupPassword:unpack(_)
    return self.UserOldSetupPassword
end

MBiosInfoTable.UserOldSetupPassword = TUserOldSetupPassword

---@class MBiosInfoTable.NewSetupPassword
---@field NewSetupPassword string
local TNewSetupPassword = {}
TNewSetupPassword.__index = TNewSetupPassword
TNewSetupPassword.group = {}

local function TNewSetupPassword_from_obj(obj)
    return setmetatable(obj, TNewSetupPassword)
end

function TNewSetupPassword.new(NewSetupPassword)
    return TNewSetupPassword_from_obj({NewSetupPassword = NewSetupPassword})
end
---@param obj MBiosInfoTable.NewSetupPassword
function TNewSetupPassword:init_from_obj(obj)
    self.NewSetupPassword = obj.NewSetupPassword
end

function TNewSetupPassword:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewSetupPassword.group)
end

TNewSetupPassword.from_obj = TNewSetupPassword_from_obj

TNewSetupPassword.proto_property = {'NewSetupPassword'}

TNewSetupPassword.default = {''}

TNewSetupPassword.struct = {{name = 'NewSetupPassword', is_array = false, struct = nil}}

function TNewSetupPassword:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NewSetupPassword', self.NewSetupPassword, 'string', false, errs, need_convert)

    TNewSetupPassword:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewSetupPassword.proto_property, errs, need_convert)
    return self
end

function TNewSetupPassword:unpack(_)
    return self.NewSetupPassword
end

MBiosInfoTable.NewSetupPassword = TNewSetupPassword

---@class MBiosInfoTable.OldSetupPassword
---@field OldSetupPassword string
local TOldSetupPassword = {}
TOldSetupPassword.__index = TOldSetupPassword
TOldSetupPassword.group = {}

local function TOldSetupPassword_from_obj(obj)
    return setmetatable(obj, TOldSetupPassword)
end

function TOldSetupPassword.new(OldSetupPassword)
    return TOldSetupPassword_from_obj({OldSetupPassword = OldSetupPassword})
end
---@param obj MBiosInfoTable.OldSetupPassword
function TOldSetupPassword:init_from_obj(obj)
    self.OldSetupPassword = obj.OldSetupPassword
end

function TOldSetupPassword:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOldSetupPassword.group)
end

TOldSetupPassword.from_obj = TOldSetupPassword_from_obj

TOldSetupPassword.proto_property = {'OldSetupPassword'}

TOldSetupPassword.default = {''}

TOldSetupPassword.struct = {{name = 'OldSetupPassword', is_array = false, struct = nil}}

function TOldSetupPassword:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OldSetupPassword', self.OldSetupPassword, 'string', false, errs, need_convert)

    TOldSetupPassword:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOldSetupPassword.proto_property, errs, need_convert)
    return self
end

function TOldSetupPassword:unpack(_)
    return self.OldSetupPassword
end

MBiosInfoTable.OldSetupPassword = TOldSetupPassword

---@class MBiosInfoTable.BackupVersion
---@field BackupVersion string
local TBackupVersion = {}
TBackupVersion.__index = TBackupVersion
TBackupVersion.group = {}

local function TBackupVersion_from_obj(obj)
    return setmetatable(obj, TBackupVersion)
end

function TBackupVersion.new(BackupVersion)
    return TBackupVersion_from_obj({BackupVersion = BackupVersion})
end
---@param obj MBiosInfoTable.BackupVersion
function TBackupVersion:init_from_obj(obj)
    self.BackupVersion = obj.BackupVersion
end

function TBackupVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBackupVersion.group)
end

TBackupVersion.from_obj = TBackupVersion_from_obj

TBackupVersion.proto_property = {'BackupVersion'}

TBackupVersion.default = {''}

TBackupVersion.struct = {{name = 'BackupVersion', is_array = false, struct = nil}}

function TBackupVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BackupVersion', self.BackupVersion, 'string', false, errs, need_convert)

    TBackupVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBackupVersion.proto_property, errs, need_convert)
    return self
end

function TBackupVersion:unpack(_)
    return self.BackupVersion
end

MBiosInfoTable.BackupVersion = TBackupVersion

---@class MBiosInfoTable.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj MBiosInfoTable.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', false, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

MBiosInfoTable.Version = TVersion

---@class MBiosInfoTable.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MBiosInfoTable.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MBiosInfoTable.Id = TId

return MBiosInfoTable
