-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

local db_selector = {}

---@class EventMsgTable: Table
---@field Id FieldBase
---@field ComponentName FieldBase
---@field State FieldBase
---@field EventKeyId FieldBase
---@field MessageArgs FieldBase
---@field SystemId FieldBase
---@field ManagerId FieldBase
---@field ChassisId FieldBase
---@field NodeId FieldBase
---@field SubjectType FieldBase

---@class KrunFirmwareTable: Table
---@field Id FieldBase
---@field UId FieldBase
---@field Name FieldBase
---@field RefChip FieldBase
---@field Version FieldBase
---@field RelatedSystems FieldBase
---@field FlashChip FieldBase

---@class BiosDBDatabasePoweroff
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field EventMsg EventMsgTable
---@field KrunFirmware KrunFirmwareTable

local BiosDBDatabasePoweroff = {}
BiosDBDatabasePoweroff.__index = BiosDBDatabasePoweroff

function BiosDBDatabasePoweroff.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.EventMsg = db:Table('t_event_msg', {
        Id = Col.TextField():cid(1):primary_key(),
        ComponentName = Col.TextField():cid(2),
        State = Col.TextField():cid(3),
        EventKeyId = Col.TextField():cid(4),
        MessageArgs = Col.TextField():cid(5),
        SystemId = Col.TextField():cid(6),
        ManagerId = Col.TextField():cid(7),
        ChassisId = Col.TextField():cid(8),
        NodeId = Col.TextField():cid(9),
        SubjectType = Col.TextField():cid(10)
    }):create_if_not_exist(datas and datas['t_event_msg'])
    obj.KrunFirmware = db:Table('t_krun_info', {
        Id = Col.IntegerField():cid(1):primary_key():max_length(8),
        UId = Col.TextField():cid(2):null(),
        Name = Col.TextField():cid(3):null(),
        RefChip = Col.JsonField():cid(4):null(),
        Version = Col.TextField():cid(5):null(),
        RelatedSystems = Col.JsonField():cid(6):null(),
        FlashChip = Col.JsonField():extend_field():cid(7):null()
    }):create_if_not_exist(datas and datas['t_krun_info'])

    obj.tables = db.tables
    return setmetatable(obj, BiosDBDatabasePoweroff)
end

function BiosDBDatabasePoweroff:select(table, ...)
    return self.db:select(table, ...)
end

function BiosDBDatabasePoweroff:update(table, ...)
    return self.db:update(table, ...)
end

function BiosDBDatabasePoweroff:insert(table, ...)
    return self.db:insert(table, ...)
end

function BiosDBDatabasePoweroff:delete(table, ...)
    return self.db:delete(table, ...)
end

function BiosDBDatabasePoweroff:exec(...)
    return self.db:exec(...)
end

db_selector['poweroff'] = BiosDBDatabasePoweroff.new

---@class SystemInfoTableTable: Table
---@field SystemId FieldBase
---@field SystemFirmwareVersion FieldBase
---@field SystemName FieldBase
---@field PrimaryOperatingSystemName FieldBase
---@field OperatingSystemName FieldBase
---@field PresentOSVersionNumber FieldBase
---@field BMCUrl FieldBase
---@field BaseOsUrlForManageability FieldBase

---@class BiosDBDatabaseReset
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field SystemInfoTable SystemInfoTableTable

local BiosDBDatabaseReset = {}
BiosDBDatabaseReset.__index = BiosDBDatabaseReset

function BiosDBDatabaseReset.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.SystemInfoTable = db:Table('t_system_info', {
        SystemId = Col.IntegerField():cid(1):primary_key():max_length(8),
        SystemFirmwareVersion = Col.TextField():cid(2):null(),
        SystemName = Col.TextField():cid(3):null(),
        PrimaryOperatingSystemName = Col.TextField():cid(4):null(),
        OperatingSystemName = Col.TextField():cid(5):null(),
        PresentOSVersionNumber = Col.TextField():cid(6):null(),
        BMCUrl = Col.TextField():cid(7):null(),
        BaseOsUrlForManageability = Col.TextField():cid(8):null()
    }):create_if_not_exist(datas and datas['t_system_info'])

    obj.tables = db.tables
    return setmetatable(obj, BiosDBDatabaseReset)
end

function BiosDBDatabaseReset:select(table, ...)
    return self.db:select(table, ...)
end

function BiosDBDatabaseReset:update(table, ...)
    return self.db:update(table, ...)
end

function BiosDBDatabaseReset:insert(table, ...)
    return self.db:insert(table, ...)
end

function BiosDBDatabaseReset:delete(table, ...)
    return self.db:delete(table, ...)
end

function BiosDBDatabaseReset:exec(...)
    return self.db:exec(...)
end

db_selector['reset'] = BiosDBDatabaseReset.new

local BiosDBDatabase = {}
BiosDBDatabase.__index = BiosDBDatabase

function BiosDBDatabase.new(path, datas, type)
    return db_selector[type] and db_selector[type](path, datas) or nil
end

return BiosDBDatabase.new
