-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Watchdog2Status = {}

Watchdog2Status.interface = mdb.register_interface('bmc.kepler.Watchdog2.Status', {
    DoNotLog = {'y', nil, true, nil},
    TimerUse = {'y', nil, true, nil},
    TimerUseStr = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    SystemStartupState = {'y', {['emitsChangedSignal'] = 'false'}, false, nil},
    Running = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    PreTimeoutInterruptFlag = {'y', nil, true, nil},
    PreTimeoutInterruptType = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    PreTimeoutInterruptEnabled = {'b', {['emitsChangedSignal'] = 'false'}, true, nil},
    PreTimeoutInterruptInterval = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    TimeoutAction = {'y', nil, true, nil},
    OEMExpirationFlag = {'y', nil, true, nil},
    SMSExpirationFlag = {'y', nil, true, nil},
    OSLoadExpirationFlag = {'y', nil, true, nil},
    BIOSPOSTExpirationFlag = {'y', nil, true, nil},
    BIOSFRB2ExpirationFlag = {'y', nil, true, nil},
    InitialCountdown = {'q', {['emitsChangedSignal'] = 'false'}, true, nil},
    PresentCountdown = {'q', {['emitsChangedSignal'] = 'false'}, true, nil},
    BIOSFailToStartFlag = {'y', nil, true, nil},
    ExpirationEventData = {'u', nil, true, nil}
}, {}, {})

return Watchdog2Status
