-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SystemFirmwareProgressStatus = {}

---@class SystemFirmwareProgressStatus.VideoError
---@field VideoError integer
local TVideoError = {}
TVideoError.__index = TVideoError
TVideoError.group = {}

local function TVideoError_from_obj(obj)
    return setmetatable(obj, TVideoError)
end

function TVideoError.new(VideoError)
    return TVideoError_from_obj({VideoError = VideoError})
end
---@param obj SystemFirmwareProgressStatus.VideoError
function TVideoError:init_from_obj(obj)
    self.VideoError = obj.VideoError
end

function TVideoError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVideoError.group)
end

TVideoError.from_obj = TVideoError_from_obj

TVideoError.proto_property = {'VideoError'}

TVideoError.default = {0}

TVideoError.struct = {{name = 'VideoError', is_array = false, struct = nil}}

function TVideoError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VideoError', self.VideoError, 'uint8', true, errs, need_convert)

    TVideoError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVideoError.proto_property, errs, need_convert)
    return self
end

function TVideoError:unpack(_)
    return self.VideoError
end

SystemFirmwareProgressStatus.VideoError = TVideoError

---@class SystemFirmwareProgressStatus.KBCError
---@field KBCError integer
local TKBCError = {}
TKBCError.__index = TKBCError
TKBCError.group = {}

local function TKBCError_from_obj(obj)
    return setmetatable(obj, TKBCError)
end

function TKBCError.new(KBCError)
    return TKBCError_from_obj({KBCError = KBCError})
end
---@param obj SystemFirmwareProgressStatus.KBCError
function TKBCError:init_from_obj(obj)
    self.KBCError = obj.KBCError
end

function TKBCError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TKBCError.group)
end

TKBCError.from_obj = TKBCError_from_obj

TKBCError.proto_property = {'KBCError'}

TKBCError.default = {0}

TKBCError.struct = {{name = 'KBCError', is_array = false, struct = nil}}

function TKBCError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'KBCError', self.KBCError, 'uint8', true, errs, need_convert)

    TKBCError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TKBCError.proto_property, errs, need_convert)
    return self
end

function TKBCError:unpack(_)
    return self.KBCError
end

SystemFirmwareProgressStatus.KBCError = TKBCError

SystemFirmwareProgressStatus.interface = mdb.register_interface('bmc.kepler.Systems.SystemFirmwareProgress.Status', {
    KBCError = {'y', {'EMIT_CHANGE'}, true, nil},
    VideoError = {'y', {'EMIT_CHANGE'}, true, nil}
}, {}, {})

return SystemFirmwareProgressStatus
