-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Processor = {}

Processor.interface = mdb.register_interface('bmc.kepler.Systems.Processor', {
    ProcessorType = {'s', nil, true, nil},
    SystemId = {'y', nil, true, nil},
    Id = {'y', nil, true, nil},
    Name = {'s', nil, true, nil},
    Presence = {'y', nil, true, nil},
    InstructionSet = {'s', nil, true, nil},
    Architecture = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    Family = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    Model = {'s', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    SN = {'s', nil, true, nil},
    FirmwareVersion = {'s', nil, true, nil},
    SocketDesignation = {'s', nil, true, nil},
    Position = {'s', nil, true, nil},
    ThermalTrip = {'y', nil, false, nil},
    Health = {'y', nil, true, nil},
    Replaceable = {'b', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {}, {})

return Processor
