-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PowerOnLock = {}

---@class PowerOnLock.SetPowerOnLockRsp
---@field CmdResult integer
local TSetPowerOnLockRsp = {}
TSetPowerOnLockRsp.__index = TSetPowerOnLockRsp
TSetPowerOnLockRsp.group = {}

local function TSetPowerOnLockRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerOnLockRsp)
end

function TSetPowerOnLockRsp.new(CmdResult)
    return TSetPowerOnLockRsp_from_obj({CmdResult = CmdResult})
end
---@param obj PowerOnLock.SetPowerOnLockRsp
function TSetPowerOnLockRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TSetPowerOnLockRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerOnLockRsp.group)
end

TSetPowerOnLockRsp.from_obj = TSetPowerOnLockRsp_from_obj

TSetPowerOnLockRsp.proto_property = {'CmdResult'}

TSetPowerOnLockRsp.default = {0}

TSetPowerOnLockRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TSetPowerOnLockRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'uint8', false, errs, need_convert)

    TSetPowerOnLockRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerOnLockRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerOnLockRsp:unpack(_)
    return self.CmdResult
end

PowerOnLock.SetPowerOnLockRsp = TSetPowerOnLockRsp

---@class PowerOnLock.SetPowerOnLockReq
---@field PwrOnLocked boolean
---@field Timeout integer
---@field AppName string
---@field Reason string
local TSetPowerOnLockReq = {}
TSetPowerOnLockReq.__index = TSetPowerOnLockReq
TSetPowerOnLockReq.group = {}

local function TSetPowerOnLockReq_from_obj(obj)
    return setmetatable(obj, TSetPowerOnLockReq)
end

function TSetPowerOnLockReq.new(PwrOnLocked, Timeout, AppName, Reason)
    return TSetPowerOnLockReq_from_obj({
        PwrOnLocked = PwrOnLocked,
        Timeout = Timeout,
        AppName = AppName,
        Reason = Reason
    })
end
---@param obj PowerOnLock.SetPowerOnLockReq
function TSetPowerOnLockReq:init_from_obj(obj)
    self.PwrOnLocked = obj.PwrOnLocked
    self.Timeout = obj.Timeout
    self.AppName = obj.AppName
    self.Reason = obj.Reason
end

function TSetPowerOnLockReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerOnLockReq.group)
end

TSetPowerOnLockReq.from_obj = TSetPowerOnLockReq_from_obj

TSetPowerOnLockReq.proto_property = {'PwrOnLocked', 'Timeout', 'AppName', 'Reason'}

TSetPowerOnLockReq.default = {false, 0, '', ''}

TSetPowerOnLockReq.struct = {
    {name = 'PwrOnLocked', is_array = false, struct = nil}, {name = 'Timeout', is_array = false, struct = nil},
    {name = 'AppName', is_array = false, struct = nil}, {name = 'Reason', is_array = false, struct = nil}
}

function TSetPowerOnLockReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PwrOnLocked', self.PwrOnLocked, 'bool', false, errs, need_convert)
    validate.Optional(prefix .. 'Timeout', self.Timeout, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'AppName', self.AppName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Reason', self.Reason, 'string', false, errs, need_convert)

    TSetPowerOnLockReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerOnLockReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerOnLockReq:unpack(_)
    return self.PwrOnLocked, self.Timeout, self.AppName, self.Reason
end

PowerOnLock.SetPowerOnLockReq = TSetPowerOnLockReq

PowerOnLock.interface = mdb.register_interface('bmc.kepler.Systems.PowerOnLock', {
    PwrOnLocked = {'b', {['emitsChangedSignal'] = 'false'}, true, nil},
    Reasons = {'as', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {SetPowerOnLock = {'a{ss}buss', 'y', TSetPowerOnLockReq, TSetPowerOnLockRsp}}, {})

return PowerOnLock
