-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Memory = {}

Memory.interface = mdb.register_interface('bmc.kepler.Systems.Memory', {
    SystemId = {'y', nil, true, nil},
    Name = {'s', nil, true, nil},
    DimmName = {'s', nil, true, nil},
    Presence = {'y', nil, true, nil},
    CpuId = {'y', nil, true, nil},
    NodeId = {'y', nil, true, nil},
    ChannelId = {'y', nil, true, nil},
    LogicalChannelId = {'y', nil, true, nil},
    DimmId = {'y', nil, true, nil},
    AllowedSpeedsMHz = {'u', {['emitsChangedSignal'] = 'true'}, true, nil},
    BaseModuleType = {'s', nil, true, nil},
    CapacityMiB = {'u', nil, true, nil},
    DataWidthBits = {'u', nil, true, nil},
    FirmwareRevision = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    DramManufacturer = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    MemoryDeviceType = {'s', nil, true, nil},
    MemorySubsystemControllerManufacturerID = {'s', nil, true, nil},
    MemorySubsystemControllerProductID = {'s', nil, true, nil},
    MemoryType = {'s', nil, true, nil},
    OperatingSpeedMhz = {'u', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    OriginalPartNumber = {'s', nil, true, nil},
    RankCount = {'u', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    MinVoltageMillivolt = {'u', nil, true, nil},
    Position = {'s', nil, true, nil},
    DiagnosticFault = {'y', nil, false, 0},
    PredictiveFault = {'y', nil, true, 0},
    DeviceLocator = {'s', nil, true, nil},
    Health = {'y', nil, true, nil},
    DimmNum = {'y', nil, true, nil},
    BOM = {'s', nil, true, nil},
    ManufacturerID = {'s', nil, true, nil},
    ManufacturingDate = {'s', nil, true, nil},
    ManufacturingLocation = {'s', {['emitsChangedSignal'] = 'true'}, true, nil},
    ChipBitWidth = {'s', nil, true, nil},
    TemperatureCelsius = {'d', {['emitsChangedSignal'] = 'true'}, true, nil},
    SilkText = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    ErrorCorrection = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    Technology = {'s', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {}, {})

return Memory
