-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local IPMIEvent = {}

---@class IPMIEvent.EventData
---@field EventData integer
local TEventData = {}
TEventData.__index = TEventData
TEventData.group = {}

local function TEventData_from_obj(obj)
    return setmetatable(obj, TEventData)
end

function TEventData.new(EventData)
    return TEventData_from_obj({EventData = EventData or 4294967295})
end
---@param obj IPMIEvent.EventData
function TEventData:init_from_obj(obj)
    self.EventData = obj.EventData or 4294967295
end

function TEventData:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventData.group)
end

TEventData.from_obj = TEventData_from_obj

TEventData.proto_property = {'EventData'}

TEventData.default = {0}

TEventData.struct = {{name = 'EventData', is_array = false, struct = nil}}

function TEventData:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EventData', self.EventData, 'uint32', true, errs, need_convert)

    TEventData:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventData.proto_property, errs, need_convert)
    return self
end

function TEventData:unpack(_)
    return self.EventData
end

IPMIEvent.EventData = TEventData

---@class IPMIEvent.ReadingType
---@field ReadingType integer
local TReadingType = {}
TReadingType.__index = TReadingType
TReadingType.group = {}

local function TReadingType_from_obj(obj)
    return setmetatable(obj, TReadingType)
end

function TReadingType.new(ReadingType)
    return TReadingType_from_obj({ReadingType = ReadingType or 111})
end
---@param obj IPMIEvent.ReadingType
function TReadingType:init_from_obj(obj)
    self.ReadingType = obj.ReadingType or 111
end

function TReadingType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadingType.group)
end

TReadingType.from_obj = TReadingType_from_obj

TReadingType.proto_property = {'ReadingType'}

TReadingType.default = {0}

TReadingType.struct = {{name = 'ReadingType', is_array = false, struct = nil}}

function TReadingType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadingType', self.ReadingType, 'uint8', true, errs, need_convert)

    TReadingType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadingType.proto_property, errs, need_convert)
    return self
end

function TReadingType:unpack(_)
    return self.ReadingType
end

IPMIEvent.ReadingType = TReadingType

---@class IPMIEvent.SensorType
---@field SensorType integer
local TSensorType = {}
TSensorType.__index = TSensorType
TSensorType.group = {}

local function TSensorType_from_obj(obj)
    return setmetatable(obj, TSensorType)
end

function TSensorType.new(SensorType)
    return TSensorType_from_obj({SensorType = SensorType or 31})
end
---@param obj IPMIEvent.SensorType
function TSensorType:init_from_obj(obj)
    self.SensorType = obj.SensorType or 31
end

function TSensorType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorType.group)
end

TSensorType.from_obj = TSensorType_from_obj

TSensorType.proto_property = {'SensorType'}

TSensorType.default = {0}

TSensorType.struct = {{name = 'SensorType', is_array = false, struct = nil}}

function TSensorType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorType', self.SensorType, 'uint8', true, errs, need_convert)

    TSensorType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorType.proto_property, errs, need_convert)
    return self
end

function TSensorType:unpack(_)
    return self.SensorType
end

IPMIEvent.SensorType = TSensorType

IPMIEvent.interface = mdb.register_interface('bmc.kepler.Systems.IPMIEvent', {
    SensorType = {'y', {'CONST'}, true, 31},
    ReadingType = {'y', {}, true, 111},
    EventData = {'u', nil, true, 4294967295}
}, {}, {})

return IPMIEvent
