-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local FirmwareActive = {}

---@class FirmwareActive.Object
---@field key string
---@field value string
local TObject = {}
TObject.__index = TObject
TObject.group = {}

local function TObject_from_obj(obj)
    return setmetatable(obj, TObject)
end

function TObject.new(dict)
    return TObject_from_obj(dict)
end

---@param obj FirmwareActive.Object
function TObject:init_from_obj(obj)
    self = obj
end

function TObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TObject.group)
end

TObject.from_obj = TObject_from_obj

TObject.proto_property = {}

TObject.default = {}

TObject.struct = {}

function TObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TObject:remove_error_props(errs, self)
    return self
end

function TObject:unpack(_)
    return self
end

FirmwareActive.Object = TObject

---@class FirmwareActive.KeyValueTable
---@field Key string
---@field Value string
local TKeyValueTable = {}
TKeyValueTable.__index = TKeyValueTable
TKeyValueTable.group = {}

local function TKeyValueTable_from_obj(obj)
    return setmetatable(obj, TKeyValueTable)
end

function TKeyValueTable.new(Key, Value)
    return TKeyValueTable_from_obj({Key = Key, Value = Value})
end
---@param obj FirmwareActive.KeyValueTable
function TKeyValueTable:init_from_obj(obj)
    self.Key = obj.Key
    self.Value = obj.Value
end

function TKeyValueTable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TKeyValueTable.group)
end

TKeyValueTable.from_obj = TKeyValueTable_from_obj

TKeyValueTable.proto_property = {'Key', 'Value'}

TKeyValueTable.default = {'', ''}

TKeyValueTable.struct = {
    {name = 'Key', is_array = false, struct = nil}, {name = 'Value', is_array = false, struct = nil}
}

function TKeyValueTable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Key', self.Key, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Value', self.Value, 'string', false, errs, need_convert)

    TKeyValueTable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TKeyValueTable.proto_property, errs, need_convert)
    return self
end

function TKeyValueTable:unpack(_)
    return self.Key, self.Value
end

FirmwareActive.KeyValueTable = TKeyValueTable

---@class FirmwareActive.ActiveProcessReplyRsp
local TActiveProcessReplyRsp = {}
TActiveProcessReplyRsp.__index = TActiveProcessReplyRsp
TActiveProcessReplyRsp.group = {}

local function TActiveProcessReplyRsp_from_obj(obj)
    return setmetatable(obj, TActiveProcessReplyRsp)
end

function TActiveProcessReplyRsp.new()
    return TActiveProcessReplyRsp_from_obj({})
end
---@param obj FirmwareActive.ActiveProcessReplyRsp
function TActiveProcessReplyRsp:init_from_obj(obj)

end

function TActiveProcessReplyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActiveProcessReplyRsp.group)
end

TActiveProcessReplyRsp.from_obj = TActiveProcessReplyRsp_from_obj

TActiveProcessReplyRsp.proto_property = {}

TActiveProcessReplyRsp.default = {}

TActiveProcessReplyRsp.struct = {}

function TActiveProcessReplyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TActiveProcessReplyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActiveProcessReplyRsp.proto_property, errs, need_convert)
    return self
end

function TActiveProcessReplyRsp:unpack(_)
end

FirmwareActive.ActiveProcessReplyRsp = TActiveProcessReplyRsp

---@class FirmwareActive.ActiveProcessReplyReq
---@field SystemId integer
---@field FirmwareType string
---@field ProcessResult integer
local TActiveProcessReplyReq = {}
TActiveProcessReplyReq.__index = TActiveProcessReplyReq
TActiveProcessReplyReq.group = {}

local function TActiveProcessReplyReq_from_obj(obj)
    return setmetatable(obj, TActiveProcessReplyReq)
end

function TActiveProcessReplyReq.new(SystemId, FirmwareType, ProcessResult)
    return TActiveProcessReplyReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        ProcessResult = ProcessResult
    })
end
---@param obj FirmwareActive.ActiveProcessReplyReq
function TActiveProcessReplyReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.ProcessResult = obj.ProcessResult
end

function TActiveProcessReplyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActiveProcessReplyReq.group)
end

TActiveProcessReplyReq.from_obj = TActiveProcessReplyReq_from_obj

TActiveProcessReplyReq.proto_property = {'SystemId', 'FirmwareType', 'ProcessResult'}

TActiveProcessReplyReq.default = {0, '', 0}

TActiveProcessReplyReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'ProcessResult', is_array = false, struct = nil}
}

function TActiveProcessReplyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'ProcessResult', self.ProcessResult, 'int32', false, errs, need_convert)

    TActiveProcessReplyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActiveProcessReplyReq.proto_property, errs, need_convert)
    return self
end

function TActiveProcessReplyReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.ProcessResult
end

FirmwareActive.ActiveProcessReplyReq = TActiveProcessReplyReq

---@class FirmwareActive.UpdateActiveStatusRsp
local TUpdateActiveStatusRsp = {}
TUpdateActiveStatusRsp.__index = TUpdateActiveStatusRsp
TUpdateActiveStatusRsp.group = {}

local function TUpdateActiveStatusRsp_from_obj(obj)
    return setmetatable(obj, TUpdateActiveStatusRsp)
end

function TUpdateActiveStatusRsp.new()
    return TUpdateActiveStatusRsp_from_obj({})
end
---@param obj FirmwareActive.UpdateActiveStatusRsp
function TUpdateActiveStatusRsp:init_from_obj(obj)

end

function TUpdateActiveStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateActiveStatusRsp.group)
end

TUpdateActiveStatusRsp.from_obj = TUpdateActiveStatusRsp_from_obj

TUpdateActiveStatusRsp.proto_property = {}

TUpdateActiveStatusRsp.default = {}

TUpdateActiveStatusRsp.struct = {}

function TUpdateActiveStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TUpdateActiveStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateActiveStatusRsp.proto_property, errs, need_convert)
    return self
end

function TUpdateActiveStatusRsp:unpack(_)
end

FirmwareActive.UpdateActiveStatusRsp = TUpdateActiveStatusRsp

---@class FirmwareActive.UpdateActiveStatusReq
---@field ActiveStatus FirmwareActive.KeyValueTable[]
local TUpdateActiveStatusReq = {}
TUpdateActiveStatusReq.__index = TUpdateActiveStatusReq
TUpdateActiveStatusReq.group = {}

local function TUpdateActiveStatusReq_from_obj(obj)
    obj.ActiveStatus = utils.from_obj(FirmwareActive.KeyValueTable, obj.ActiveStatus, true)
    return setmetatable(obj, TUpdateActiveStatusReq)
end

function TUpdateActiveStatusReq.new(ActiveStatus)
    return TUpdateActiveStatusReq_from_obj({ActiveStatus = ActiveStatus})
end
---@param obj FirmwareActive.UpdateActiveStatusReq
function TUpdateActiveStatusReq:init_from_obj(obj)
    self.ActiveStatus = obj.ActiveStatus
end

function TUpdateActiveStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateActiveStatusReq.group)
end

TUpdateActiveStatusReq.from_obj = TUpdateActiveStatusReq_from_obj

TUpdateActiveStatusReq.proto_property = {'ActiveStatus'}

TUpdateActiveStatusReq.default = {{}}

TUpdateActiveStatusReq.struct = {{name = 'ActiveStatus', is_array = true, struct = FirmwareActive.KeyValueTable.struct}}

function TUpdateActiveStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.ActiveStatus) do
        FirmwareActive.KeyValueTable.new(v.Key, v.Value):validate(prefix, errs, need_convert)
    end

    TUpdateActiveStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateActiveStatusReq.proto_property, errs, need_convert)
    return self
end

function TUpdateActiveStatusReq:unpack(raw)
    return utils.unpack(raw, self.ActiveStatus, true)
end

FirmwareActive.UpdateActiveStatusReq = TUpdateActiveStatusReq

---@class FirmwareActive.RegisterActiveActionRsp
local TRegisterActiveActionRsp = {}
TRegisterActiveActionRsp.__index = TRegisterActiveActionRsp
TRegisterActiveActionRsp.group = {}

local function TRegisterActiveActionRsp_from_obj(obj)
    return setmetatable(obj, TRegisterActiveActionRsp)
end

function TRegisterActiveActionRsp.new()
    return TRegisterActiveActionRsp_from_obj({})
end
---@param obj FirmwareActive.RegisterActiveActionRsp
function TRegisterActiveActionRsp:init_from_obj(obj)

end

function TRegisterActiveActionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRegisterActiveActionRsp.group)
end

TRegisterActiveActionRsp.from_obj = TRegisterActiveActionRsp_from_obj

TRegisterActiveActionRsp.proto_property = {}

TRegisterActiveActionRsp.default = {}

TRegisterActiveActionRsp.struct = {}

function TRegisterActiveActionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TRegisterActiveActionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRegisterActiveActionRsp.proto_property, errs, need_convert)
    return self
end

function TRegisterActiveActionRsp:unpack(_)
end

FirmwareActive.RegisterActiveActionRsp = TRegisterActiveActionRsp

---@class FirmwareActive.RegisterActiveActionReq
---@field ActiveAction FirmwareActive.KeyValueTable[]
local TRegisterActiveActionReq = {}
TRegisterActiveActionReq.__index = TRegisterActiveActionReq
TRegisterActiveActionReq.group = {}

local function TRegisterActiveActionReq_from_obj(obj)
    obj.ActiveAction = utils.from_obj(FirmwareActive.KeyValueTable, obj.ActiveAction, true)
    return setmetatable(obj, TRegisterActiveActionReq)
end

function TRegisterActiveActionReq.new(ActiveAction)
    return TRegisterActiveActionReq_from_obj({ActiveAction = ActiveAction})
end
---@param obj FirmwareActive.RegisterActiveActionReq
function TRegisterActiveActionReq:init_from_obj(obj)
    self.ActiveAction = obj.ActiveAction
end

function TRegisterActiveActionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRegisterActiveActionReq.group)
end

TRegisterActiveActionReq.from_obj = TRegisterActiveActionReq_from_obj

TRegisterActiveActionReq.proto_property = {'ActiveAction'}

TRegisterActiveActionReq.default = {{}}

TRegisterActiveActionReq.struct = {
    {name = 'ActiveAction', is_array = true, struct = FirmwareActive.KeyValueTable.struct}
}

function TRegisterActiveActionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.ActiveAction) do
        FirmwareActive.KeyValueTable.new(v.Key, v.Value):validate(prefix, errs, need_convert)
    end

    TRegisterActiveActionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRegisterActiveActionReq.proto_property, errs, need_convert)
    return self
end

function TRegisterActiveActionReq:unpack(raw)
    return utils.unpack(raw, self.ActiveAction, true)
end

FirmwareActive.RegisterActiveActionReq = TRegisterActiveActionReq

---@class FirmwareActive.StartActiveWithPolicyRsp
---@field TaskId integer
local TStartActiveWithPolicyRsp = {}
TStartActiveWithPolicyRsp.__index = TStartActiveWithPolicyRsp
TStartActiveWithPolicyRsp.group = {}

local function TStartActiveWithPolicyRsp_from_obj(obj)
    return setmetatable(obj, TStartActiveWithPolicyRsp)
end

function TStartActiveWithPolicyRsp.new(TaskId)
    return TStartActiveWithPolicyRsp_from_obj({TaskId = TaskId})
end
---@param obj FirmwareActive.StartActiveWithPolicyRsp
function TStartActiveWithPolicyRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TStartActiveWithPolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartActiveWithPolicyRsp.group)
end

TStartActiveWithPolicyRsp.from_obj = TStartActiveWithPolicyRsp_from_obj

TStartActiveWithPolicyRsp.proto_property = {'TaskId'}

TStartActiveWithPolicyRsp.default = {0}

TStartActiveWithPolicyRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TStartActiveWithPolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TStartActiveWithPolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartActiveWithPolicyRsp.proto_property, errs, need_convert)
    return self
end

function TStartActiveWithPolicyRsp:unpack(_)
    return self.TaskId
end

FirmwareActive.StartActiveWithPolicyRsp = TStartActiveWithPolicyRsp

---@class FirmwareActive.StartActiveWithPolicyReq
---@field SystemId integer
---@field AdditionalOptions FirmwareActive.Object
local TStartActiveWithPolicyReq = {}
TStartActiveWithPolicyReq.__index = TStartActiveWithPolicyReq
TStartActiveWithPolicyReq.group = {}

local function TStartActiveWithPolicyReq_from_obj(obj)
    return setmetatable(obj, TStartActiveWithPolicyReq)
end

function TStartActiveWithPolicyReq.new(SystemId, AdditionalOptions)
    return TStartActiveWithPolicyReq_from_obj({SystemId = SystemId, AdditionalOptions = AdditionalOptions})
end
---@param obj FirmwareActive.StartActiveWithPolicyReq
function TStartActiveWithPolicyReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.AdditionalOptions = obj.AdditionalOptions
end

function TStartActiveWithPolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartActiveWithPolicyReq.group)
end

TStartActiveWithPolicyReq.from_obj = TStartActiveWithPolicyReq_from_obj

TStartActiveWithPolicyReq.proto_property = {'SystemId', 'AdditionalOptions'}

TStartActiveWithPolicyReq.default = {0, FirmwareActive.Object.default}

TStartActiveWithPolicyReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'AdditionalOptions', is_array = false, struct = FirmwareActive.Object.struct}
}

function TStartActiveWithPolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    FirmwareActive.Object.new(self.AdditionalOptions):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)

    TStartActiveWithPolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartActiveWithPolicyReq.proto_property, errs, need_convert)
    return self
end

function TStartActiveWithPolicyReq:unpack(_)
    return self.SystemId, self.AdditionalOptions
end

FirmwareActive.StartActiveWithPolicyReq = TStartActiveWithPolicyReq

---@class FirmwareActive.StartActiveRsp
---@field TaskId integer
local TStartActiveRsp = {}
TStartActiveRsp.__index = TStartActiveRsp
TStartActiveRsp.group = {}

local function TStartActiveRsp_from_obj(obj)
    return setmetatable(obj, TStartActiveRsp)
end

function TStartActiveRsp.new(TaskId)
    return TStartActiveRsp_from_obj({TaskId = TaskId})
end
---@param obj FirmwareActive.StartActiveRsp
function TStartActiveRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TStartActiveRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartActiveRsp.group)
end

TStartActiveRsp.from_obj = TStartActiveRsp_from_obj

TStartActiveRsp.proto_property = {'TaskId'}

TStartActiveRsp.default = {0}

TStartActiveRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TStartActiveRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TStartActiveRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartActiveRsp.proto_property, errs, need_convert)
    return self
end

function TStartActiveRsp:unpack(_)
    return self.TaskId
end

FirmwareActive.StartActiveRsp = TStartActiveRsp

---@class FirmwareActive.StartActiveReq
---@field SystemId integer
local TStartActiveReq = {}
TStartActiveReq.__index = TStartActiveReq
TStartActiveReq.group = {}

local function TStartActiveReq_from_obj(obj)
    return setmetatable(obj, TStartActiveReq)
end

function TStartActiveReq.new(SystemId)
    return TStartActiveReq_from_obj({SystemId = SystemId})
end
---@param obj FirmwareActive.StartActiveReq
function TStartActiveReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TStartActiveReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartActiveReq.group)
end

TStartActiveReq.from_obj = TStartActiveReq_from_obj

TStartActiveReq.proto_property = {'SystemId'}

TStartActiveReq.default = {0}

TStartActiveReq.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TStartActiveReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)

    TStartActiveReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartActiveReq.proto_property, errs, need_convert)
    return self
end

function TStartActiveReq:unpack(_)
    return self.SystemId
end

FirmwareActive.StartActiveReq = TStartActiveReq

FirmwareActive.interface = mdb.register_interface('bmc.kepler.UpdateService.FirmwareActive', {}, {
    StartActive = {'a{ss}i', 'u', TStartActiveReq, TStartActiveRsp},
    StartActiveWithPolicy = {'a{ss}ia{ss}', 'u', TStartActiveWithPolicyReq, TStartActiveWithPolicyRsp},
    RegisterActiveAction = {'a{ss}a(ss)', '', TRegisterActiveActionReq, TRegisterActiveActionRsp},
    UpdateActiveStatus = {'a{ss}a(ss)', '', TUpdateActiveStatusReq, TUpdateActiveStatusRsp},
    ActiveProcessReply = {'a{ss}isi', '', TActiveProcessReplyReq, TActiveProcessReplyRsp}
}, {ActiveProcessSignal = 'a{ss}is'})

return FirmwareActive
