-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Config = {}

---@class Config.SetStandardDigestRsp
local TSetStandardDigestRsp = {}
TSetStandardDigestRsp.__index = TSetStandardDigestRsp
TSetStandardDigestRsp.group = {}

local function TSetStandardDigestRsp_from_obj(obj)
    return setmetatable(obj, TSetStandardDigestRsp)
end

function TSetStandardDigestRsp.new()
    return TSetStandardDigestRsp_from_obj({})
end
---@param obj Config.SetStandardDigestRsp
function TSetStandardDigestRsp:init_from_obj(obj)

end

function TSetStandardDigestRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStandardDigestRsp.group)
end

TSetStandardDigestRsp.from_obj = TSetStandardDigestRsp_from_obj

TSetStandardDigestRsp.proto_property = {}

TSetStandardDigestRsp.default = {}

TSetStandardDigestRsp.struct = {}

function TSetStandardDigestRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetStandardDigestRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStandardDigestRsp.proto_property, errs, need_convert)
    return self
end

function TSetStandardDigestRsp:unpack(_)
end

Config.SetStandardDigestRsp = TSetStandardDigestRsp

---@class Config.SetStandardDigestReq
---@field HostingSystemId integer
---@field VMIds string[]
---@field MeasureObject string
---@field StandardDigest string
local TSetStandardDigestReq = {}
TSetStandardDigestReq.__index = TSetStandardDigestReq
TSetStandardDigestReq.group = {}

local function TSetStandardDigestReq_from_obj(obj)
    return setmetatable(obj, TSetStandardDigestReq)
end

function TSetStandardDigestReq.new(HostingSystemId, VMIds, MeasureObject, StandardDigest)
    return TSetStandardDigestReq_from_obj({
        HostingSystemId = HostingSystemId,
        VMIds = VMIds,
        MeasureObject = MeasureObject,
        StandardDigest = StandardDigest
    })
end
---@param obj Config.SetStandardDigestReq
function TSetStandardDigestReq:init_from_obj(obj)
    self.HostingSystemId = obj.HostingSystemId
    self.VMIds = obj.VMIds
    self.MeasureObject = obj.MeasureObject
    self.StandardDigest = obj.StandardDigest
end

function TSetStandardDigestReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStandardDigestReq.group)
end

TSetStandardDigestReq.from_obj = TSetStandardDigestReq_from_obj

TSetStandardDigestReq.proto_property = {'HostingSystemId', 'VMIds', 'MeasureObject', 'StandardDigest'}

TSetStandardDigestReq.default = {0, {}, '', ''}

TSetStandardDigestReq.struct = {
    {name = 'HostingSystemId', is_array = false, struct = nil}, {name = 'VMIds', is_array = true, struct = nil},
    {name = 'MeasureObject', is_array = false, struct = nil}, {name = 'StandardDigest', is_array = false, struct = nil}
}

function TSetStandardDigestReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HostingSystemId', self.HostingSystemId, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'VMIds', self.VMIds, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'MeasureObject', self.MeasureObject, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'StandardDigest', self.StandardDigest, 'string', false, errs, need_convert)

    if self.MeasureObject ~= nil then
        validate.Enum(prefix .. 'MeasureObject', self.MeasureObject, '',
            {'Bios', 'Shim', 'Grub', 'Grub.Cfg', 'Kernel', 'Initrd'}, errs, need_convert)
    end
    if self.StandardDigest ~= nil then
        validate.lens(prefix .. 'StandardDigest', self.StandardDigest, 64, 64, errs, need_convert)
    end

    TSetStandardDigestReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStandardDigestReq.proto_property, errs, need_convert)
    return self
end

function TSetStandardDigestReq:unpack(_)
    return self.HostingSystemId, self.VMIds, self.MeasureObject, self.StandardDigest
end

Config.SetStandardDigestReq = TSetStandardDigestReq

---@class Config.RefreshComponentStandardDigestRsp
local TRefreshComponentStandardDigestRsp = {}
TRefreshComponentStandardDigestRsp.__index = TRefreshComponentStandardDigestRsp
TRefreshComponentStandardDigestRsp.group = {}

local function TRefreshComponentStandardDigestRsp_from_obj(obj)
    return setmetatable(obj, TRefreshComponentStandardDigestRsp)
end

function TRefreshComponentStandardDigestRsp.new()
    return TRefreshComponentStandardDigestRsp_from_obj({})
end
---@param obj Config.RefreshComponentStandardDigestRsp
function TRefreshComponentStandardDigestRsp:init_from_obj(obj)

end

function TRefreshComponentStandardDigestRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefreshComponentStandardDigestRsp.group)
end

TRefreshComponentStandardDigestRsp.from_obj = TRefreshComponentStandardDigestRsp_from_obj

TRefreshComponentStandardDigestRsp.proto_property = {}

TRefreshComponentStandardDigestRsp.default = {}

TRefreshComponentStandardDigestRsp.struct = {}

function TRefreshComponentStandardDigestRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TRefreshComponentStandardDigestRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefreshComponentStandardDigestRsp.proto_property, errs, need_convert)
    return self
end

function TRefreshComponentStandardDigestRsp:unpack(_)
end

Config.RefreshComponentStandardDigestRsp = TRefreshComponentStandardDigestRsp

---@class Config.RefreshComponentStandardDigestReq
---@field SystemId integer
local TRefreshComponentStandardDigestReq = {}
TRefreshComponentStandardDigestReq.__index = TRefreshComponentStandardDigestReq
TRefreshComponentStandardDigestReq.group = {}

local function TRefreshComponentStandardDigestReq_from_obj(obj)
    return setmetatable(obj, TRefreshComponentStandardDigestReq)
end

function TRefreshComponentStandardDigestReq.new(SystemId)
    return TRefreshComponentStandardDigestReq_from_obj({SystemId = SystemId})
end
---@param obj Config.RefreshComponentStandardDigestReq
function TRefreshComponentStandardDigestReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TRefreshComponentStandardDigestReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefreshComponentStandardDigestReq.group)
end

TRefreshComponentStandardDigestReq.from_obj = TRefreshComponentStandardDigestReq_from_obj

TRefreshComponentStandardDigestReq.proto_property = {'SystemId'}

TRefreshComponentStandardDigestReq.default = {0}

TRefreshComponentStandardDigestReq.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TRefreshComponentStandardDigestReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)

    TRefreshComponentStandardDigestReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefreshComponentStandardDigestReq.proto_property, errs, need_convert)
    return self
end

function TRefreshComponentStandardDigestReq:unpack(_)
    return self.SystemId
end

Config.RefreshComponentStandardDigestReq = TRefreshComponentStandardDigestReq

---@class Config.GetTsbLicenseRsp
---@field LicenseType integer
---@field ExpiredTime string
local TGetTsbLicenseRsp = {}
TGetTsbLicenseRsp.__index = TGetTsbLicenseRsp
TGetTsbLicenseRsp.group = {}

local function TGetTsbLicenseRsp_from_obj(obj)
    return setmetatable(obj, TGetTsbLicenseRsp)
end

function TGetTsbLicenseRsp.new(LicenseType, ExpiredTime)
    return TGetTsbLicenseRsp_from_obj({LicenseType = LicenseType, ExpiredTime = ExpiredTime})
end
---@param obj Config.GetTsbLicenseRsp
function TGetTsbLicenseRsp:init_from_obj(obj)
    self.LicenseType = obj.LicenseType
    self.ExpiredTime = obj.ExpiredTime
end

function TGetTsbLicenseRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTsbLicenseRsp.group)
end

TGetTsbLicenseRsp.from_obj = TGetTsbLicenseRsp_from_obj

TGetTsbLicenseRsp.proto_property = {'LicenseType', 'ExpiredTime'}

TGetTsbLicenseRsp.default = {0, ''}

TGetTsbLicenseRsp.struct = {
    {name = 'LicenseType', is_array = false, struct = nil}, {name = 'ExpiredTime', is_array = false, struct = nil}
}

function TGetTsbLicenseRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LicenseType', self.LicenseType, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ExpiredTime', self.ExpiredTime, 'string', false, errs, need_convert)

    TGetTsbLicenseRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTsbLicenseRsp.proto_property, errs, need_convert)
    return self
end

function TGetTsbLicenseRsp:unpack(_)
    return self.LicenseType, self.ExpiredTime
end

Config.GetTsbLicenseRsp = TGetTsbLicenseRsp

---@class Config.GetTsbLicenseReq
local TGetTsbLicenseReq = {}
TGetTsbLicenseReq.__index = TGetTsbLicenseReq
TGetTsbLicenseReq.group = {}

local function TGetTsbLicenseReq_from_obj(obj)
    return setmetatable(obj, TGetTsbLicenseReq)
end

function TGetTsbLicenseReq.new()
    return TGetTsbLicenseReq_from_obj({})
end
---@param obj Config.GetTsbLicenseReq
function TGetTsbLicenseReq:init_from_obj(obj)

end

function TGetTsbLicenseReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTsbLicenseReq.group)
end

TGetTsbLicenseReq.from_obj = TGetTsbLicenseReq_from_obj

TGetTsbLicenseReq.proto_property = {}

TGetTsbLicenseReq.default = {}

TGetTsbLicenseReq.struct = {}

function TGetTsbLicenseReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetTsbLicenseReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTsbLicenseReq.proto_property, errs, need_convert)
    return self
end

function TGetTsbLicenseReq:unpack(_)
end

Config.GetTsbLicenseReq = TGetTsbLicenseReq

---@class Config.RefreshBIOSDigestRsp
---@field TaskId integer
local TRefreshBIOSDigestRsp = {}
TRefreshBIOSDigestRsp.__index = TRefreshBIOSDigestRsp
TRefreshBIOSDigestRsp.group = {}

local function TRefreshBIOSDigestRsp_from_obj(obj)
    return setmetatable(obj, TRefreshBIOSDigestRsp)
end

function TRefreshBIOSDigestRsp.new(TaskId)
    return TRefreshBIOSDigestRsp_from_obj({TaskId = TaskId})
end
---@param obj Config.RefreshBIOSDigestRsp
function TRefreshBIOSDigestRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TRefreshBIOSDigestRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefreshBIOSDigestRsp.group)
end

TRefreshBIOSDigestRsp.from_obj = TRefreshBIOSDigestRsp_from_obj

TRefreshBIOSDigestRsp.proto_property = {'TaskId'}

TRefreshBIOSDigestRsp.default = {0}

TRefreshBIOSDigestRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TRefreshBIOSDigestRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint8', false, errs, need_convert)

    TRefreshBIOSDigestRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefreshBIOSDigestRsp.proto_property, errs, need_convert)
    return self
end

function TRefreshBIOSDigestRsp:unpack(_)
    return self.TaskId
end

Config.RefreshBIOSDigestRsp = TRefreshBIOSDigestRsp

---@class Config.RefreshBIOSDigestReq
local TRefreshBIOSDigestReq = {}
TRefreshBIOSDigestReq.__index = TRefreshBIOSDigestReq
TRefreshBIOSDigestReq.group = {}

local function TRefreshBIOSDigestReq_from_obj(obj)
    return setmetatable(obj, TRefreshBIOSDigestReq)
end

function TRefreshBIOSDigestReq.new()
    return TRefreshBIOSDigestReq_from_obj({})
end
---@param obj Config.RefreshBIOSDigestReq
function TRefreshBIOSDigestReq:init_from_obj(obj)

end

function TRefreshBIOSDigestReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefreshBIOSDigestReq.group)
end

TRefreshBIOSDigestReq.from_obj = TRefreshBIOSDigestReq_from_obj

TRefreshBIOSDigestReq.proto_property = {}

TRefreshBIOSDigestReq.default = {}

TRefreshBIOSDigestReq.struct = {}

function TRefreshBIOSDigestReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TRefreshBIOSDigestReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefreshBIOSDigestReq.proto_property, errs, need_convert)
    return self
end

function TRefreshBIOSDigestReq:unpack(_)
end

Config.RefreshBIOSDigestReq = TRefreshBIOSDigestReq

Config.interface = mdb.register_interface('bmc.kepler.Managers.TPCM.Config', {
    TrustedCenterServerAddr = {'s', {['emitsChangedSignal'] = 'true'}, false, nil},
    MeasureEnable = {'b', {['emitsChangedSignal'] = 'true'}, false, nil},
    MeasureControlPolicy = {'b', {['emitsChangedSignal'] = 'true'}, false, nil},
    vTPCMSupported = {'b', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {
    RefreshBIOSDigest = {'a{ss}', 'y', TRefreshBIOSDigestReq, TRefreshBIOSDigestRsp},
    GetTsbLicense = {'a{ss}', 'us', TGetTsbLicenseReq, TGetTsbLicenseRsp},
    RefreshComponentStandardDigest = {
        'a{ss}y', '', TRefreshComponentStandardDigestReq, TRefreshComponentStandardDigestRsp
    },
    SetStandardDigest = {'a{ss}yasss', '', TSetStandardDigestReq, TSetStandardDigestRsp}
}, {})

return Config
