-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Component = {}

---@class Component.UpdateHealthRsp
local TUpdateHealthRsp = {}
TUpdateHealthRsp.__index = TUpdateHealthRsp
TUpdateHealthRsp.group = {}

local function TUpdateHealthRsp_from_obj(obj)
    return setmetatable(obj, TUpdateHealthRsp)
end

function TUpdateHealthRsp.new()
    return TUpdateHealthRsp_from_obj({})
end
---@param obj Component.UpdateHealthRsp
function TUpdateHealthRsp:init_from_obj(obj)

end

function TUpdateHealthRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateHealthRsp.group)
end

TUpdateHealthRsp.from_obj = TUpdateHealthRsp_from_obj

TUpdateHealthRsp.proto_property = {}

TUpdateHealthRsp.default = {}

TUpdateHealthRsp.struct = {}

function TUpdateHealthRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TUpdateHealthRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateHealthRsp.proto_property, errs, need_convert)
    return self
end

function TUpdateHealthRsp:unpack(_)
end

Component.UpdateHealthRsp = TUpdateHealthRsp

---@class Component.UpdateHealthReq
---@field Health integer
local TUpdateHealthReq = {}
TUpdateHealthReq.__index = TUpdateHealthReq
TUpdateHealthReq.group = {}

local function TUpdateHealthReq_from_obj(obj)
    return setmetatable(obj, TUpdateHealthReq)
end

function TUpdateHealthReq.new(Health)
    return TUpdateHealthReq_from_obj({Health = Health})
end
---@param obj Component.UpdateHealthReq
function TUpdateHealthReq:init_from_obj(obj)
    self.Health = obj.Health
end

function TUpdateHealthReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateHealthReq.group)
end

TUpdateHealthReq.from_obj = TUpdateHealthReq_from_obj

TUpdateHealthReq.proto_property = {'Health'}

TUpdateHealthReq.default = {0}

TUpdateHealthReq.struct = {{name = 'Health', is_array = false, struct = nil}}

function TUpdateHealthReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', false, errs, need_convert)

    TUpdateHealthReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateHealthReq.proto_property, errs, need_convert)
    return self
end

function TUpdateHealthReq:unpack(_)
    return self.Health
end

Component.UpdateHealthReq = TUpdateHealthReq

Component.interface = mdb.register_interface('bmc.kepler.Systems.Component', {
    FruId = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    Instance = {'y', nil, true, nil},
    Type = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    Name = {'s', nil, false, nil},
    Presence = {'y', nil, true, nil},
    Health = {'y', nil, false, nil},
    PowerState = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    BoardId = {'q', {['emitsChangedSignal'] = 'false'}, true, nil},
    UniqueId = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    Manufacturer = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    GroupId = {'y', {['emitsChangedSignal'] = 'false'}, true, 1},
    Location = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    SerialNumber = {'s', nil, true, nil},
    PartNumber = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    SegmentId = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    Function = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    PreviousSN = {'s', nil, true, nil},
    ReplaceFlag = {'y', nil, true, nil},
    NodeId = {'s', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {UpdateHealth = {'a{ss}y', '', TUpdateHealthReq, TUpdateHealthRsp}}, {})

return Component
