-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local BiosUpgradeService = {}

---@class BiosUpgradeService.FirmwareEffectiveStatus
---@field FirmwareEffectiveStatus integer
local TFirmwareEffectiveStatus = {}
TFirmwareEffectiveStatus.__index = TFirmwareEffectiveStatus
TFirmwareEffectiveStatus.group = {}

local function TFirmwareEffectiveStatus_from_obj(obj)
    return setmetatable(obj, TFirmwareEffectiveStatus)
end

function TFirmwareEffectiveStatus.new(FirmwareEffectiveStatus)
    return TFirmwareEffectiveStatus_from_obj({FirmwareEffectiveStatus = FirmwareEffectiveStatus or 3})
end
---@param obj BiosUpgradeService.FirmwareEffectiveStatus
function TFirmwareEffectiveStatus:init_from_obj(obj)
    self.FirmwareEffectiveStatus = obj.FirmwareEffectiveStatus or 3
end

function TFirmwareEffectiveStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareEffectiveStatus.group)
end

TFirmwareEffectiveStatus.from_obj = TFirmwareEffectiveStatus_from_obj

TFirmwareEffectiveStatus.proto_property = {'FirmwareEffectiveStatus'}

TFirmwareEffectiveStatus.default = {0}

TFirmwareEffectiveStatus.struct = {{name = 'FirmwareEffectiveStatus', is_array = false, struct = nil}}

function TFirmwareEffectiveStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareEffectiveStatus', self.FirmwareEffectiveStatus, 'uint8', true, errs,
        need_convert)

    if self.FirmwareEffectiveStatus ~= nil then
        validate.Enum(prefix .. 'FirmwareEffectiveStatus', self.FirmwareEffectiveStatus, '', {1, 2, 3}, errs,
            need_convert)
    end

    TFirmwareEffectiveStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareEffectiveStatus.proto_property, errs, need_convert)
    return self
end

function TFirmwareEffectiveStatus:unpack(_)
    return self.FirmwareEffectiveStatus
end

BiosUpgradeService.FirmwareEffectiveStatus = TFirmwareEffectiveStatus

---@class BiosUpgradeService.ActivatedStatus
---@field ActivatedStatus integer
local TActivatedStatus = {}
TActivatedStatus.__index = TActivatedStatus
TActivatedStatus.group = {}

local function TActivatedStatus_from_obj(obj)
    return setmetatable(obj, TActivatedStatus)
end

function TActivatedStatus.new(ActivatedStatus)
    return TActivatedStatus_from_obj({ActivatedStatus = ActivatedStatus or 0})
end
---@param obj BiosUpgradeService.ActivatedStatus
function TActivatedStatus:init_from_obj(obj)
    self.ActivatedStatus = obj.ActivatedStatus or 0
end

function TActivatedStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActivatedStatus.group)
end

TActivatedStatus.from_obj = TActivatedStatus_from_obj

TActivatedStatus.proto_property = {'ActivatedStatus'}

TActivatedStatus.default = {0}

TActivatedStatus.struct = {{name = 'ActivatedStatus', is_array = false, struct = nil}}

function TActivatedStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActivatedStatus', self.ActivatedStatus, 'uint8', true, errs, need_convert)

    if self.ActivatedStatus ~= nil then
        validate.Enum(prefix .. 'ActivatedStatus', self.ActivatedStatus, '', {0, 1, 2}, errs, need_convert)
    end

    TActivatedStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActivatedStatus.proto_property, errs, need_convert)
    return self
end

function TActivatedStatus:unpack(_)
    return self.ActivatedStatus
end

BiosUpgradeService.ActivatedStatus = TActivatedStatus

---@class BiosUpgradeService.PreserveConfigEnabled
---@field PreserveConfigEnabled boolean
local TPreserveConfigEnabled = {}
TPreserveConfigEnabled.__index = TPreserveConfigEnabled
TPreserveConfigEnabled.group = {}

local function TPreserveConfigEnabled_from_obj(obj)
    return setmetatable(obj, TPreserveConfigEnabled)
end

function TPreserveConfigEnabled.new(PreserveConfigEnabled)
    return TPreserveConfigEnabled_from_obj({
        PreserveConfigEnabled = PreserveConfigEnabled == nil and true or PreserveConfigEnabled
    })
end
---@param obj BiosUpgradeService.PreserveConfigEnabled
function TPreserveConfigEnabled:init_from_obj(obj)
    self.PreserveConfigEnabled = obj.PreserveConfigEnabled == nil and true or obj.PreserveConfigEnabled
end

function TPreserveConfigEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPreserveConfigEnabled.group)
end

TPreserveConfigEnabled.from_obj = TPreserveConfigEnabled_from_obj

TPreserveConfigEnabled.proto_property = {'PreserveConfigEnabled'}

TPreserveConfigEnabled.default = {false}

TPreserveConfigEnabled.struct = {{name = 'PreserveConfigEnabled', is_array = false, struct = nil}}

function TPreserveConfigEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreserveConfigEnabled', self.PreserveConfigEnabled, 'bool', false, errs, need_convert)

    TPreserveConfigEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPreserveConfigEnabled.proto_property, errs, need_convert)
    return self
end

function TPreserveConfigEnabled:unpack(_)
    return self.PreserveConfigEnabled
end

BiosUpgradeService.PreserveConfigEnabled = TPreserveConfigEnabled

---@class BiosUpgradeService.GetFirmwareInfoRsp
---@field FirmwareInfo string
local TGetFirmwareInfoRsp = {}
TGetFirmwareInfoRsp.__index = TGetFirmwareInfoRsp
TGetFirmwareInfoRsp.group = {}

local function TGetFirmwareInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetFirmwareInfoRsp)
end

function TGetFirmwareInfoRsp.new(FirmwareInfo)
    return TGetFirmwareInfoRsp_from_obj({FirmwareInfo = FirmwareInfo})
end
---@param obj BiosUpgradeService.GetFirmwareInfoRsp
function TGetFirmwareInfoRsp:init_from_obj(obj)
    self.FirmwareInfo = obj.FirmwareInfo
end

function TGetFirmwareInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFirmwareInfoRsp.group)
end

TGetFirmwareInfoRsp.from_obj = TGetFirmwareInfoRsp_from_obj

TGetFirmwareInfoRsp.proto_property = {'FirmwareInfo'}

TGetFirmwareInfoRsp.default = {''}

TGetFirmwareInfoRsp.struct = {{name = 'FirmwareInfo', is_array = false, struct = nil}}

function TGetFirmwareInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareInfo', self.FirmwareInfo, 'string', false, errs, need_convert)

    TGetFirmwareInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFirmwareInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetFirmwareInfoRsp:unpack(_)
    return self.FirmwareInfo
end

BiosUpgradeService.GetFirmwareInfoRsp = TGetFirmwareInfoRsp

---@class BiosUpgradeService.GetFirmwareInfoReq
local TGetFirmwareInfoReq = {}
TGetFirmwareInfoReq.__index = TGetFirmwareInfoReq
TGetFirmwareInfoReq.group = {}

local function TGetFirmwareInfoReq_from_obj(obj)
    return setmetatable(obj, TGetFirmwareInfoReq)
end

function TGetFirmwareInfoReq.new()
    return TGetFirmwareInfoReq_from_obj({})
end
---@param obj BiosUpgradeService.GetFirmwareInfoReq
function TGetFirmwareInfoReq:init_from_obj(obj)

end

function TGetFirmwareInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFirmwareInfoReq.group)
end

TGetFirmwareInfoReq.from_obj = TGetFirmwareInfoReq_from_obj

TGetFirmwareInfoReq.proto_property = {}

TGetFirmwareInfoReq.default = {}

TGetFirmwareInfoReq.struct = {}

function TGetFirmwareInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetFirmwareInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFirmwareInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetFirmwareInfoReq:unpack(_)
end

BiosUpgradeService.GetFirmwareInfoReq = TGetFirmwareInfoReq

---@class BiosUpgradeService.ExportBiosFirmwareRsp
---@field TaskId integer
local TExportBiosFirmwareRsp = {}
TExportBiosFirmwareRsp.__index = TExportBiosFirmwareRsp
TExportBiosFirmwareRsp.group = {}

local function TExportBiosFirmwareRsp_from_obj(obj)
    return setmetatable(obj, TExportBiosFirmwareRsp)
end

function TExportBiosFirmwareRsp.new(TaskId)
    return TExportBiosFirmwareRsp_from_obj({TaskId = TaskId})
end
---@param obj BiosUpgradeService.ExportBiosFirmwareRsp
function TExportBiosFirmwareRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TExportBiosFirmwareRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosFirmwareRsp.group)
end

TExportBiosFirmwareRsp.from_obj = TExportBiosFirmwareRsp_from_obj

TExportBiosFirmwareRsp.proto_property = {'TaskId'}

TExportBiosFirmwareRsp.default = {0}

TExportBiosFirmwareRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TExportBiosFirmwareRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TExportBiosFirmwareRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosFirmwareRsp.proto_property, errs, need_convert)
    return self
end

function TExportBiosFirmwareRsp:unpack(_)
    return self.TaskId
end

BiosUpgradeService.ExportBiosFirmwareRsp = TExportBiosFirmwareRsp

---@class BiosUpgradeService.ExportBiosFirmwareReq
local TExportBiosFirmwareReq = {}
TExportBiosFirmwareReq.__index = TExportBiosFirmwareReq
TExportBiosFirmwareReq.group = {}

local function TExportBiosFirmwareReq_from_obj(obj)
    return setmetatable(obj, TExportBiosFirmwareReq)
end

function TExportBiosFirmwareReq.new()
    return TExportBiosFirmwareReq_from_obj({})
end
---@param obj BiosUpgradeService.ExportBiosFirmwareReq
function TExportBiosFirmwareReq:init_from_obj(obj)

end

function TExportBiosFirmwareReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosFirmwareReq.group)
end

TExportBiosFirmwareReq.from_obj = TExportBiosFirmwareReq_from_obj

TExportBiosFirmwareReq.proto_property = {}

TExportBiosFirmwareReq.default = {}

TExportBiosFirmwareReq.struct = {}

function TExportBiosFirmwareReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TExportBiosFirmwareReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosFirmwareReq.proto_property, errs, need_convert)
    return self
end

function TExportBiosFirmwareReq:unpack(_)
end

BiosUpgradeService.ExportBiosFirmwareReq = TExportBiosFirmwareReq

---@class BiosUpgradeService.ActivateFirmwareRsp
local TActivateFirmwareRsp = {}
TActivateFirmwareRsp.__index = TActivateFirmwareRsp
TActivateFirmwareRsp.group = {}

local function TActivateFirmwareRsp_from_obj(obj)
    return setmetatable(obj, TActivateFirmwareRsp)
end

function TActivateFirmwareRsp.new()
    return TActivateFirmwareRsp_from_obj({})
end
---@param obj BiosUpgradeService.ActivateFirmwareRsp
function TActivateFirmwareRsp:init_from_obj(obj)

end

function TActivateFirmwareRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActivateFirmwareRsp.group)
end

TActivateFirmwareRsp.from_obj = TActivateFirmwareRsp_from_obj

TActivateFirmwareRsp.proto_property = {}

TActivateFirmwareRsp.default = {}

TActivateFirmwareRsp.struct = {}

function TActivateFirmwareRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TActivateFirmwareRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActivateFirmwareRsp.proto_property, errs, need_convert)
    return self
end

function TActivateFirmwareRsp:unpack(_)
end

BiosUpgradeService.ActivateFirmwareRsp = TActivateFirmwareRsp

---@class BiosUpgradeService.ActivateFirmwareReq
---@field DatabseType string[]
local TActivateFirmwareReq = {}
TActivateFirmwareReq.__index = TActivateFirmwareReq
TActivateFirmwareReq.group = {}

local function TActivateFirmwareReq_from_obj(obj)
    return setmetatable(obj, TActivateFirmwareReq)
end

function TActivateFirmwareReq.new(DatabseType)
    return TActivateFirmwareReq_from_obj({DatabseType = DatabseType})
end
---@param obj BiosUpgradeService.ActivateFirmwareReq
function TActivateFirmwareReq:init_from_obj(obj)
    self.DatabseType = obj.DatabseType
end

function TActivateFirmwareReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActivateFirmwareReq.group)
end

TActivateFirmwareReq.from_obj = TActivateFirmwareReq_from_obj

TActivateFirmwareReq.proto_property = {'DatabseType'}

TActivateFirmwareReq.default = {{}}

TActivateFirmwareReq.struct = {{name = 'DatabseType', is_array = true, struct = nil}}

function TActivateFirmwareReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'DatabseType', self.DatabseType, 'string', false, errs, need_convert)

    TActivateFirmwareReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActivateFirmwareReq.proto_property, errs, need_convert)
    return self
end

function TActivateFirmwareReq:unpack(_)
    return self.DatabseType
end

BiosUpgradeService.ActivateFirmwareReq = TActivateFirmwareReq

BiosUpgradeService.interface = mdb.register_interface('bmc.kepler.Systems.BiosUpgradeService', {
    PreserveConfigEnabled = {'b', {}, false, true},
    ActivatedStatus = {'y', {}, true, 0},
    FirmwareEffectiveStatus = {'y', {}, true, 3}
}, {
    ActivateFirmware = {'a{ss}as', '', TActivateFirmwareReq, TActivateFirmwareRsp},
    ExportBiosFirmware = {'a{ss}', 'u', TExportBiosFirmwareReq, TExportBiosFirmwareRsp},
    GetFirmwareInfo = {'a{ss}', 's', TGetFirmwareInfoReq, TGetFirmwareInfoRsp}
}, {})

return BiosUpgradeService
