--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetVedioStatus = {}

---@class BiosIpmiCmds.SetVedioStatusReq
---@field ManufactureId integer
---@field EventDir integer
---@field DeviceStatus string
local TSetVedioStatusReq = {}
TSetVedioStatusReq.__index = TSetVedioStatusReq
TSetVedioStatusReq.group = {}

local function TSetVedioStatusReq_from_obj(obj)
    return setmetatable(obj, TSetVedioStatusReq)
end

function TSetVedioStatusReq.new(ManufactureId, EventDir, DeviceStatus)
    return
        TSetVedioStatusReq_from_obj({ManufactureId = ManufactureId, EventDir = EventDir, DeviceStatus = DeviceStatus})
end
---@param obj BiosIpmiCmds.SetVedioStatusReq
function TSetVedioStatusReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.EventDir = obj.EventDir
    self.DeviceStatus = obj.DeviceStatus
end

function TSetVedioStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetVedioStatusReq.group)
end

TSetVedioStatusReq.from_obj = TSetVedioStatusReq_from_obj

TSetVedioStatusReq.proto_property = {'ManufactureId', 'EventDir', 'DeviceStatus'}

TSetVedioStatusReq.default = {0, 0, ''}

TSetVedioStatusReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'EventDir', is_array = false, struct = nil},
    {name = 'DeviceStatus', is_array = false, struct = nil}
}

function TSetVedioStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EventDir', self.EventDir, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceStatus', self.DeviceStatus, 'string', false, errs, need_convert)

    TSetVedioStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetVedioStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetVedioStatusReq:unpack(_)
    return self.ManufactureId, self.EventDir, self.DeviceStatus
end

SetVedioStatus.SetVedioStatusReq = TSetVedioStatusReq

---@class BiosIpmiCmds.SetVedioStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetVedioStatusRsp = {}
TSetVedioStatusRsp.__index = TSetVedioStatusRsp
TSetVedioStatusRsp.group = {}

local function TSetVedioStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetVedioStatusRsp)
end

function TSetVedioStatusRsp.new(CompletionCode, ManufactureId)
    return TSetVedioStatusRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.SetVedioStatusRsp
function TSetVedioStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetVedioStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetVedioStatusRsp.group)
end

TSetVedioStatusRsp.from_obj = TSetVedioStatusRsp_from_obj

TSetVedioStatusRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetVedioStatusRsp.default = {0, 0}

TSetVedioStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetVedioStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetVedioStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetVedioStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetVedioStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetVedioStatus.SetVedioStatusRsp = TSetVedioStatusRsp

return SetVedioStatus
