--[[-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetKrunVersion = {}

---@class BiosIpmiCmds.SetKrunVersionReq
---@field ManufactureId integer
---@field Length integer
---@field Version string
local TSetKrunVersionReq = {}
TSetKrunVersionReq.__index = TSetKrunVersionReq
TSetKrunVersionReq.group = {}

local function TSetKrunVersionReq_from_obj(obj)
    return setmetatable(obj, TSetKrunVersionReq)
end

function TSetKrunVersionReq.new(ManufactureId, Length, Version)
    return TSetKrunVersionReq_from_obj({ManufactureId = ManufactureId, Length = Length, Version = Version})
end
---@param obj BiosIpmiCmds.SetKrunVersionReq
function TSetKrunVersionReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Length = obj.Length
    self.Version = obj.Version
end

function TSetKrunVersionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetKrunVersionReq.group)
end

TSetKrunVersionReq.from_obj = TSetKrunVersionReq_from_obj

TSetKrunVersionReq.proto_property = {'ManufactureId', 'Length', 'Version'}

TSetKrunVersionReq.default = {0, 0, ''}

TSetKrunVersionReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Version', is_array = false, struct = nil}
}

function TSetKrunVersionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Version', self.Version, 'string', false, errs, need_convert)

    TSetKrunVersionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetKrunVersionReq.proto_property, errs, need_convert)
    return self
end

function TSetKrunVersionReq:unpack(_)
    return self.ManufactureId, self.Length, self.Version
end

SetKrunVersion.SetKrunVersionReq = TSetKrunVersionReq

---@class BiosIpmiCmds.SetKrunVersionRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetKrunVersionRsp = {}
TSetKrunVersionRsp.__index = TSetKrunVersionRsp
TSetKrunVersionRsp.group = {}

local function TSetKrunVersionRsp_from_obj(obj)
    return setmetatable(obj, TSetKrunVersionRsp)
end

function TSetKrunVersionRsp.new(CompletionCode, ManufactureId)
    return TSetKrunVersionRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.SetKrunVersionRsp
function TSetKrunVersionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetKrunVersionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetKrunVersionRsp.group)
end

TSetKrunVersionRsp.from_obj = TSetKrunVersionRsp_from_obj

TSetKrunVersionRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetKrunVersionRsp.default = {0, 0}

TSetKrunVersionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetKrunVersionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetKrunVersionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetKrunVersionRsp.proto_property, errs, need_convert)
    return self
end

function TSetKrunVersionRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetKrunVersion.SetKrunVersionRsp = TSetKrunVersionRsp

return SetKrunVersion
