--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDeviceSystemInfo = {}

---@class BiosIpmiCmds.SetDeviceSystemInfoReq
---@field Info string
local TSetDeviceSystemInfoReq = {}
TSetDeviceSystemInfoReq.__index = TSetDeviceSystemInfoReq
TSetDeviceSystemInfoReq.group = {}

local function TSetDeviceSystemInfoReq_from_obj(obj)
    return setmetatable(obj, TSetDeviceSystemInfoReq)
end

function TSetDeviceSystemInfoReq.new(Info)
    return TSetDeviceSystemInfoReq_from_obj({Info = Info})
end
---@param obj BiosIpmiCmds.SetDeviceSystemInfoReq
function TSetDeviceSystemInfoReq:init_from_obj(obj)
    self.Info = obj.Info
end

function TSetDeviceSystemInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDeviceSystemInfoReq.group)
end

TSetDeviceSystemInfoReq.from_obj = TSetDeviceSystemInfoReq_from_obj

TSetDeviceSystemInfoReq.proto_property = {'Info'}

TSetDeviceSystemInfoReq.default = {''}

TSetDeviceSystemInfoReq.struct = {{name = 'Info', is_array = false, struct = nil}}

function TSetDeviceSystemInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TSetDeviceSystemInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDeviceSystemInfoReq.proto_property, errs, need_convert)
    return self
end

function TSetDeviceSystemInfoReq:unpack(_)
    return self.Info
end

SetDeviceSystemInfo.SetDeviceSystemInfoReq = TSetDeviceSystemInfoReq

---@class BiosIpmiCmds.SetDeviceSystemInfoRsp
---@field CompletionCode integer
local TSetDeviceSystemInfoRsp = {}
TSetDeviceSystemInfoRsp.__index = TSetDeviceSystemInfoRsp
TSetDeviceSystemInfoRsp.group = {}

local function TSetDeviceSystemInfoRsp_from_obj(obj)
    return setmetatable(obj, TSetDeviceSystemInfoRsp)
end

function TSetDeviceSystemInfoRsp.new(CompletionCode)
    return TSetDeviceSystemInfoRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj BiosIpmiCmds.SetDeviceSystemInfoRsp
function TSetDeviceSystemInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetDeviceSystemInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDeviceSystemInfoRsp.group)
end

TSetDeviceSystemInfoRsp.from_obj = TSetDeviceSystemInfoRsp_from_obj

TSetDeviceSystemInfoRsp.proto_property = {'CompletionCode'}

TSetDeviceSystemInfoRsp.default = {0}

TSetDeviceSystemInfoRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetDeviceSystemInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetDeviceSystemInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDeviceSystemInfoRsp.proto_property, errs, need_convert)
    return self
end

function TSetDeviceSystemInfoRsp:unpack(_)
    return self.CompletionCode
end

SetDeviceSystemInfo.SetDeviceSystemInfoRsp = TSetDeviceSystemInfoRsp

return SetDeviceSystemInfo
