--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetCertificateDeassertion = {}

---@class BiosIpmiCmds.SetCertificateDeassertionReq
---@field ManufactureId integer
---@field EventType integer
---@field Info string
local TSetCertificateDeassertionReq = {}
TSetCertificateDeassertionReq.__index = TSetCertificateDeassertionReq
TSetCertificateDeassertionReq.group = {}

local function TSetCertificateDeassertionReq_from_obj(obj)
    return setmetatable(obj, TSetCertificateDeassertionReq)
end

function TSetCertificateDeassertionReq.new(ManufactureId, EventType, Info)
    return TSetCertificateDeassertionReq_from_obj({ManufactureId = ManufactureId, EventType = EventType, Info = Info})
end
---@param obj BiosIpmiCmds.SetCertificateDeassertionReq
function TSetCertificateDeassertionReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.EventType = obj.EventType
    self.Info = obj.Info
end

function TSetCertificateDeassertionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCertificateDeassertionReq.group)
end

TSetCertificateDeassertionReq.from_obj = TSetCertificateDeassertionReq_from_obj

TSetCertificateDeassertionReq.proto_property = {'ManufactureId', 'EventType', 'Info'}

TSetCertificateDeassertionReq.default = {0, 0, ''}

TSetCertificateDeassertionReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'EventType', is_array = false, struct = nil},
    {name = 'Info', is_array = false, struct = nil}
}

function TSetCertificateDeassertionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EventType', self.EventType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TSetCertificateDeassertionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCertificateDeassertionReq.proto_property, errs, need_convert)
    return self
end

function TSetCertificateDeassertionReq:unpack(_)
    return self.ManufactureId, self.EventType, self.Info
end

SetCertificateDeassertion.SetCertificateDeassertionReq = TSetCertificateDeassertionReq

---@class BiosIpmiCmds.SetCertificateDeassertionRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetCertificateDeassertionRsp = {}
TSetCertificateDeassertionRsp.__index = TSetCertificateDeassertionRsp
TSetCertificateDeassertionRsp.group = {}

local function TSetCertificateDeassertionRsp_from_obj(obj)
    return setmetatable(obj, TSetCertificateDeassertionRsp)
end

function TSetCertificateDeassertionRsp.new(CompletionCode, ManufactureId)
    return TSetCertificateDeassertionRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.SetCertificateDeassertionRsp
function TSetCertificateDeassertionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetCertificateDeassertionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCertificateDeassertionRsp.group)
end

TSetCertificateDeassertionRsp.from_obj = TSetCertificateDeassertionRsp_from_obj

TSetCertificateDeassertionRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetCertificateDeassertionRsp.default = {0, 0}

TSetCertificateDeassertionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetCertificateDeassertionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetCertificateDeassertionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCertificateDeassertionRsp.proto_property, errs, need_convert)
    return self
end

function TSetCertificateDeassertionRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetCertificateDeassertion.SetCertificateDeassertionRsp = TSetCertificateDeassertionRsp

return SetCertificateDeassertion
