--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetBiosConfigItem = {}

---@class BiosIpmiCmds.SetBiosConfigItemReq
---@field ManufactureId integer
---@field Length integer
---@field Item integer
---@field Option integer
local TSetBiosConfigItemReq = {}
TSetBiosConfigItemReq.__index = TSetBiosConfigItemReq
TSetBiosConfigItemReq.group = {}

local function TSetBiosConfigItemReq_from_obj(obj)
    return setmetatable(obj, TSetBiosConfigItemReq)
end

function TSetBiosConfigItemReq.new(ManufactureId, Length, Item, Option)
    return
        TSetBiosConfigItemReq_from_obj({ManufactureId = ManufactureId, Length = Length, Item = Item, Option = Option})
end
---@param obj BiosIpmiCmds.SetBiosConfigItemReq
function TSetBiosConfigItemReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Length = obj.Length
    self.Item = obj.Item
    self.Option = obj.Option
end

function TSetBiosConfigItemReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosConfigItemReq.group)
end

TSetBiosConfigItemReq.from_obj = TSetBiosConfigItemReq_from_obj

TSetBiosConfigItemReq.proto_property = {'ManufactureId', 'Length', 'Item', 'Option'}

TSetBiosConfigItemReq.default = {0, 0, 0, 0}

TSetBiosConfigItemReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Item', is_array = false, struct = nil}, {name = 'Option', is_array = false, struct = nil}
}

function TSetBiosConfigItemReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Item', self.Item, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Option', self.Option, 'uint16', false, errs, need_convert)

    TSetBiosConfigItemReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosConfigItemReq.proto_property, errs, need_convert)
    return self
end

function TSetBiosConfigItemReq:unpack(_)
    return self.ManufactureId, self.Length, self.Item, self.Option
end

SetBiosConfigItem.SetBiosConfigItemReq = TSetBiosConfigItemReq

---@class BiosIpmiCmds.SetBiosConfigItemRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetBiosConfigItemRsp = {}
TSetBiosConfigItemRsp.__index = TSetBiosConfigItemRsp
TSetBiosConfigItemRsp.group = {}

local function TSetBiosConfigItemRsp_from_obj(obj)
    return setmetatable(obj, TSetBiosConfigItemRsp)
end

function TSetBiosConfigItemRsp.new(CompletionCode, ManufactureId)
    return TSetBiosConfigItemRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.SetBiosConfigItemRsp
function TSetBiosConfigItemRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetBiosConfigItemRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosConfigItemRsp.group)
end

TSetBiosConfigItemRsp.from_obj = TSetBiosConfigItemRsp_from_obj

TSetBiosConfigItemRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetBiosConfigItemRsp.default = {0, 0}

TSetBiosConfigItemRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetBiosConfigItemRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetBiosConfigItemRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosConfigItemRsp.proto_property, errs, need_convert)
    return self
end

function TSetBiosConfigItemRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetBiosConfigItem.SetBiosConfigItemRsp = TSetBiosConfigItemRsp

return SetBiosConfigItem
