--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSmBiosInfo = {}

---@class BiosIpmiCmds.GetSmBiosInfoReq
---@field ManufactureId integer
---@field BiosId integer
---@field InformationType integer
local TGetSmBiosInfoReq = {}
TGetSmBiosInfoReq.__index = TGetSmBiosInfoReq
TGetSmBiosInfoReq.group = {}

local function TGetSmBiosInfoReq_from_obj(obj)
    return setmetatable(obj, TGetSmBiosInfoReq)
end

function TGetSmBiosInfoReq.new(ManufactureId, BiosId, InformationType)
    return TGetSmBiosInfoReq_from_obj({
        ManufactureId = ManufactureId,
        BiosId = BiosId,
        InformationType = InformationType
    })
end
---@param obj BiosIpmiCmds.GetSmBiosInfoReq
function TGetSmBiosInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.BiosId = obj.BiosId
    self.InformationType = obj.InformationType
end

function TGetSmBiosInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSmBiosInfoReq.group)
end

TGetSmBiosInfoReq.from_obj = TGetSmBiosInfoReq_from_obj

TGetSmBiosInfoReq.proto_property = {'ManufactureId', 'BiosId', 'InformationType'}

TGetSmBiosInfoReq.default = {0, 0, 0}

TGetSmBiosInfoReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'BiosId', is_array = false, struct = nil},
    {name = 'InformationType', is_array = false, struct = nil}
}

function TGetSmBiosInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'BiosId', self.BiosId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'InformationType', self.InformationType, 'uint8', false, errs, need_convert)

    TGetSmBiosInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSmBiosInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetSmBiosInfoReq:unpack(_)
    return self.ManufactureId, self.BiosId, self.InformationType
end

GetSmBiosInfo.GetSmBiosInfoReq = TGetSmBiosInfoReq

---@class BiosIpmiCmds.GetSmBiosInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field SmBiosInfo string
local TGetSmBiosInfoRsp = {}
TGetSmBiosInfoRsp.__index = TGetSmBiosInfoRsp
TGetSmBiosInfoRsp.group = {}

local function TGetSmBiosInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetSmBiosInfoRsp)
end

function TGetSmBiosInfoRsp.new(CompletionCode, ManufactureId, SmBiosInfo)
    return TGetSmBiosInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        SmBiosInfo = SmBiosInfo
    })
end
---@param obj BiosIpmiCmds.GetSmBiosInfoRsp
function TGetSmBiosInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.SmBiosInfo = obj.SmBiosInfo
end

function TGetSmBiosInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSmBiosInfoRsp.group)
end

TGetSmBiosInfoRsp.from_obj = TGetSmBiosInfoRsp_from_obj

TGetSmBiosInfoRsp.proto_property = {'CompletionCode', 'ManufactureId', 'SmBiosInfo'}

TGetSmBiosInfoRsp.default = {0, 0, ''}

TGetSmBiosInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'SmBiosInfo', is_array = false, struct = nil}
}

function TGetSmBiosInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'SmBiosInfo', self.SmBiosInfo, 'string', false, errs, need_convert)

    TGetSmBiosInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSmBiosInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetSmBiosInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.SmBiosInfo
end

GetSmBiosInfo.GetSmBiosInfoRsp = TGetSmBiosInfoRsp

return GetSmBiosInfo
