--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetBootOption = {}

---@class BiosIpmiCmds.GetBootOptionReq
---@field BootOptionSelector integer
---@field OtherSelector string
local TGetBootOptionReq = {}
TGetBootOptionReq.__index = TGetBootOptionReq
TGetBootOptionReq.group = {}

local function TGetBootOptionReq_from_obj(obj)
    return setmetatable(obj, TGetBootOptionReq)
end

function TGetBootOptionReq.new(BootOptionSelector, OtherSelector)
    return TGetBootOptionReq_from_obj({BootOptionSelector = BootOptionSelector, OtherSelector = OtherSelector})
end
---@param obj BiosIpmiCmds.GetBootOptionReq
function TGetBootOptionReq:init_from_obj(obj)
    self.BootOptionSelector = obj.BootOptionSelector
    self.OtherSelector = obj.OtherSelector
end

function TGetBootOptionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBootOptionReq.group)
end

TGetBootOptionReq.from_obj = TGetBootOptionReq_from_obj

TGetBootOptionReq.proto_property = {'BootOptionSelector', 'OtherSelector'}

TGetBootOptionReq.default = {0, ''}

TGetBootOptionReq.struct = {
    {name = 'BootOptionSelector', is_array = false, struct = nil},
    {name = 'OtherSelector', is_array = false, struct = nil}
}

function TGetBootOptionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootOptionSelector', self.BootOptionSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'OtherSelector', self.OtherSelector, 'string', false, errs, need_convert)

    TGetBootOptionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBootOptionReq.proto_property, errs, need_convert)
    return self
end

function TGetBootOptionReq:unpack(_)
    return self.BootOptionSelector, self.OtherSelector
end

GetBootOption.GetBootOptionReq = TGetBootOptionReq

---@class BiosIpmiCmds.GetBootOptionRsp
---@field CompletionCode integer
---@field OtherData string
local TGetBootOptionRsp = {}
TGetBootOptionRsp.__index = TGetBootOptionRsp
TGetBootOptionRsp.group = {}

local function TGetBootOptionRsp_from_obj(obj)
    return setmetatable(obj, TGetBootOptionRsp)
end

function TGetBootOptionRsp.new(CompletionCode, OtherData)
    return TGetBootOptionRsp_from_obj({CompletionCode = CompletionCode, OtherData = OtherData})
end
---@param obj BiosIpmiCmds.GetBootOptionRsp
function TGetBootOptionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.OtherData = obj.OtherData
end

function TGetBootOptionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBootOptionRsp.group)
end

TGetBootOptionRsp.from_obj = TGetBootOptionRsp_from_obj

TGetBootOptionRsp.proto_property = {'CompletionCode', 'OtherData'}

TGetBootOptionRsp.default = {0, ''}

TGetBootOptionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'OtherData', is_array = false, struct = nil}
}

function TGetBootOptionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'OtherData', self.OtherData, 'string', false, errs, need_convert)

    TGetBootOptionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBootOptionRsp.proto_property, errs, need_convert)
    return self
end

function TGetBootOptionRsp:unpack(_)
    return self.CompletionCode, self.OtherData
end

GetBootOption.GetBootOptionRsp = TGetBootOptionRsp

return GetBootOption
