*openUBMC 支持查询和配置BIOS选项的通用IPMI命令详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td></td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>openUBMC25.09</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>zengqijian</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025-8-8</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>2025-8-8</td>
        <td>1.0</td>
        <td>创建文档</td>
        <td>zengqijian</td>
        <td></td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
客户要求可以通过IPMI命令来查询和配置BIOS选项


## 1.2 功能描述
支持通过ipmi命令查询和配置BIOS选项

## 1.3 功能场景

用户通过ipmi命令下发查询/设置命令来配置单个BIOS选项
查询命令可以查询生效/待生效状态

## 1.4 功能列表
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | 支持查询和配置BIOS选项的通用IPMI命令 | 支持查询和配置BIOS选项的通用IPMI命令 |

# 2.功能设计
## 2.1 总体方案分析

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
新增两条IPMI命令：
GetBiosConfiguration
SetBiosConfiguration

实现策略：
根据名称查询/设置BIOS选项

#### 2.1.1.2 开发视图
不涉及

#### 2.1.1.3 运行视图
![支持查询和配置BIOS选项的通用IPMI命令运行视图](../image/支持查询和配置BIOS选项的通用IPMI命令运行视图.svg)

### 2.1.2 内部依赖分析
不涉及

### 2.1.3 外部依赖分析
不涉及

### 2.1.4 北向接口分析
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 支持查询和配置BIOS选项的通用IPMI命令 | NA | NA | NA | NA | Y | NA | NA |

涉及新增ipmi命令

### 2.1.5 兼容性分析
新增ipmi查询和配置BIOS选项功能，对现有功能无影响

### 2.1.6 定制化接口分析
不涉及

### 2.1.7 导入导出分析
不涉及

### 2.1.8 传感器分析
不涉及

### 2.1.9 精准告警事件分析
不涉及

### 2.1.10 系统锁定分析
不涉及

### 2.1.11 用例场景分析
| 编号 | 用例场景 | 预期 | 
| --- | --- | --- | 
| 1 | 发送设置BIOS选项的IPMI命令，设置的选项存在，设置的值在可设置范围内 | 设置成功 |
| 2 | 发送设置BIOS选项的IPMI命令，设置的选项不存在 | 设置失败，错误码0xc9|
| 3 | 发送设置BIOS选项的IPMI命令，设置的值不在可设置范围内 | 设置失败，错误码0xc9|
| 4 | 发送设置BIOS选项的IPMI命令，设置命令长度错误 | 设置失败，错误码0xc7|
| 5 | 发送获取BIOS选项的IPMI命令，获取选项存在，获取类型为已生效值 | 获取成功，获取值与其他接口获取值一致 |
| 6 | 发送获取BIOS选项的IPMI命令，获取选项存在，获取类型为待生效值 | 获取成功，获取值与其他接口获取值一致<br>若无待生效值，返回空 |
| 7 | 发送获取BIOS选项的IPMI命令，获取选项不存在 | 获取失败，错误码0xc9|
| 8 | 发送获取BIOS选项的IPMI命令，获取命令长度错误 | 获取失败，错误码0xc7|

## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
命令中预留字段，后续可扩展支持一条命令同时设置多个BIOS选项

### 2.2.2 重用性分析
重用原有的配置设置和获取功能

### 2.2.3 可测试性分析
可以直接通过发送新增的ipmi命令来验证

### 2.2.4 资料分析
涉及ipmi资料文档更新

### 2.2.5 资源使用分析
不涉及

### 2.2.6 可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | AC场景 | 设置值丢失 | 功能不生效 | 一般 | 数据做持久化 | 数据保存在文件里 |  | NA |
| 2 | 数据获取异常状态 | 获取属性值异常 | 获取功能异常 | 一般 | 对数据做校验 | NA |  | NA |
### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 涉及 | 限制接口权限 |
| 敏感数据 | 不涉及 |  |
| 日志（操作日志、维护日志、安全日志、运行日志） | 涉及 | 命令成功记录操作日志 |
| 文档 | 涉及 | ipmi文档需要刷新 |
| 加密及算法 | 不涉及 |  |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 不涉及 |  |
| 新增对外接口入参校验 | 不涉及 |  |
| 新增开源及三方软件引入 | 不涉及 |  |
# 3.功能实现
## 3.1【1】支持查询和配置BIOS选项的通用IPMI命令
### 3.1.1 功能实现设计
新增ipmi命令
GetBiosConfiguration
SetBiosConfiguration

### 3.1.2 功能详细设计
## Get命令

IPMI命令字：NetFn：0x30 Cmd：0x93
名称：Get Bios Configuration
变化类型：新增IPMI命令
应用场景：获取bios配置项
操作权限：ReadOnly
可执行角色等级：User

|字节顺序 | 域内容|
|--- | ---|
|NetFn | 30h|
|Cmd | 93h|
|1:3 | Manufacturer ID，LS Byte first。长度固定3个字节，例如，某厂家ID是2011，对应十六进制为0x0007DB，则字节序为第1个字节为DBh、第2个字节为07h、第3个字节为00h。|
|4 | Sub command，子命令=8Bh|
|5 | Systemid，系统id，表示查询对应系统的BIOS选项|
|6 | Type，查询类型：0-待生效的值，1-已生效的值|
|7：8 | Reserved，预留字段，默认填0|
|9 | Length，属性名长度N|
|10：N+9 | Property，属性名，区分大小写|

响应说明：

|字节顺序|域内容|
| --- | --- |
|1|Completion Code|
|2:4|Manufacturer ID，LS Byte first。长度固定3个字节，例如，某厂家ID是2011，对应十六进制为0x0007DB，则字节序为第1个字节为DBh、第2个字节为07h、第3个字节为00h。|
|5：6|Reserved，预留字段，默认填0|
|7|Type，属性值类型：0-字符串 1-数字|
|8|Length，属性值长度M|
|9：M+8|Value，属性值，ascii字符串，如果类型为数字，则为小端序。例：Type为0，属性值为0x68，表示"h"；Type为1，属性值为0x68，表示104|

## Set命令

IPMI命令字：NetFn：0x30 Cmd：0x93
名称：Set Bios Configuration
变化类型：新增IPMI命令
应用场景：设置bios配置项
操作权限：UserMgmt
可执行角色等级：Administrator

|字节顺序|域内容|
| --- | --- |
|NetFn|30h|
|Cmd|93h|
|1:3|Manufacturer ID，LS Byte first。长度固定3个字节，例如，某厂家ID是2011，对应十六进制为0x0007DB，则字节序为第1个字节为DBh、第2个字节为07h、第3个字节为00h。|
|4|Sub command，子命令=8Ch|
|5|Systemid，系统id，表示配置对应系统的BIOS选项|
|6：7|Reserved，预留字段，默认填0|
|8|Property length，属性名长度N|
|9：N+8|Property，属性名，区分大小写|
|N+9|Type，属性值类型：0-字符串 1-数字|
|N+10|Value length，属性值长度M|
|N+11：N+M+10|Value，属性值，ascii字符串，如果类型为数字，则为小端序。例：Type为0，属性值为0x68，表示"h"；Type为1，属性值为0x68，表示104|

响应说明：

|字节顺序|域内容|
| --- | --- |
|1|Completion Code|
|2:4|Manufacturer ID，LS Byte first。长度固定3个字节，例如，某厂家ID是2011，对应十六进制为0x0007DB，则字节序为第1个字节为DBh、第2个字节为07h、第3个字节为00h。|

## 错误场景：

### Get命令

|场景|错误码|错误码含义|
| --- | --- | --- |
| 未找到对应属性 | 0xC9 | ParmOutOfRange |
| 查询类型错误 | 0xC9 | ParmOutOfRange |
| 命令长度错误 | 0xC7 | ReqDataLenInvalid |

### Set命令

|场景|错误码|错误码含义|
| --- | --- | --- |
| 未找到对应属性 | 0xC9 | ParmOutOfRange |
| 属性值不在可设置范围内 | 0xC9 | ParmOutOfRange |
| 命令长度错误 | 0xC7 | ReqDataLenInvalid |

### 3.1.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
#### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->

单元测试新增命令
主要覆盖新增的对命令参数校验的函数，具体实现复用已有功能，由原有ut覆盖

| 编号 | 测试输入 | 输出 |
| ------- | ------- | -------- |
| 1 | 正确的命令参数 | 命令通过校验，返回成功的完成码 |
| 2 | 错误的命令参数 | 命令为通过校验，返回对应错误的完成码 |

#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->

覆盖新增命令
保证命令能正常调用

| 编号 | 测试输入 | 输出 |
| ------- | ------- | -------- |
| 1 | 拼出正确的命令，模拟发送get命令 | 命令成功调用，返回结果正确 |
| 2 | 拼出正确的命令，模拟发送set命令 | 命令成功调用，设置结果正确 |
| 3 | 拼出错误的命令（设置属性/设置值/长度/参数不对），模拟发送命令 | 命令调用失败，返回对应错误码 |