# BIOS

## 功能简介

bios组件主要是与带内交互模块，关键功能包含以下四个部分：

（1）配置：支持bios配置导入导出，支持启动项、启动模式设置，无感升级策略重配等

（2）证书：支持bios启动证书，bios安全启动证书，bios吊销证书管理

（3）升级：支持bios普通升级，无感升级，teeos升级（待实现）

（4）PFR：支持bios自愈功能

### 目录结构

```lua
├── src
│   ├── lualib-src
│   │   ├── CMakeLists.txt
│   │   └── mtd_api.c                               -- mtd驱动
│   ├── lualib
│   │   ├── bios_app.lua 					        -- bios_app文件
│   │   ├── domain
│   │   │   ├── bios_firmware
│   │   │   │   ├── defs.lua                        -- 固件定义信息文件
│   │   │   │   ├── gold                            -- bios固件
│   │   │   │   └── package                         -- bios升级包
│   │   │   ├── mapping
│   │   │   │   ├── component_info.lua              -- 无感升级文件基类
│   │   │   │   ├── component_manager.lua           -- 无感升级文件管理器
│   │   │   │   ├── component_version.lua           -- 无感升级版本文件
│   │   │   │   ├── policy_config_registery.lua     -- 策略重配registery文件
│   │   │   │   └── policy_config_value.lua         -- 策略重配当前值文件
│   │   │   ├── policy_config
│   │   │   │   ├── policy_config_transfer.lua      -- 策略重配转换
│   │   │   │   ├── policy_ipmi_format.lua          -- 策略重配ipmi命令格式转换
│   │   │   │   └── policy_registery.lua            -- 策略重配registery转换文件
│   │   │   └── transport
│   │   │       ├── component_communicate.lua       -- imu交互
│   │   │       ├── component_effective.lua         -- 无感升级生效
│   │   │       ├── component_info_query.lua        -- 查询无感升级文件
│   │   │       ├── component_process_query.lua     -- 查询无感升级进度
│   │   │       ├── component_send_confirmed.lua    -- 确认无感升级升结果
│   │   │       ├── component_upgrade.lua           -- 无感升级
│   │   │       └── imu_communicate.lua             -- imu交互
│   │   ├── factory
│   │   │   └── bios_factory.lua                    -- 工厂类
│   │   ├── handler
│   │   │   ├── bios_prop_handler.lua               -- 属性配置处理器
│   │   │   ├── config_handler.lua                  -- 配置处理器
│   │   │   ├── config_util.lua                     -- 配置处理器
│   │   │   ├── effective_time_handler.lua          -- 启动项生效次数处理器
│   │   │   ├── error_engineer.lua                  -- 错误引擎
│   │   │   ├── export_import_engine.lua            -- 导入导出处理器
│   │   │   ├── mode_handler.lua                    -- 启动模式处理器
│   │   │   └── start_option_handler.lua            -- 启动项处理器
│   │   ├── infrastructure
│   │   │   ├── chain.lua                           -- 责任链
│   │   │   ├── crc32.lua                           -- crc32
│   │   │   ├── file_util.lua                       -- 文件工具类
│   │   │   ├── firmware_upgrade.lua                -- 升级类
│   │   │   ├── fructl.lua                          -- 上下电类
│   │   │   ├── imu.lua                             -- imu交互类
│   │   │   ├── m3_verify.lua                       -- m3校验类
│   │   │   ├── power_lock.lua                      -- 上下电锁
│   │   │   ├── serialization_util.lua              -- 系列化列
│   │   │   └── spi_flash.lua                       -- spi工具
│   │   ├── interface
│   │   │   ├── mdb
│   │   │   │   └── firmware.lua                    -- 升级资源树
│   │   │   └── signal.lua                          -- 信号类
│   │   ├── pojo                                    -- 实体类
│   │   ├── service                                 -- 服务类
│   │   └── util                                    -- 工具类
│   └── service
│       └── main.lua                                -- app入口
```



## 关键特性

### 1、Bios升级

#### （1）介绍

​	Bios升级模式分为装备升级、非装备升级、无感升级。对于装备升级则会执行强制上下电，而非装备包不会。升级bios实质是将升级包的内容刷新到flash里面，对于无感升级底层是ipmb通道、而非无感升级底层是spi链路。

**升级模式区分**

| 升级模式     | 场景                                                         |
| ------------ | ------------------------------------------------------------ |
| 装备模式     | 打包manufacture文件夹（装备包）                              |
| 普通升级模式 | 未打包manufacture文件夹（装备包）                            |
| 无感升级模式 | 未打包manufacture文件夹（装备包）redfish下发无感升级（url：/redfish/v1/UpdateService/Actions/UpdateService.SimpleUpdate，且包含BiosActivatedScope参数） |

**升级动作区分**

| 升级模式           | 升级动作                                |
| ------------------ | --------------------------------------- |
| 装备升级           | 强制下电os，刷bios flash，上电os        |
| 非装备升级，os上电 | 缓存bios升级包，待下电刷flash（生效）   |
| 非装备升级，os下电 | 刷bios flash                            |
| 无感升级           | 通过ipmb通道将固件传到imu，实现在线升级 |

**升级包区分**

| 升级包类型             | 升级包的update.cfg |
| ---------------------- | ------------------ |
| 补丁包（无感升级的包） | 版本包含HPxxxx     |
| 普通包                 | 版本不包含HPxxxx   |

**升级场景匹配**

| 升级模式   | 升级包 | 是否不支持 |
| ---------- | ------ | ---------- |
| 装备升级   | 补丁包 | 不支持     |
| 装备升级   | 普通包 | 支持       |
| 非装备升级 | 补丁包 | 不支持     |
| 非装备升级 | 普通包 | 支持       |
| 无感升级   | 补丁包 | 支持       |
| 无感升级   | 普通包 | 不支持     |

#### （2）业务流程

升级生效流程如下：

bios升级流程，如下图所示，

- 首先判断是装备升级，然后判断是否补丁包，如果是补丁包则升级失败，否则就执行强制下电，通过spi链路将升级包写入flash，最后执行上电。
- 如果是非装备升级，则判断是无感升级，并且是否满足升级包为补丁包、os启动完成，如果满足则通过ipmb通道将升级包内容传到flash；否则升级失败。
- 如果是普通升级，判断当前os上下电状态，os上电则执行缓存升级包，os下电则通过spi链路将升级包写入flash。



![image](https://raw.gitcode.com/openUBMC/docs/blobs/65594f4e8936edd0c6cf1392c8dc3bb682049f91/%E5%8D%87%E7%BA%A7%E7%94%9F%E6%95%88%E6%B5%81%E7%A8%8B%E5%9B%BE.svg)

代码流程

bios升级流程分为prepare、process、finish阶段.

- prepare：此阶段主要解压升级包。
- process：此阶段主要是校验升级包、升级模式的合法性，以及将升级包通过spi或者ipmb通道传到flash中。
- finish：此阶段主要是做一些信息清理动作。

![image](https://raw.gitcode.com/openUBMC/docs/blobs/ca01b6b9205fc693b27943f664c5d12184a79197/%E4%BB%A3%E7%A0%81%E6%B5%81%E7%A8%8B%E5%9B%BE.png)

其中最关键的是upgrade_executor.lua中的一堆Executor，其是执行升级最关键的流程，Executor列表及作用如下：

| Executor名称         | Executor作用                                                 |
| -------------------- | ------------------------------------------------------------ |
| PackageCheckExecutor | 校验包合法性，如：冷升级不能升级补丁包、无感升级不能升级非补丁包、装备模式不能升级补丁包 |
| BackExecutor         | 将升级包压缩成bios.tar.gz                                    |
| Cache                | 上电升级缓存升级包，待下电生效                               |
| ForcePower           | 强制上下电，装备模式使用                                     |
| LockPower            | 上电锁，升级的时候需要锁住上下电，不允许上电                 |
| SpiDriver            | 加载spi驱动，通过spi可以将bin包内容刷入flash                 |
| DecompressFile       | 将bios.tar.gz解压成bin包（bin包大小与flash大小一样，地址也一致） |
| ParserBin            | 解析bin包，主要是header以及固件个数、固件大小、固件地址      |
| ComponentFilter      | 无感升级的时候，过滤版本一致的固件，这部分固件不升级         |
| SelectChannel        | 通道选择，无感升级（ipmb通道）、其他（spi链路）              |
| UpgradeComponent     | 升级固件                                                     |
| WaitUpgradeFinish    | 无感升级固件等待固件生效完成                                 |

#### （3）例子

**非无感升级**

- os下电场景下升级bios，可从带内界面看到bios升级中

**无感升级**

- 查询无感升级固件 URI：/redfish/v1/UpdateService/FirmwareInventory/Bios【其中Hotfix表示可以无感升级的固件】

![image](https://raw.gitcode.com/openUBMC/docs/blobs/95aac7f11ddc7cac5ee1905799b16c7d18fa3b56/%E6%97%A0%E6%84%9F%E5%8D%87%E7%BA%A7%E6%9F%A5%E8%AF%A2%E6%8E%A5%E5%8F%A3.png)


- 触发无感升级，且可从日志中看到升级成功的打印，以及版本发生变化

    ```
    url：/redfish/v1/UpdateService/Actions/UpdateService.SimpleUpdate
    参数：
    {
    	"ImageURI":"/tmp/biosimage_patch.hpm",
    	"BiosActivatedScope":["IMU","IMP","SCC"] --由上一步可查询
    }
    ```

![image](https://raw.gitcode.com/openUBMC/docs/blobs/209f0967b065c95bb887f71735b7b750148190a8/%E6%97%A0%E6%84%9F%E5%8D%87%E7%BA%A7%E6%BC%94%E7%A4%BA.png)

### 2、Bios配置导入导出

#### （1）介绍

- 除了在Bios setup界面进行Bios配置，还支持通过BMC下发Bios配置给bios，涉及到以下文件：

    - setting.json ：用户的Bios配置数据

    - currentValue.json：当前生效的Bios配置

    - Registery.json：配置的标准文件（可以判断下发的配置是否正确）

    - result.json：Bios运行的记录文件


#### （2）实现机制

- 接口层：主要是进行注册rpc接口，包括导入导出的接口。

- 服务层：主要是业务逻辑的代码。比如：file_service具有导出导入BIOS配置的能力；registry_service 具有处理registry.json文件的能力。

- 数据层：考虑到磁盘读写速度慢的问题，将磁盘数据加载到内存中，提高读写速度。registry_object是对registry.json文件的抽象；setting_object是对currentvalue.json、setting.json的抽象。

  ![img](https://raw.gitcode.com/openUBMC/docs/blobs/ced9396ba7479856625fd0100058d31e7e708837/3_Bios%E9%85%8D%E7%BD%AE%E5%AF%BC%E5%85%A5%E5%AF%BC%E5%87%BA1.svg)

- 导入配置涉及2个json文件（registery.json配置标准文件、currentvalue.json当前生效配置），导入的时候首先会根据registery.json文件的Attribute判断导入的配置是否合法，如果不合法则返回报错；然后会根据registery.json的Dependency和currentvalue.json配置，判断当前导入的配置是否满足对应的依赖关系，如果满足则允许导入，否则导入失败。


![img](https://raw.gitcode.com/openUBMC/docs/blobs/d35273920d08d169ad41d9abba23d5aae9ee3509/4_Bios%E9%85%8D%E7%BD%AE%E5%AF%BC%E5%85%A5%E5%AF%BC%E5%87%BA2.svg)



## 对外接口

### 资源协作接口

#### `/bmc/kepler/Systems/${SystemId}/Bios` - `ChangePassword`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/Bios` | `bmc.kepler.Systems.Bios` | `ChangePassword` | `a{ss}sss` | `i` | 修改bios密码 | 修改bios密码 | 旧密码正确，新密码符合校验规则 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/Bios` - `ClearCmos`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/Bios` | `bmc.kepler.Systems.Bios` | `ClearCmos` | `a{ss}` | `i` | 清除BIOS配置信息 | 清除BIOS配置信息 | 要有用户配置权限 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/Bios` - `ExportBiosSetup`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/Bios` | `bmc.kepler.Systems.Bios` | `ExportBiosSetup` | `a{ss}s` | `s` | 导出BIOS的配置 | 导出BIOS的配置 | 不涉及 | 不涉及 | 不涉及 | 依赖Bios上报配置 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/Bios` - `GetCurrentValueSetting`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/Bios` | `bmc.kepler.Systems.Bios` | `GetCurrentValueSetting` | `a{ss}s` | `s` | 获取属性当前配置的值 | 获取属性当前配置的值 | 不涉及 | 不涉及 | 不涉及 | 依赖Bios上报配置 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/Bios` - `ImportBiosSetup`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/Bios` | `bmc.kepler.Systems.Bios` | `ImportBiosSetup` | `a{ss}ss` | `i` | 导入Bios配置 | 导入Bios配置 | 导入配置符合格式和Bios依赖关系 | 不涉及 | 不涉及 | 依赖Bios上报配置规则 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/Bios` - `ResetSetupConfig`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/Bios` | `bmc.kepler.Systems.Bios` | `ResetSetupConfig` | `a{ss}` | `i` | 清除Bios配置以及待生效配置 | 清除Bios配置以及待生效配置 | 要有用户配置权限 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/Bios` - `SetBiosLogEnabled`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/Bios` | `bmc.kepler.Systems.Bios` | `SetBiosLogEnabled` | `a{ss}y` | `i` | 设置Bios日志全打印开关 | 设置Bios日志全打印开关 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/SecureBootOptions` - `GetCertificate`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/SecureBootOptions` | `bmc.kepler.Systems.SecureBootOptions` | `GetCertificate` | `a{ss}` | `s` | 获取Bios安全启动证书 | 获取Bios安全启动证书 | 不涉及 | 不涉及 | 不涉及 | bios不处于启动阶段 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/SecureBootOptions` - `ImportCertificate`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/SecureBootOptions` | `bmc.kepler.Systems.SecureBootOptions` | `ImportCertificate` | `a{ss}sss` | 不涉及 | 写入Bios安全启动证书 | 写入Bios安全启动证书 | 导入证书格式正确 | 不涉及 | 不涉及 | bios不处于启动阶段 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/SecureBootOptions` - `ResetCertificate`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/SecureBootOptions` | `bmc.kepler.Systems.SecureBootOptions` | `ResetCertificate` | `a{ss}ss` | 不涉及 | 重置Bios安全启动证书 | 重置Bios安全启动证书 | 不涉及 | 不涉及 | 不涉及 | bios不处于启动阶段 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/BootOptions` - `GetCertificate`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/BootOptions` | `bmc.kepler.Systems.BootOptions` | `GetCertificate` | `a{ss}` | `s` | 获取Bios的Https启动证书 | 获取Bios的Https启动证书 | 不涉及 | 不涉及 | 不涉及 | bios不处于启动阶段 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/BootOptions` - `ImportCertificate`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/BootOptions` | `bmc.kepler.Systems.BootOptions` | `ImportCertificate` | `a{ss}ss` | 不涉及 | 导入Bios的Https启动证书 | 导入Bios的Https启动证书 | 证书格式正确 | 不涉及 | 不涉及 | bios不处于启动阶段 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/BootOptions` - `ImportCrl`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/BootOptions` | `bmc.kepler.Systems.BootOptions` | `ImportCrl` | `a{ss}ss` | 不涉及 | 导入Bios的Https启动证书吊销列表 | 导入Bios的Https启动证书吊销列表 | 不涉及 | 不涉及 | 不涉及 | bios不处于启动阶段 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/BootOptions` - `ResetCertificate`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/BootOptions` | `bmc.kepler.Systems.BootOptions` | `ResetCertificate` | `a{ss}s` | 不涉及 | 重置Bios的Https启动证书 | 重置Bios的Https启动证书 | 不涉及 | 不涉及 | 不涉及 | bios不处于启动阶段 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/BootOptions` - `ResetCrl`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/BootOptions` | `bmc.kepler.Systems.BootOptions` | `ResetCrl` | `a{ss}s` | 不涉及 | 重置Bios的Https启动证书吊销列表 | 重置Bios的Https启动证书吊销列表 | 不涉及 | 不涉及 | 不涉及 | bios不处于启动阶段 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/BootOptions` - `SetBootMode`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/BootOptions` | `bmc.kepler.Systems.BootOptions` | `SetBootMode` | `a{ss}s` | `i` | 设置Bios启动模式 | 设置Bios启动模式 | 当前只支持设置UEFI | 不涉及 | 不涉及 | 不涉及 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/BootOptions` - `SetBootOrder`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/BootOptions` | `bmc.kepler.Systems.BootOptions` | `SetBootOrder` | `a{ss}s` | `iss` | 设置Bios启动顺序 | 设置Bios启动顺序 | 启动顺序符合规则 | 不涉及 | 不涉及 | 依赖Bios上报配置规则 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/BootOptions` - `SetStartOption`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/BootOptions` | `bmc.kepler.Systems.BootOptions` | `SetStartOption` | `a{ss}s` | `i` | 设置Bios启动项 | 设置Bios启动项 | 启动项可选：None、Pxe、Floppy、Cd、Hdd、BiosSetup | 不涉及 | 不涉及 | 不涉及 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/BootOptions` - `SetStartOptionFlag`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/BootOptions` | `bmc.kepler.Systems.BootOptions` | `SetStartOptionFlag` | `a{ss}s` | `i` | 设置Bios启动项生效次数 | 设置Bios启动项生效次数 | 可选生效次数：Disabled、Once、Continuous | 不涉及 | 不涉及 | 不涉及 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/BiosUpgradeService` - `ActivateFirmware`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/BiosUpgradeService` | `bmc.kepler.Systems.BiosUpgradeService` | `ActivateFirmware` | `a{ss}as` | 不涉及 | 生效Bios固件 | 生效Bios固件 | 需要是可生效固件 | 不涉及 | 不涉及 | 执行过无感升级 | 不涉及 | SystemId唯一 | 不涉及 |

---

#### `/bmc/kepler/Systems/${SystemId}/BiosUpgradeService` - `ExportBiosFirmware`

| 接口路径（path） | 接口名称（interface） | 方法名（method） | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/${SystemId}/BiosUpgradeService` | `bmc.kepler.Systems.BiosUpgradeService` | `ExportBiosFirmware` | `a{ss}` | `u` | 导出Bios固件信息 | 导出Bios固件信息 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | SystemId唯一 | 不涉及 |
 

### ipmi接口

| 命令                          | 描述                                     |
| ----------------------------- | :--------------------------------------- |
| SetBootOption                 | 设置启动项                               |
| GetBootOption                 | 获取启动项                               |
| SetBridgeSystemInfo           | 设置启动项（BridgeSystemInfo）           |
| SetChannelInfo                | 设置启动项（ChannelInfo）                |
| SetDeviceSystemInfo           | 设置启动项（DeviceSystemInfo）           |
| SetOperatingSystemName        | 设置启动项（OperatingSystemNam）         |
| SetPrimaryOperatingSystemName | 设置启动项（PrimaryOperatingSystemName） |
| SetProgressSystemInfo         | 设置启动项（ProgressSystemInfo）         |
| SetSystemName                 | 设置启动项（SystemName）                 |
| WriteOcpCardBdfToBmc          | 设置OCP卡的BDF                           |
| WritePcieCardBdfToBmc         | 设置PCIE卡的BDF                          |
| WritePcieDiskBdfToBmc         | 设置硬盘的BDF                            |
| GetBridgeSystemInfo           | 获取启动项（BridgeSystemInfo）           |
| GetChannelInfo                | 获取启动项（ChannelInfo）                |
| GetDeviceSystemInfo           | 获取启动项（DeviceSystemInfo）           |
| GetOperatingSystemName        | 获取启动项（OperatingSystemName）        |
| GetPrimaryOperatingSystemName | 获取启动项（PrimaryOperatingSystemName） |
| GetProgressSystemInfo         | 获取启动项（ProgressSystemInfo）         |
| GetSystemFirmwareVersion      | 获取启动项（SystemFirmwareVersion）      |
| GetSystemName                 | 获取启动项（SystemName）                 |
| GetBiosGoldValid              | 获取固件备份状态                         |
| AddBiosLogEntry               | 设置bios日志信息                         |
| GetBiosBootInfo               | 获取bios启动参数                         |
| GetFileChanged                | 获取bios配置文件修改状态                 |
| GetSmBiosInfo                 | 获取smbios信息                           |
| ReadFileFromBmc               | 从bmc读取配置文件                        |
| SetBiosBootInfo               | 设置bios启动参数                         |
| SetBiosVersion                | 设置bios版本                             |
| SetCertificateAssertion       | 设置bios证书过期告警                     |
| SetFileChanged                | 设置bios配置文件修改状态                 |
| SetSmBiosInfo                 | 设置smbios信息                           |
| UpdateBiosPassword            | 设置bios密码                             |
| UpdateBiosStatus              | 设置bios启动状态                         |
| UpdatePostStatus              | 设置bios完成启动状态                     |
| WriteFileToBmc                | 上报bios配置文件                         |
| WriteSmbiosData               | 上报smbios配置文件                       |



## 配置介绍

不涉及



###  



