[![Powered by openUBMC](https://img.shields.io/badge/powered%20by-openUBMC-orange.svg?label=技术支持&color=blue)](https://openubmc.cn)
[![PyPI Downloads](https://img.shields.io/pypi/dm/openubmc-bingo.svg?label=PyPI%20下载量)](https://pypi.org/project/openubmc-bingo/)

# bingo

bingo承载了BMC开发的工程工具和最佳实践，提供一站式命令行工具，降低组件开发成本。

# 安装/升级

## 安装
### 0. 检查本地是否已配置 APT 源
```bash
sudo apt update
apt policy openubmc-bingo
```
如果有如下输出，说明 APT 源已配置完成，可以直接执行步骤 [4](#4-直接从-pypi-安装)
```bash
openubmc-bingo:
  Installed: 0.0.1
  Candidate: 0.0.1
  Version table:
     0.0.1 500
        500 https://openubmc-apt-repo.obs.cn-north-4.myhuaweicloud.com/Ubuntu noble/main amd64 Packages
```
### 1. 安装 GPG 公钥
* 方式一：直接下载 GPG 文件安装
```bash
# 指定下载公钥的位置
sudo mkdir -p /etc/apt/keyrings
# 下载 GPG 文件
wget -O- https://openubmc-apt-repo.obs.cn-north-4.myhuaweicloud.com/Ubuntu/gpg_key.public | sudo gpg --dearmor -o /etc/apt/keyrings/openubmc.gpg
```
* 方式二：通过公钥服务器下载
```bash
# 指定下载公钥的位置
sudo mkdir -p /etc/apt/keyrings
# 下载 GPG 文件
gpg --keyserver keyserver.ubuntu.com --recv-keys BF3B2D407FDEDEA0DC91CC9412640FBCB175287A
gpg --export BF3B2D407FDEDEA0DC91CC9412640FBCB175287A | sudo tee /etc/apt/keyrings/openubmc.gpg >/dev/null
```
### 2. 配置 APT 源
```bash
echo "deb [arch=amd64 signed-by=/etc/apt/keyrings/openubmc.gpg] https://openubmc-apt-repo.obs.cn-north-4.myhuaweicloud.com/Ubuntu/ noble main" | sudo tee /etc/apt/sources.list.d/openubmc.list
```
### 3. 验证APT配置
```bash
sudo apt update
apt policy openubmc-bingo
```
### 4. 直接从 [PyPI](https://pypi.org/project/openubmc-bingo/) 安装
```shell
pip3 install openubmc-bingo
bingo upgrade
```
## 升级
1. 升级到最新版本
```shell
bingo upgrade
# 或者
# bingo upgrade --version bingo=latest
# 或者
# bingo upgrade --version bingo=<PyPI 最新版本号>
```
2. 升级到指定版本
```shell
bingo upgrade --version bingo=<指定版本号>
```
3. 指定版本范围
```shell
# 升级到大于等于 <指定版本号> 的最高版本
bingo upgrade --version 'bingo>=<指定版本号>'
```


# 命令帮助
`bingo help`可查询bingo支持的子命令，`bingo <command> --help`可查询bingo子命令command的帮助信息。bingo具有配置探测能力，根据仓库的配置显示支持该仓库的相应子命令。


# 开发/调试
bingo包含python和shell开发语言。在构建时会打包生成pip包和deb包。

## 开发
代码修改开发完成后，可执行以下命令卸载已有bingo并重新安装bingo到本地环境中。
```sh
sh install_local.sh
```

## 调试
前提条件：VSCode安装了Python Debugger插件。

bingo提供了在VSCode本地调试bingo命令的脚本。调试前在`debug.py`中修改需要调试的目标目录`DEBUG_TARGET_RELATIVE_PATH`及bingo命令`DEBUG_COMMAND`。
```py
# 调试执行bingo命令的目录相对debug.py的相对路径，默认为bingo的当前路径
DEBUG_TARGET_RELATIVE_PATH = "."
# 需要调试的bingo命令，默认为bingo help
DEBUG_COMMAND = "bingo help"
```


# 构建产品包与发布包

我们构建命令目前已经集成到`bingo`命令中，这个命令在环境中已安装，只需要执行命令即可，我们先来看下`bingo`的帮助文档，这个帮助文档会在`manifest`仓路径(也就是产品路径)和组件仓路径显示不同，此节只讨论产品构建。

```shell
# 在manifest路径下执行命令
[04:51:58 root(1110):/home/workspace/codehome/manifest]# bingo --help
Integrated commands
    build              构建出包
    publish            构建版本发布包，-sc参数指定ToSupportE编码
Misc commands
    help               获取命令帮助
    new                创建组件
    diff               获取两个产品版本间, 组件版本变更时的合并记录
    fetch              基于参数指定的单个、部分、全量组件版本拉取源代码
    config             bingo参数配置
    upgrade            升级 bingo 版本
    analysis           依赖和接口分析
Studio commands
    studio             执行bmc studio启动停止操作
    check              BMC Studio语法正确性与模型一致性检查

输入"bingo <command> -h"获取子命令帮助
[04:52:01 root(1110):/home/workspace/codehome/manifest]#
```

从上面返回的日志，可以看到我们能够使用的命令，构建产品以及发布包只使用到其中一个命令，当前`build`命令与`publish`效果相同，其余命令后续自行深入学习，输入`build`的`help`命令，可以看到这个命令有很多的内容，部分版本有些命令没有，但是可以构建出`hpm`包，对出包没有影响

```shell
[04:52:01 root(1110):/home/workspace/codehome/manifest]# bingo build --help
构建BMC

options:
  -h, --help            show this help message and exit
  -b BOARD_NAME, --board_name BOARD_NAME
                        单板包，可选值为build/product/|...>/下的目录名
                        默认：openUBMC
                        支持的单板列表：
                        openUBMC
  -bt BUILD_TYPE, --build_type BUILD_TYPE
                        构建类型，可选：debug（调试包）, release（正式包）, dt（开发者测试包）
  --stage STAGE         包类型，可选值为: dev(调试包), rc（预发布包）, stable（发布包）
                        默认：dev
  --verbose             使能conan构建详细日志打印
  -ucc, --update_conan_cache
                        全量更新本地conan缓存
  -r REMOTE, --remote REMOTE
                        conan仓别名，请检查conan remote list查看已配置的conan仓
                        默认: openubmc_dev
  -sc SUPPORTE_CODE, --supporte_code SUPPORTE_CODE
                        待发布的SupportE编码，可选值参考单板manifest.yml/tosupporte
                        默认：default
  -v VERSION, --version VERSION
                        构建版本号，不指定时从manifest.yml读取
  -t TARGET, --target TARGET
                        构建目标，请查看build/target目录, 支持的目标：
                        install_sdk
                        personal
                        publish
                        app
[04:59:33 root(1110):/home/workspace/codehome/manifest]#
```

## 构建产品包

1. 构建`hpm`包
    现在，开始构建一个`hpm`包，查看上面的`help`文档，可分析其具体含义，命令执行结束后，可在`manifest`目录下的`output`目录下找到构建出来的`hpm`包
    ```shell
    # 进入到集成构建环境
    cd manifest
    # -t personal: 构建目标，个人构建指 hpm 包
    # -b openUBMC: 单板名，执行bingo build -h，可以看到支持哪些单板
    # -bt release: 构建类型，release正式包
    # --stage rc: 包类型，预发布包
    bingo build -t personal -b openUBMC -bt release --stage rc
    ```

    以下为列出的生成件目录下文件，其中`rootfs_openUBMC.hpm`即为产品包

    ```shell
    [05:22:48 root(1110):/home/workspace/codehome/manifest/output]# ls -l
    total 70172
    -rw-r--r--  1 root root     1349 Mar 12 17:22 openubmc.perf
    -rw-r--r--  1 root root    54813 Mar 12 17:22 package.lock
    drwxr-xr-x  5 root root     4096 Mar  7 14:32 packet
    -rw-r--r--  1 root root        0 Mar 12 17:20 prof.perf.lock
    -rw-r--r--  2 root root 70144173 Mar 12 17:22 rootfs_openUBMC.hpm
    [05:23:04 root(1110):/home/workspace/codehome/manifest/output]#
    ```
2. 集成发布的组件

    根据章节的流程，已经了解了组件的发布，组件发布以后，我们需要集成到产品包中，具体修改方法如下
    * 第一步: 构建组件发布版本
    在流程中，已经有组件的构建方法与发布方法，如果不清楚，请查看<font color="red">[组件构建与发布](/zh/development/develop_guide/app_development/build_process.html)</font>
    * 第二步: 在`subsys`目录下配置发布的组件版本
    我们需要在`subsys`目录下添加新增的组件，组件属于什么类型，则添加到相应类型下，`subsys`目录下有`rc`和`stable`区分，组件发布对应的类型并在`rc`和
    `stable`目录下同时更改，这里的示例为`rc`版本，`stable`版本后缀要更新为`stable`
    ```yaml
    # yaml-language-server: $schema=../../schema/subsys.rc.schema.json
    dependencies:
    - conan: "rackmount/1.70.172@openUBMC.release/rc"
    ```
    * 第三步: 在`manifest.yml`文件中配置添加的组件
    新引入的组件，要在产品目录下配置相应的依赖，否则不会集成到产品包当中，`dependencies`字段中，每配置一个组件，则集成进一个组件，这里不要去填版本号，填入版本号后，更新组件版本时，则需要变更多个文件
    ```yaml
    dependencies:
    - conan: "huawei_secure_c"
    - conan: "kmc"
    - conan: "Signature_Verify_CBB_Library"
    - conan: "sqlite3"
    - conan: "openssh"
    ```
    * 第四步: 构建产品包
    使用第1小节的构建命令，则可以构建出产品包`hpm`

## 构建发布包
构建发布包命令与上面的命令稍有差异，如下所示
```shell
# 进入到集成构建环境
cd manifest
# -t publish: 构建目标，发布包
# -sc default: 发布包编码，这个编码可以在manifest.yml文件中的 tosupporte 字段中查询
# -b openUBMC: 单板名，查看帮助文档，可以看到支持哪些单板
# -bt release: 构建类型，release正式包
# --stage stable: 包类型，发布包
bingo build -t publish -sc default -b openUBMC -bt release --stage stable
```

执行完成以后，在`output`目录下会生成文件，如下为`output`树

```shell
[07:05:30 root(1110):/home/workspace/codehome/manifest/output]# tree
.
|-- openUBMC.perf
|-- package.lock
|-- packet
|   |-- openUBMC
|   |   |-- openUBMC-CMT_1.00.00.00.zip
|   `-- inner
|       |-- release
|       |   |-- package_openUBMC.lock
|-- prof.perf.lock
`-- rootfs_openUBMC.hpm

4 directories, 6 files
[07:05:31 root(1110):/home/workspace/codehome/manifest/output]#
```

---

# 组件构建与发布
在构建组件时，我们需要切换到组件目录，执行`bingo`命令，否则`bingo`命令不生效，这里以组件`iam`组件来作为示例，演示组件的构建流程。

进入到`iam`的源码目录，执行如下命令来查看支持的构建参数
```shell
[07:16:31 root(1110):/home/workspace/codehome/iam]# bingo --help
Component commands
    build              构建出包
    deploy             将组件及其依赖部署至temp/rootfs目录
    test               构建DT.
    gen                代码自动生成，支持Lua和C语言，C组件需要在service.json中添加`"language": "c",`配置.
Misc commands
    help               获取命令帮助

输入"bingo <command> -h"获取子命令帮助
[07:16:33 root(1110):/home/workspace/codehome/iam]#
```
在上面返回的结果中，我们只使用到部分，`build`,`gen`为主要使用的命令，下面主要介绍这两条命令

## 代码自动生成
`gen`命令用来自动生成代码，现在组件的代码都是使用此工具来自动生成，自动生成后才能进行构建，所以这里先讲`gen`命令，查看`gen`命令的help菜单
```shell
[07:28:19 root(1110):/home/workspace/codehome/iam]# bingo gen --help
usage: bingo gen/当前只支持C和lua语言代码生成 [-h] [-v VERSION] [-w]

代码自动生成.

options:
  -h, --help            show this help message and exit
  -v VERSION, --version VERSION
                        use specified version
  -w, --with_template   generate with template
[07:33:21 root(1110):/home/workspace/codehome/iam]#
```
从返回结果，可以看到这个参数结构相对比较简单，建立好模板文件，使用如下命令即可生成代码
```shell
# -bt debug: 构建类型
# --stage rc: 预发布包
# 如果在mds目录下配置了model.json，则带上-w参数来进行模板生成
bingo gen -bt debug --stage rc
# 日志截取，没有发生报错，则表示自动生成成功
python3 /home/workspace/codehome/iam/temp/lua_codegen/script/template.py -d /home/workspace/codehome/iam/proto -j /home/workspace/codehome/iam/temp/lua_codegen/temp/iam/ -n iam -i /home/workspace/codehome/iam/temp/lua_codegen/temp/iam/db_json.json -f /home/workspace/codehome/iam/temp/lua_codegen/script/lua_format.py -t orm_classes.lua.mako -o /home/workspace/codehome/iam/gen/iam/orm_classes.lua
make[3]: Leaving directory '/home/workspace/codehome/iam/temp/lua_codegen/templates/apps'
make[2]: Leaving directory '/home/workspace/codehome/iam/temp/lua_codegen/templates'
make[1]: Leaving directory '/home/workspace/codehome/iam/temp/lua_codegen'
```
## 组件构建

`build`命令用来构建组件的版本包，使用`help`命令来看下`build`命令的帮助文档
```shell
[07:16:33 root(1110):/home/workspace/codehome/iam]# bingo build --help
usage: bingo [-h] [-b BOARD_NAME] [-bt BUILD_TYPE] [--stage STAGE] [-u] [-r REMOTE] [-s] [-nc] [-o OPTIONS] [--user USER] [--summary] [--minimum]
             [--package_info PACKAGE_INFO]

component dt different version

options:
  -h, --help            show this help message and exit
  -b BOARD_NAME, --board_name BOARD_NAME
                        支持的单板名，请参考manifest/build/product目录
  -bt BUILD_TYPE, --build_type BUILD_TYPE
                        构建类型，可选：dt,debug,release 默认：debug
  --stage STAGE         组件包发布阶段, 可选: dev(developer), pre, rc, stable 默认：dev
  -u, --upload          上传组件包到conan仓
  -r REMOTE, --remote REMOTE
                        conan仓别名，请检查conan remote list查看已配置的conan仓 默认: openubmc_dev
  -nc, --no_cache       不使用~/.conan/data目录下的缓存包(构建前删除缓存)
  -o OPTIONS, --options OPTIONS
                        Define options values (host machine), e.g.: -o Pkg:with_qt=true
  --user USER           指定conan包的user字段，尝试从/etc/bmcgo.conf文件读取conan.user字段，否则由程序管理
  --summary             打印conan构建详细日志，默认：打印简要信息
  --minimum, -m         获取 dt 构建的最小版本
  --package_info PACKAGE_INFO, -pi PACKAGE_INFO
                        package_info 文件路径, 此文件在 manifest 构建时会在 inner 目录生成
[07:20:03 root(1110):/home/workspace/codehome/iam]#
```

根据上面的返回结果，需要使用的参数只有其中几个，以具体实例来讲解

```shell
# -b Board_A: 指定单板名，某些组件和单板名挂钩，需要指定单板名来打入某些文件，如果组件和单板无关，不带此参数
# -bt debug: 构建类型，调试包
# --stage rc: 预发布包
bingo build -b Board_A -bt debug --stage rc
# 截取部分日志放在这里
Downloading conanmanifest.txt completed [17.89k]
Downloading conaninfo.txt completed [2.97k]
Downloading conan_package.tgz completed [543.98k]
Decompressing conan_package.tgz completed [0.00k]
iam/1.20.31@openUBMC.release/rc: Package installed cb9794cb17b2f104bdddb1803a0104b29d12d75c
iam/1.20.31@openUBMC.release/rc: Downloaded package revision 35401b8fc57f5024055b6203bbd5abfe
Build successfully
[07:28:19 root(1110):/home/workspace/codehome/iam]#
```
在Build successfully上方，能看到编译完成的版本号，这个版本号就是生成的组件版本

## 组件测试

`test`命令用来执行组件的集成测试，单元测试，压力测试，使用`help`命令来看下`test`命令的帮助文档

```shell
bingo test -h
optional arguments:
  -h, --help            show this help message and exit
  -bt BUILD_TYPE, --build_type BUILD_TYPE
                        构建类型，可选：dt,debug,release 默认：debug
  --stage STAGE         组件包发布阶段, 可选: dev(developer), pre, rc, stable 默认：dev
  -u, --upload          上传组件包到conan仓
  -r REMOTE, --remote REMOTE
                        conan仓别名，请检查conan remote list查看已配置的conan仓 默认: openubmc_dev
  -nc, --no_cache       不使用~/.conan/data目录下的缓存包(构建前删除缓存)
  -o OPTIONS, --options OPTIONS
                        Define options values (host machine), e.g.: -o Pkg:with_qt=True 或 Pkg/*:with_qt=True
  --user USER           指定conan包的user字段，尝试从/etc/bmcgo.conf文件读取conan.user字段，否则由程序管理
  -pr PROFILE, --profile PROFILE
                        显式指定conan构建使用的profile文件 (~/.conan/profiles目录下)别名, 默认为: 空 可选值: profile.dt.ini, profile.ini, default
  -ut, --unit_test      Enable unit test
  -it, --integration_test
                        Enable integration test
  -ft, --fuzz_test      Enable fuzz test
  -fg, --fuzz_gen       Generate fuzz case
  -cnt FUZZ_COUNT, --fuzz_count FUZZ_COUNT
                        Fuzz count
  -f TEST_FILTER, --test_filter TEST_FILTER
                        Run unit test with a filter
  -a APP, --app APP     App in hica
  -wb, --without_build  测试时不重新构建
  --minimum, -m         获取dt构建的最小版本
  --package_info PACKAGE_INFO, -pi PACKAGE_INFO
                        package_info 文件路径, 使用manifest配套版本dt构建, 此文件在manifest构建时会在inner目录生成
```

从返回结果，可以看到这个参数结构相对比较简单，使用如下命令即可执行组件测试

```shell
# 集成测试
bingo test -it
# 单元测试
bingo test -ut
# 日志截取，没有发生报错，则表示测试通过
================ 开发者测试开始 ================
================ 测试 bios 开始 ================
1..x
# Started on Thu Dec 12 10:24:16 2024
# Starting class: TestBiosVersion
ok     1        TestBiosVersion.test_judge_manu_id_valid
......

Dt 报告结果输出到 /root/bios/temp/coverage/dt_result.json
================================ 构建菜单 ================================
单元测试(ut):                      True
集成测试(it):                      False
覆盖率:                           False
地址消毒:                          False
============================================================================
===>>>> 测试: bios/1.70.27@openUBMC.dev/dev 完成
```