-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "service.lua.mako"
local ipmi = require 'ipmi'
local mdb = require 'mc.mdb'
local class = require 'mc.class'
local open_db = require 'iam.db'
local app_base = require 'mc.service_app_base'
local object_manage = require 'mc.mdb.object_manage'
local persist_client = require 'persistence.persist_client_lib'
local orm_classes = require 'iam.orm_classes'
local ok, datas = pcall(require, 'iam.datas')
if not ok then
    datas = nil -- 如果没有datas配置，证明当前组件不需要datas，仅打开数据库
end

local SessionServiceTypes = require 'iam.json_types.SessionService'
local PropertiesTypes = require 'iam.json_types.Properties'
local SessionTypes = require 'iam.json_types.Session'
local AuthenticationTypes = require 'iam.json_types.Authentication'
local RMCPTypes = require 'iam.json_types.RMCP'
local SessionsTypes = require 'iam.json_types.Sessions'
local LDAPTypes = require 'iam.json_types.LDAP'
local LDAPControllerTypes = require 'iam.json_types.LDAPController'
local KerberosTypes = require 'iam.json_types.Kerberos'
local RemoteGroupsTypes = require 'iam.json_types.RemoteGroups'
local RemoteGroupTypes = require 'iam.json_types.RemoteGroup'
local CertificateAuthenticationTypes = require 'iam.json_types.CertificateAuthentication'

local SessionService = mdb.register_object('/bmc/kepler/SessionService/:SessionType', {
    {name = 'bmc.kepler.SessionService', interface = SessionServiceTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function SessionService:ctor(SessionType)
    self.path = '/bmc/kepler/SessionService/' .. SessionType
end

local Session = mdb.register_object('/bmc/kepler/SessionService/Sessions/:SessionId', {
    {name = 'bmc.kepler.SessionService.Session', interface = SessionTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function Session:ctor(SessionId)
    self.path = '/bmc/kepler/SessionService/Sessions/' .. SessionId
end

local Authentication = mdb.register_object('/bmc/kepler/AccountService/Authentication', {
    {name = 'bmc.kepler.AccountService.Authentication', interface = AuthenticationTypes.interface},
    {name = 'bmc.kepler.AccountService.Authentication.RMCP', interface = RMCPTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function Authentication:ctor()
    self.path = '/bmc/kepler/AccountService/Authentication'
end

local Sessions = mdb.register_object('/bmc/kepler/SessionService/Sessions', {
    {name = 'bmc.kepler.SessionService.Sessions', interface = SessionsTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function Sessions:ctor()
    self.path = '/bmc/kepler/SessionService/Sessions'
end

local LDAP = mdb.register_object('/bmc/kepler/AccountService/LDAP', {
    {name = 'bmc.kepler.AccountService.LDAP', interface = LDAPTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function LDAP:ctor()
    self.path = '/bmc/kepler/AccountService/LDAP'
end

local LDAPController = mdb.register_object('/bmc/kepler/AccountService/LDAP/LDAPController/:ControllerId', {
    {name = 'bmc.kepler.AccountService.LDAP.LDAPController', interface = LDAPControllerTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function LDAPController:ctor(ControllerId)
    self.path = '/bmc/kepler/AccountService/LDAP/LDAPController/' .. ControllerId
end

local Kerberos = mdb.register_object('/bmc/kepler/AccountService/Kerberos', {
    {name = 'bmc.kepler.AccountService.Kerberos', interface = KerberosTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function Kerberos:ctor()
    self.path = '/bmc/kepler/AccountService/Kerberos'
end

local RemoteGroups = mdb.register_object('/bmc/kepler/AccountService/RemoteGroups', {
    {name = 'bmc.kepler.AccountService.RemoteGroups', interface = RemoteGroupsTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function RemoteGroups:ctor()
    self.path = '/bmc/kepler/AccountService/RemoteGroups'
end

local RemoteGroup = mdb.register_object('/bmc/kepler/AccountService/RemoteGroups/:Id', {
    {name = 'bmc.kepler.AccountService.RemoteGroup', interface = RemoteGroupTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function RemoteGroup:ctor(Id)
    self.path = '/bmc/kepler/AccountService/RemoteGroups/' .. Id
end

local CertificateAuthentication = mdb.register_object('/bmc/kepler/AccountService/CertificateAuthentication', {
    {name = 'bmc.kepler.AccountService.CertificateAuthentication', interface = CertificateAuthenticationTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function CertificateAuthentication:ctor()
    self.path = '/bmc/kepler/AccountService/CertificateAuthentication'
end

local model = require 'class.model'

local iam_service = class(app_base.Service)

iam_service.package = 'iam'

function iam_service:CreateSessionService(SessionType, prop_setting_cb)
    local path = '/bmc/kepler/SessionService/' .. SessionType
    return object_manage.create_object('SessionService', path, path, prop_setting_cb)
end

function iam_service:CreateSession(SessionId, prop_setting_cb)
    local path = '/bmc/kepler/SessionService/Sessions/' .. SessionId
    return object_manage.create_object('Session', path, path, prop_setting_cb)
end

function iam_service:CreateAuthentication(prop_setting_cb)
    return object_manage.create_object('Authentication', 'Authentication_0',
        '/bmc/kepler/AccountService/Authentication', prop_setting_cb)
end

function iam_service:CreateSessions(prop_setting_cb)
    return object_manage.create_object('Sessions', 'Sessions_0', '/bmc/kepler/SessionService/Sessions', prop_setting_cb)
end

function iam_service:CreateLDAP(prop_setting_cb)
    return object_manage.create_object('LDAP', 'LDAP_0', '/bmc/kepler/AccountService/LDAP', prop_setting_cb)
end

function iam_service:CreateLDAPController(ControllerId, prop_setting_cb)
    local path = '/bmc/kepler/AccountService/LDAP/LDAPController/' .. ControllerId
    return object_manage.create_object('LDAPController', path, path, prop_setting_cb)
end

function iam_service:CreateKerberos(prop_setting_cb)
    return object_manage.create_object('Kerberos', 'Kerberos_0', '/bmc/kepler/AccountService/Kerberos', prop_setting_cb)
end

function iam_service:CreateRemoteGroups(prop_setting_cb)
    return object_manage.create_object('RemoteGroups', 'RemoteGroups_0', '/bmc/kepler/AccountService/RemoteGroups',
        prop_setting_cb)
end

function iam_service:CreateRemoteGroup(Id, prop_setting_cb)
    local path = '/bmc/kepler/AccountService/RemoteGroups/' .. Id
    return object_manage.create_object('RemoteGroup', path, path, prop_setting_cb)
end

function iam_service:CreateCertificateAuthentication(prop_setting_cb)
    return object_manage.create_object('CertificateAuthentication', 'CertificateAuthentication_0',
        '/bmc/kepler/AccountService/CertificateAuthentication', prop_setting_cb)
end

function iam_service:ImplSessionSessionSessionDelete(cb)
    model.ImplSessionSessionSessionDelete(cb)
end

function iam_service:ImplAuthenticationAuthenticationAuthenticate(cb)
    model.ImplAuthenticationAuthenticationAuthenticate(cb)
end

function iam_service:ImplAuthenticationRMCPGenRakp2AuthCode(cb)
    model.ImplAuthenticationRMCPGenRakp2AuthCode(cb)
end

function iam_service:ImplAuthenticationRMCPAuthRakp3(cb)
    model.ImplAuthenticationRMCPAuthRakp3(cb)
end

function iam_service:ImplAuthenticationRMCPGenSik(cb)
    model.ImplAuthenticationRMCPGenSik(cb)
end

function iam_service:ImplAuthenticationRMCPGenRmcpAuthCode(cb)
    model.ImplAuthenticationRMCPGenRmcpAuthCode(cb)
end

function iam_service:ImplAuthenticationRMCPCheckRmcpAuthCode(cb)
    model.ImplAuthenticationRMCPCheckRmcpAuthCode(cb)
end

function iam_service:ImplSessionsSessionsNewSession(cb)
    model.ImplSessionsSessionsNewSession(cb)
end

function iam_service:ImplSessionsSessionsNewRemoteConsoleSession(cb)
    model.ImplSessionsSessionsNewRemoteConsoleSession(cb)
end

function iam_service:ImplSessionsSessionsNewVNCSession(cb)
    model.ImplSessionsSessionsNewVNCSession(cb)
end

function iam_service:ImplSessionsSessionsSessionHeartBeat(cb)
    model.ImplSessionsSessionsSessionHeartBeat(cb)
end

function iam_service:ImplSessionsSessionsGetCLISessionList(cb)
    model.ImplSessionsSessionsGetCLISessionList(cb)
end

function iam_service:ImplSessionsSessionsNewSessionBySSO(cb)
    model.ImplSessionsSessionsNewSessionBySSO(cb)
end

function iam_service:ImplSessionsSessionsSetKvmKey(cb)
    model.ImplSessionsSessionsSetKvmKey(cb)
end

function iam_service:ImplSessionsSessionsDeleteAllSessions(cb)
    model.ImplSessionsSessionsDeleteAllSessions(cb)
end

function iam_service:ImplSessionsSessionsNewSessionByCert(cb)
    model.ImplSessionsSessionsNewSessionByCert(cb)
end

function iam_service:ImplSessionsSessionsValidateSessionWithCsrf(cb)
    model.ImplSessionsSessionsValidateSessionWithCsrf(cb)
end

function iam_service:ImplSessionsSessionsValidateSession(cb)
    model.ImplSessionsSessionsValidateSession(cb)
end

function iam_service:ImplSessionsSessionsGetSessionLogoutType(cb)
    model.ImplSessionsSessionsGetSessionLogoutType(cb)
end

function iam_service:ImplLDAPControllerLDAPControllerSetBindDnPassword(cb)
    model.ImplLDAPControllerLDAPControllerSetBindDnPassword(cb)
end

function iam_service:ImplKerberosKerberosImportKeyTable(cb)
    model.ImplKerberosKerberosImportKeyTable(cb)
end

function iam_service:ImplRemoteGroupsRemoteGroupsNew(cb)
    model.ImplRemoteGroupsRemoteGroupsNew(cb)
end

function iam_service:ImplRemoteGroupRemoteGroupDelete(cb)
    model.ImplRemoteGroupRemoteGroupDelete(cb)
end

function iam_service:get_bus()
    return self.bus
end

function iam_service:register_ipmi_cmd(ipmi_cmd, cb)
    self.ipmi_cmds[ipmi_cmd.name] = ipmi.register_ipmi_cmd(self.bus, self.service_name, ipmi_cmd,
        cb or self[ipmi_cmd.name])
end

function iam_service:unregister_ipmi_cmd(ipmi_cmd)
    local cmd_obj = self.ipmi_cmds[ipmi_cmd.name]
    if not cmd_obj then
        return
    end

    cmd_obj:unregister()
    self.ipmi_cmds[ipmi_cmd.name] = nil
end

function iam_service:ctor()
    self.ipmi_cmds = {}
    self.signal_slots = {}
    self.name = self.name or iam_service.package
    self.db = open_db(':memory:', datas)

    orm_classes.init(self.db)
    self.bus:request_name(app_base.Service.get_service_name(self.name))
    model.init(self.bus)
    iam_service.bus = self.bus
end

function iam_service:pre_init()
    iam_service.super.pre_init(self)
    self.persist = persist_client.new(self.bus, self.db, self, {})
    object_manage.set_persist_client(self.persist)
end

function iam_service:init()
    iam_service.super.init(self)
end

return iam_service
