-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local create_enum_type = require 'mc.enum'

local Sessions = {}

---@class Sessions.SessionType: Enum
local ESessionType = create_enum_type('SessionType')
ESessionType.default = ESessionType.new(2147483647)
ESessionType.struct = nil
ESessionType.GUI = ESessionType.new(0)
ESessionType.Redfish = ESessionType.new(1)
ESessionType.CLI = ESessionType.new(2)
ESessionType.SSO = ESessionType.new(3)
ESessionType.KVM = ESessionType.new(4)
ESessionType.VNC = ESessionType.new(5)
ESessionType.KVM_VMM = ESessionType.new(6)
ESessionType.VIDEO = ESessionType.new(7)
ESessionType.ALL = ESessionType.new(255)

Sessions.SessionType = ESessionType

---@class Sessions.OccupationMode: Enum
local EOccupationMode = create_enum_type('OccupationMode')
EOccupationMode.default = EOccupationMode.new(2147483647)
EOccupationMode.struct = nil
EOccupationMode.Shared = EOccupationMode.new(0)
EOccupationMode.Exclusive = EOccupationMode.new(1)

Sessions.OccupationMode = EOccupationMode

---@class Sessions.SsoEnabled
---@field SsoEnabled boolean
local TSsoEnabled = {}
TSsoEnabled.__index = TSsoEnabled
TSsoEnabled.group = {}

local function TSsoEnabled_from_obj(obj)
    return setmetatable(obj, TSsoEnabled)
end

function TSsoEnabled.new(SsoEnabled)
    return TSsoEnabled_from_obj({SsoEnabled = SsoEnabled == nil and true or SsoEnabled})
end
---@param obj Sessions.SsoEnabled
function TSsoEnabled:init_from_obj(obj)
    self.SsoEnabled = obj.SsoEnabled == nil and true or obj.SsoEnabled
end

function TSsoEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSsoEnabled.group)
end

TSsoEnabled.from_obj = TSsoEnabled_from_obj

TSsoEnabled.proto_property = {'SsoEnabled'}

TSsoEnabled.default = {false}

TSsoEnabled.struct = {{name = 'SsoEnabled', is_array = false, struct = nil}}

function TSsoEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SsoEnabled', self.SsoEnabled, 'bool', false, errs, need_convert)

    TSsoEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSsoEnabled.proto_property, errs, need_convert)
    return self
end

function TSsoEnabled:unpack(_)
    return self.SsoEnabled
end

Sessions.SsoEnabled = TSsoEnabled

---@class Sessions.ValidateSsoClient
---@field ValidateSsoClient boolean
local TValidateSsoClient = {}
TValidateSsoClient.__index = TValidateSsoClient
TValidateSsoClient.group = {}

local function TValidateSsoClient_from_obj(obj)
    return setmetatable(obj, TValidateSsoClient)
end

function TValidateSsoClient.new(ValidateSsoClient)
    return TValidateSsoClient_from_obj({ValidateSsoClient = ValidateSsoClient or false})
end
---@param obj Sessions.ValidateSsoClient
function TValidateSsoClient:init_from_obj(obj)
    self.ValidateSsoClient = obj.ValidateSsoClient or false
end

function TValidateSsoClient:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TValidateSsoClient.group)
end

TValidateSsoClient.from_obj = TValidateSsoClient_from_obj

TValidateSsoClient.proto_property = {'ValidateSsoClient'}

TValidateSsoClient.default = {false}

TValidateSsoClient.struct = {{name = 'ValidateSsoClient', is_array = false, struct = nil}}

function TValidateSsoClient:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ValidateSsoClient', self.ValidateSsoClient, 'bool', false, errs, need_convert)

    TValidateSsoClient:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TValidateSsoClient.proto_property, errs, need_convert)
    return self
end

function TValidateSsoClient:unpack(_)
    return self.ValidateSsoClient
end

Sessions.ValidateSsoClient = TValidateSsoClient

---@class Sessions.GetSessionLogoutTypeRsp
---@field LogoutType integer
local TGetSessionLogoutTypeRsp = {}
TGetSessionLogoutTypeRsp.__index = TGetSessionLogoutTypeRsp
TGetSessionLogoutTypeRsp.group = {}

local function TGetSessionLogoutTypeRsp_from_obj(obj)
    return setmetatable(obj, TGetSessionLogoutTypeRsp)
end

function TGetSessionLogoutTypeRsp.new(LogoutType)
    return TGetSessionLogoutTypeRsp_from_obj({LogoutType = LogoutType})
end
---@param obj Sessions.GetSessionLogoutTypeRsp
function TGetSessionLogoutTypeRsp:init_from_obj(obj)
    self.LogoutType = obj.LogoutType
end

function TGetSessionLogoutTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSessionLogoutTypeRsp.group)
end

TGetSessionLogoutTypeRsp.from_obj = TGetSessionLogoutTypeRsp_from_obj

TGetSessionLogoutTypeRsp.proto_property = {'LogoutType'}

TGetSessionLogoutTypeRsp.default = {0}

TGetSessionLogoutTypeRsp.struct = {{name = 'LogoutType', is_array = false, struct = nil}}

function TGetSessionLogoutTypeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogoutType', self.LogoutType, 'uint8', false, errs, need_convert)

    TGetSessionLogoutTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSessionLogoutTypeRsp.proto_property, errs, need_convert)
    return self
end

function TGetSessionLogoutTypeRsp:unpack(_)
    return self.LogoutType
end

Sessions.GetSessionLogoutTypeRsp = TGetSessionLogoutTypeRsp

---@class Sessions.GetSessionLogoutTypeReq
---@field SessionId string
local TGetSessionLogoutTypeReq = {}
TGetSessionLogoutTypeReq.__index = TGetSessionLogoutTypeReq
TGetSessionLogoutTypeReq.group = {}

local function TGetSessionLogoutTypeReq_from_obj(obj)
    return setmetatable(obj, TGetSessionLogoutTypeReq)
end

function TGetSessionLogoutTypeReq.new(SessionId)
    return TGetSessionLogoutTypeReq_from_obj({SessionId = SessionId})
end
---@param obj Sessions.GetSessionLogoutTypeReq
function TGetSessionLogoutTypeReq:init_from_obj(obj)
    self.SessionId = obj.SessionId
end

function TGetSessionLogoutTypeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSessionLogoutTypeReq.group)
end

TGetSessionLogoutTypeReq.from_obj = TGetSessionLogoutTypeReq_from_obj

TGetSessionLogoutTypeReq.proto_property = {'SessionId'}

TGetSessionLogoutTypeReq.default = {''}

TGetSessionLogoutTypeReq.struct = {{name = 'SessionId', is_array = false, struct = nil}}

function TGetSessionLogoutTypeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SessionId', self.SessionId, 'string', false, errs, need_convert)

    TGetSessionLogoutTypeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSessionLogoutTypeReq.proto_property, errs, need_convert)
    return self
end

function TGetSessionLogoutTypeReq:unpack(_)
    return self.SessionId
end

Sessions.GetSessionLogoutTypeReq = TGetSessionLogoutTypeReq

---@class Sessions.ValidateSessionRsp
---@field SessionId string
local TValidateSessionRsp = {}
TValidateSessionRsp.__index = TValidateSessionRsp
TValidateSessionRsp.group = {}

local function TValidateSessionRsp_from_obj(obj)
    return setmetatable(obj, TValidateSessionRsp)
end

function TValidateSessionRsp.new(SessionId)
    return TValidateSessionRsp_from_obj({SessionId = SessionId})
end
---@param obj Sessions.ValidateSessionRsp
function TValidateSessionRsp:init_from_obj(obj)
    self.SessionId = obj.SessionId
end

function TValidateSessionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TValidateSessionRsp.group)
end

TValidateSessionRsp.from_obj = TValidateSessionRsp_from_obj

TValidateSessionRsp.proto_property = {'SessionId'}

TValidateSessionRsp.default = {''}

TValidateSessionRsp.struct = {{name = 'SessionId', is_array = false, struct = nil}}

function TValidateSessionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SessionId', self.SessionId, 'string', false, errs, need_convert)

    TValidateSessionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TValidateSessionRsp.proto_property, errs, need_convert)
    return self
end

function TValidateSessionRsp:unpack(_)
    return self.SessionId
end

Sessions.ValidateSessionRsp = TValidateSessionRsp

---@class Sessions.ValidateSessionReq
---@field SessionType integer
---@field Token string
local TValidateSessionReq = {}
TValidateSessionReq.__index = TValidateSessionReq
TValidateSessionReq.group = {}

local function TValidateSessionReq_from_obj(obj)
    return setmetatable(obj, TValidateSessionReq)
end

function TValidateSessionReq.new(SessionType, Token)
    return TValidateSessionReq_from_obj({SessionType = SessionType, Token = Token})
end
---@param obj Sessions.ValidateSessionReq
function TValidateSessionReq:init_from_obj(obj)
    self.SessionType = obj.SessionType
    self.Token = obj.Token
end

function TValidateSessionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TValidateSessionReq.group)
end

TValidateSessionReq.from_obj = TValidateSessionReq_from_obj

TValidateSessionReq.proto_property = {'SessionType', 'Token'}

TValidateSessionReq.default = {0, ''}

TValidateSessionReq.struct = {
    {name = 'SessionType', is_array = false, struct = nil}, {name = 'Token', is_array = false, struct = nil}
}

function TValidateSessionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SessionType', self.SessionType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Token', self.Token, 'string', false, errs, need_convert)

    TValidateSessionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TValidateSessionReq.proto_property, errs, need_convert)
    return self
end

function TValidateSessionReq:unpack(_)
    return self.SessionType, self.Token
end

Sessions.ValidateSessionReq = TValidateSessionReq

---@class Sessions.ValidateSessionWithCsrfRsp
---@field SessionId string
local TValidateSessionWithCsrfRsp = {}
TValidateSessionWithCsrfRsp.__index = TValidateSessionWithCsrfRsp
TValidateSessionWithCsrfRsp.group = {}

local function TValidateSessionWithCsrfRsp_from_obj(obj)
    return setmetatable(obj, TValidateSessionWithCsrfRsp)
end

function TValidateSessionWithCsrfRsp.new(SessionId)
    return TValidateSessionWithCsrfRsp_from_obj({SessionId = SessionId})
end
---@param obj Sessions.ValidateSessionWithCsrfRsp
function TValidateSessionWithCsrfRsp:init_from_obj(obj)
    self.SessionId = obj.SessionId
end

function TValidateSessionWithCsrfRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TValidateSessionWithCsrfRsp.group)
end

TValidateSessionWithCsrfRsp.from_obj = TValidateSessionWithCsrfRsp_from_obj

TValidateSessionWithCsrfRsp.proto_property = {'SessionId'}

TValidateSessionWithCsrfRsp.default = {''}

TValidateSessionWithCsrfRsp.struct = {{name = 'SessionId', is_array = false, struct = nil}}

function TValidateSessionWithCsrfRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SessionId', self.SessionId, 'string', false, errs, need_convert)

    TValidateSessionWithCsrfRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TValidateSessionWithCsrfRsp.proto_property, errs, need_convert)
    return self
end

function TValidateSessionWithCsrfRsp:unpack(_)
    return self.SessionId
end

Sessions.ValidateSessionWithCsrfRsp = TValidateSessionWithCsrfRsp

---@class Sessions.ValidateSessionWithCsrfReq
---@field SessionType integer
---@field Token string
---@field CsrfToken string
local TValidateSessionWithCsrfReq = {}
TValidateSessionWithCsrfReq.__index = TValidateSessionWithCsrfReq
TValidateSessionWithCsrfReq.group = {}

local function TValidateSessionWithCsrfReq_from_obj(obj)
    return setmetatable(obj, TValidateSessionWithCsrfReq)
end

function TValidateSessionWithCsrfReq.new(SessionType, Token, CsrfToken)
    return TValidateSessionWithCsrfReq_from_obj({SessionType = SessionType, Token = Token, CsrfToken = CsrfToken})
end
---@param obj Sessions.ValidateSessionWithCsrfReq
function TValidateSessionWithCsrfReq:init_from_obj(obj)
    self.SessionType = obj.SessionType
    self.Token = obj.Token
    self.CsrfToken = obj.CsrfToken
end

function TValidateSessionWithCsrfReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TValidateSessionWithCsrfReq.group)
end

TValidateSessionWithCsrfReq.from_obj = TValidateSessionWithCsrfReq_from_obj

TValidateSessionWithCsrfReq.proto_property = {'SessionType', 'Token', 'CsrfToken'}

TValidateSessionWithCsrfReq.default = {0, '', ''}

TValidateSessionWithCsrfReq.struct = {
    {name = 'SessionType', is_array = false, struct = nil}, {name = 'Token', is_array = false, struct = nil},
    {name = 'CsrfToken', is_array = false, struct = nil}
}

function TValidateSessionWithCsrfReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SessionType', self.SessionType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Token', self.Token, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'CsrfToken', self.CsrfToken, 'string', false, errs, need_convert)

    TValidateSessionWithCsrfReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TValidateSessionWithCsrfReq.proto_property, errs, need_convert)
    return self
end

function TValidateSessionWithCsrfReq:unpack(_)
    return self.SessionType, self.Token, self.CsrfToken
end

Sessions.ValidateSessionWithCsrfReq = TValidateSessionWithCsrfReq

---@class Sessions.NewSessionByCertRsp
---@field Token string
---@field CsrfToken string
---@field SessionId string
local TNewSessionByCertRsp = {}
TNewSessionByCertRsp.__index = TNewSessionByCertRsp
TNewSessionByCertRsp.group = {}

local function TNewSessionByCertRsp_from_obj(obj)
    return setmetatable(obj, TNewSessionByCertRsp)
end

function TNewSessionByCertRsp.new(Token, CsrfToken, SessionId)
    return TNewSessionByCertRsp_from_obj({Token = Token, CsrfToken = CsrfToken, SessionId = SessionId})
end
---@param obj Sessions.NewSessionByCertRsp
function TNewSessionByCertRsp:init_from_obj(obj)
    self.Token = obj.Token
    self.CsrfToken = obj.CsrfToken
    self.SessionId = obj.SessionId
end

function TNewSessionByCertRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewSessionByCertRsp.group)
end

TNewSessionByCertRsp.from_obj = TNewSessionByCertRsp_from_obj

TNewSessionByCertRsp.proto_property = {'Token', 'CsrfToken', 'SessionId'}

TNewSessionByCertRsp.default = {'', '', ''}

TNewSessionByCertRsp.struct = {
    {name = 'Token', is_array = false, struct = nil}, {name = 'CsrfToken', is_array = false, struct = nil},
    {name = 'SessionId', is_array = false, struct = nil}
}

function TNewSessionByCertRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Token', self.Token, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'CsrfToken', self.CsrfToken, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionId', self.SessionId, 'string', false, errs, need_convert)

    TNewSessionByCertRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewSessionByCertRsp.proto_property, errs, need_convert)
    return self
end

function TNewSessionByCertRsp:unpack(_)
    return self.Token, self.CsrfToken, self.SessionId
end

Sessions.NewSessionByCertRsp = TNewSessionByCertRsp

---@class Sessions.NewSessionByCertReq
---@field SerialNumber string
---@field Issuer string
---@field Subject string
---@field Ip string
---@field BrowserType integer
local TNewSessionByCertReq = {}
TNewSessionByCertReq.__index = TNewSessionByCertReq
TNewSessionByCertReq.group = {}

local function TNewSessionByCertReq_from_obj(obj)
    return setmetatable(obj, TNewSessionByCertReq)
end

function TNewSessionByCertReq.new(SerialNumber, Issuer, Subject, Ip, BrowserType)
    return TNewSessionByCertReq_from_obj({
        SerialNumber = SerialNumber,
        Issuer = Issuer,
        Subject = Subject,
        Ip = Ip,
        BrowserType = BrowserType
    })
end
---@param obj Sessions.NewSessionByCertReq
function TNewSessionByCertReq:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
    self.Issuer = obj.Issuer
    self.Subject = obj.Subject
    self.Ip = obj.Ip
    self.BrowserType = obj.BrowserType
end

function TNewSessionByCertReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewSessionByCertReq.group)
end

TNewSessionByCertReq.from_obj = TNewSessionByCertReq_from_obj

TNewSessionByCertReq.proto_property = {'SerialNumber', 'Issuer', 'Subject', 'Ip', 'BrowserType'}

TNewSessionByCertReq.default = {'', '', '', '', 0}

TNewSessionByCertReq.struct = {
    {name = 'SerialNumber', is_array = false, struct = nil}, {name = 'Issuer', is_array = false, struct = nil},
    {name = 'Subject', is_array = false, struct = nil}, {name = 'Ip', is_array = false, struct = nil},
    {name = 'BrowserType', is_array = false, struct = nil}
}

function TNewSessionByCertReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Issuer', self.Issuer, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Subject', self.Subject, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Ip', self.Ip, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'BrowserType', self.BrowserType, 'uint8', false, errs, need_convert)

    TNewSessionByCertReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewSessionByCertReq.proto_property, errs, need_convert)
    return self
end

function TNewSessionByCertReq:unpack(_)
    return self.SerialNumber, self.Issuer, self.Subject, self.Ip, self.BrowserType
end

Sessions.NewSessionByCertReq = TNewSessionByCertReq

---@class Sessions.DeleteAllSessionsRsp
local TDeleteAllSessionsRsp = {}
TDeleteAllSessionsRsp.__index = TDeleteAllSessionsRsp
TDeleteAllSessionsRsp.group = {}

local function TDeleteAllSessionsRsp_from_obj(obj)
    return setmetatable(obj, TDeleteAllSessionsRsp)
end

function TDeleteAllSessionsRsp.new()
    return TDeleteAllSessionsRsp_from_obj({})
end
---@param obj Sessions.DeleteAllSessionsRsp
function TDeleteAllSessionsRsp:init_from_obj(obj)

end

function TDeleteAllSessionsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteAllSessionsRsp.group)
end

TDeleteAllSessionsRsp.from_obj = TDeleteAllSessionsRsp_from_obj

TDeleteAllSessionsRsp.proto_property = {}

TDeleteAllSessionsRsp.default = {}

TDeleteAllSessionsRsp.struct = {}

function TDeleteAllSessionsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDeleteAllSessionsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteAllSessionsRsp.proto_property, errs, need_convert)
    return self
end

function TDeleteAllSessionsRsp:unpack(_)
end

Sessions.DeleteAllSessionsRsp = TDeleteAllSessionsRsp

---@class Sessions.DeleteAllSessionsReq
---@field SessionType integer
---@field SessionLogoutType integer
local TDeleteAllSessionsReq = {}
TDeleteAllSessionsReq.__index = TDeleteAllSessionsReq
TDeleteAllSessionsReq.group = {}

local function TDeleteAllSessionsReq_from_obj(obj)
    return setmetatable(obj, TDeleteAllSessionsReq)
end

function TDeleteAllSessionsReq.new(SessionType, SessionLogoutType)
    return TDeleteAllSessionsReq_from_obj({SessionType = SessionType, SessionLogoutType = SessionLogoutType})
end
---@param obj Sessions.DeleteAllSessionsReq
function TDeleteAllSessionsReq:init_from_obj(obj)
    self.SessionType = obj.SessionType
    self.SessionLogoutType = obj.SessionLogoutType
end

function TDeleteAllSessionsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteAllSessionsReq.group)
end

TDeleteAllSessionsReq.from_obj = TDeleteAllSessionsReq_from_obj

TDeleteAllSessionsReq.proto_property = {'SessionType', 'SessionLogoutType'}

TDeleteAllSessionsReq.default = {0, 0}

TDeleteAllSessionsReq.struct = {
    {name = 'SessionType', is_array = false, struct = nil}, {name = 'SessionLogoutType', is_array = false, struct = nil}
}

function TDeleteAllSessionsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SessionType', self.SessionType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionLogoutType', self.SessionLogoutType, 'uint8', false, errs, need_convert)

    TDeleteAllSessionsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteAllSessionsReq.proto_property, errs, need_convert)
    return self
end

function TDeleteAllSessionsReq:unpack(_)
    return self.SessionType, self.SessionLogoutType
end

Sessions.DeleteAllSessionsReq = TDeleteAllSessionsReq

---@class Sessions.SetKvmKeyRsp
local TSetKvmKeyRsp = {}
TSetKvmKeyRsp.__index = TSetKvmKeyRsp
TSetKvmKeyRsp.group = {}

local function TSetKvmKeyRsp_from_obj(obj)
    return setmetatable(obj, TSetKvmKeyRsp)
end

function TSetKvmKeyRsp.new()
    return TSetKvmKeyRsp_from_obj({})
end
---@param obj Sessions.SetKvmKeyRsp
function TSetKvmKeyRsp:init_from_obj(obj)

end

function TSetKvmKeyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetKvmKeyRsp.group)
end

TSetKvmKeyRsp.from_obj = TSetKvmKeyRsp_from_obj

TSetKvmKeyRsp.proto_property = {}

TSetKvmKeyRsp.default = {}

TSetKvmKeyRsp.struct = {}

function TSetKvmKeyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetKvmKeyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetKvmKeyRsp.proto_property, errs, need_convert)
    return self
end

function TSetKvmKeyRsp:unpack(_)
end

Sessions.SetKvmKeyRsp = TSetKvmKeyRsp

---@class Sessions.SetKvmKeyReq
---@field SecretKey string
---@field SessionMode integer
local TSetKvmKeyReq = {}
TSetKvmKeyReq.__index = TSetKvmKeyReq
TSetKvmKeyReq.group = {}

local function TSetKvmKeyReq_from_obj(obj)
    return setmetatable(obj, TSetKvmKeyReq)
end

function TSetKvmKeyReq.new(SecretKey, SessionMode)
    return TSetKvmKeyReq_from_obj({SecretKey = SecretKey, SessionMode = SessionMode})
end
---@param obj Sessions.SetKvmKeyReq
function TSetKvmKeyReq:init_from_obj(obj)
    self.SecretKey = obj.SecretKey
    self.SessionMode = obj.SessionMode
end

function TSetKvmKeyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetKvmKeyReq.group)
end

TSetKvmKeyReq.from_obj = TSetKvmKeyReq_from_obj

TSetKvmKeyReq.proto_property = {'SecretKey', 'SessionMode'}

TSetKvmKeyReq.default = {'', 0}

TSetKvmKeyReq.struct = {
    {name = 'SecretKey', is_array = false, struct = nil}, {name = 'SessionMode', is_array = false, struct = nil}
}

function TSetKvmKeyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SecretKey', self.SecretKey, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionMode', self.SessionMode, 'uint8', false, errs, need_convert)

    TSetKvmKeyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetKvmKeyReq.proto_property, errs, need_convert)
    return self
end

function TSetKvmKeyReq:unpack(_)
    return self.SecretKey, self.SessionMode
end

Sessions.SetKvmKeyReq = TSetKvmKeyReq

---@class Sessions.NewSessionBySSORsp
---@field Token string
---@field CsrfToken string
---@field SessionId string
local TNewSessionBySSORsp = {}
TNewSessionBySSORsp.__index = TNewSessionBySSORsp
TNewSessionBySSORsp.group = {}

local function TNewSessionBySSORsp_from_obj(obj)
    return setmetatable(obj, TNewSessionBySSORsp)
end

function TNewSessionBySSORsp.new(Token, CsrfToken, SessionId)
    return TNewSessionBySSORsp_from_obj({Token = Token, CsrfToken = CsrfToken, SessionId = SessionId})
end
---@param obj Sessions.NewSessionBySSORsp
function TNewSessionBySSORsp:init_from_obj(obj)
    self.Token = obj.Token
    self.CsrfToken = obj.CsrfToken
    self.SessionId = obj.SessionId
end

function TNewSessionBySSORsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewSessionBySSORsp.group)
end

TNewSessionBySSORsp.from_obj = TNewSessionBySSORsp_from_obj

TNewSessionBySSORsp.proto_property = {'Token', 'CsrfToken', 'SessionId'}

TNewSessionBySSORsp.default = {'', '', ''}

TNewSessionBySSORsp.struct = {
    {name = 'Token', is_array = false, struct = nil}, {name = 'CsrfToken', is_array = false, struct = nil},
    {name = 'SessionId', is_array = false, struct = nil}
}

function TNewSessionBySSORsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Token', self.Token, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'CsrfToken', self.CsrfToken, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionId', self.SessionId, 'string', false, errs, need_convert)

    TNewSessionBySSORsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewSessionBySSORsp.proto_property, errs, need_convert)
    return self
end

function TNewSessionBySSORsp:unpack(_)
    return self.Token, self.CsrfToken, self.SessionId
end

Sessions.NewSessionBySSORsp = TNewSessionBySSORsp

---@class Sessions.NewSessionBySSOReq
---@field Token string
---@field SessionType integer
---@field SessionMode integer
local TNewSessionBySSOReq = {}
TNewSessionBySSOReq.__index = TNewSessionBySSOReq
TNewSessionBySSOReq.group = {}

local function TNewSessionBySSOReq_from_obj(obj)
    return setmetatable(obj, TNewSessionBySSOReq)
end

function TNewSessionBySSOReq.new(Token, SessionType, SessionMode)
    return TNewSessionBySSOReq_from_obj({Token = Token, SessionType = SessionType, SessionMode = SessionMode})
end
---@param obj Sessions.NewSessionBySSOReq
function TNewSessionBySSOReq:init_from_obj(obj)
    self.Token = obj.Token
    self.SessionType = obj.SessionType
    self.SessionMode = obj.SessionMode
end

function TNewSessionBySSOReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewSessionBySSOReq.group)
end

TNewSessionBySSOReq.from_obj = TNewSessionBySSOReq_from_obj

TNewSessionBySSOReq.proto_property = {'Token', 'SessionType', 'SessionMode'}

TNewSessionBySSOReq.default = {'', 0, 0}

TNewSessionBySSOReq.struct = {
    {name = 'Token', is_array = false, struct = nil}, {name = 'SessionType', is_array = false, struct = nil},
    {name = 'SessionMode', is_array = false, struct = nil}
}

function TNewSessionBySSOReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Token', self.Token, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionType', self.SessionType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionMode', self.SessionMode, 'uint8', false, errs, need_convert)

    TNewSessionBySSOReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewSessionBySSOReq.proto_property, errs, need_convert)
    return self
end

function TNewSessionBySSOReq:unpack(_)
    return self.Token, self.SessionType, self.SessionMode
end

Sessions.NewSessionBySSOReq = TNewSessionBySSOReq

---@class Sessions.GetCLISessionListReq
local TGetCLISessionListReq = {}
TGetCLISessionListReq.__index = TGetCLISessionListReq
TGetCLISessionListReq.group = {}

local function TGetCLISessionListReq_from_obj(obj)
    return setmetatable(obj, TGetCLISessionListReq)
end

function TGetCLISessionListReq.new()
    return TGetCLISessionListReq_from_obj({})
end
---@param obj Sessions.GetCLISessionListReq
function TGetCLISessionListReq:init_from_obj(obj)

end

function TGetCLISessionListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCLISessionListReq.group)
end

TGetCLISessionListReq.from_obj = TGetCLISessionListReq_from_obj

TGetCLISessionListReq.proto_property = {}

TGetCLISessionListReq.default = {}

TGetCLISessionListReq.struct = {}

function TGetCLISessionListReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetCLISessionListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCLISessionListReq.proto_property, errs, need_convert)
    return self
end

function TGetCLISessionListReq:unpack(_)
end

Sessions.GetCLISessionListReq = TGetCLISessionListReq

---@class Sessions.SessionHeartBeatRsp
local TSessionHeartBeatRsp = {}
TSessionHeartBeatRsp.__index = TSessionHeartBeatRsp
TSessionHeartBeatRsp.group = {}

local function TSessionHeartBeatRsp_from_obj(obj)
    return setmetatable(obj, TSessionHeartBeatRsp)
end

function TSessionHeartBeatRsp.new()
    return TSessionHeartBeatRsp_from_obj({})
end
---@param obj Sessions.SessionHeartBeatRsp
function TSessionHeartBeatRsp:init_from_obj(obj)

end

function TSessionHeartBeatRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSessionHeartBeatRsp.group)
end

TSessionHeartBeatRsp.from_obj = TSessionHeartBeatRsp_from_obj

TSessionHeartBeatRsp.proto_property = {}

TSessionHeartBeatRsp.default = {}

TSessionHeartBeatRsp.struct = {}

function TSessionHeartBeatRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSessionHeartBeatRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSessionHeartBeatRsp.proto_property, errs, need_convert)
    return self
end

function TSessionHeartBeatRsp:unpack(_)
end

Sessions.SessionHeartBeatRsp = TSessionHeartBeatRsp

---@class Sessions.SessionHeartBeatReq
---@field SessionId string
---@field RemainActiveSeconds integer
local TSessionHeartBeatReq = {}
TSessionHeartBeatReq.__index = TSessionHeartBeatReq
TSessionHeartBeatReq.group = {}

local function TSessionHeartBeatReq_from_obj(obj)
    return setmetatable(obj, TSessionHeartBeatReq)
end

function TSessionHeartBeatReq.new(SessionId, RemainActiveSeconds)
    return TSessionHeartBeatReq_from_obj({SessionId = SessionId, RemainActiveSeconds = RemainActiveSeconds})
end
---@param obj Sessions.SessionHeartBeatReq
function TSessionHeartBeatReq:init_from_obj(obj)
    self.SessionId = obj.SessionId
    self.RemainActiveSeconds = obj.RemainActiveSeconds
end

function TSessionHeartBeatReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSessionHeartBeatReq.group)
end

TSessionHeartBeatReq.from_obj = TSessionHeartBeatReq_from_obj

TSessionHeartBeatReq.proto_property = {'SessionId', 'RemainActiveSeconds'}

TSessionHeartBeatReq.default = {'', 0}

TSessionHeartBeatReq.struct = {
    {name = 'SessionId', is_array = false, struct = nil}, {name = 'RemainActiveSeconds', is_array = false, struct = nil}
}

function TSessionHeartBeatReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SessionId', self.SessionId, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'RemainActiveSeconds', self.RemainActiveSeconds, 'uint8', false, errs, need_convert)

    TSessionHeartBeatReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSessionHeartBeatReq.proto_property, errs, need_convert)
    return self
end

function TSessionHeartBeatReq:unpack(_)
    return self.SessionId, self.RemainActiveSeconds
end

Sessions.SessionHeartBeatReq = TSessionHeartBeatReq

---@class Sessions.NewVNCSessionRsp
---@field VNCSessionId string
local TNewVNCSessionRsp = {}
TNewVNCSessionRsp.__index = TNewVNCSessionRsp
TNewVNCSessionRsp.group = {}

local function TNewVNCSessionRsp_from_obj(obj)
    return setmetatable(obj, TNewVNCSessionRsp)
end

function TNewVNCSessionRsp.new(VNCSessionId)
    return TNewVNCSessionRsp_from_obj({VNCSessionId = VNCSessionId})
end
---@param obj Sessions.NewVNCSessionRsp
function TNewVNCSessionRsp:init_from_obj(obj)
    self.VNCSessionId = obj.VNCSessionId
end

function TNewVNCSessionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewVNCSessionRsp.group)
end

TNewVNCSessionRsp.from_obj = TNewVNCSessionRsp_from_obj

TNewVNCSessionRsp.proto_property = {'VNCSessionId'}

TNewVNCSessionRsp.default = {''}

TNewVNCSessionRsp.struct = {{name = 'VNCSessionId', is_array = false, struct = nil}}

function TNewVNCSessionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VNCSessionId', self.VNCSessionId, 'string', false, errs, need_convert)

    TNewVNCSessionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewVNCSessionRsp.proto_property, errs, need_convert)
    return self
end

function TNewVNCSessionRsp:unpack(_)
    return self.VNCSessionId
end

Sessions.NewVNCSessionRsp = TNewVNCSessionRsp

---@class Sessions.NewVNCSessionReq
---@field CipherText string
---@field AuthChallenge string
---@field SessionMode integer
local TNewVNCSessionReq = {}
TNewVNCSessionReq.__index = TNewVNCSessionReq
TNewVNCSessionReq.group = {}

local function TNewVNCSessionReq_from_obj(obj)
    return setmetatable(obj, TNewVNCSessionReq)
end

function TNewVNCSessionReq.new(CipherText, AuthChallenge, SessionMode)
    return TNewVNCSessionReq_from_obj({
        CipherText = CipherText,
        AuthChallenge = AuthChallenge,
        SessionMode = SessionMode
    })
end
---@param obj Sessions.NewVNCSessionReq
function TNewVNCSessionReq:init_from_obj(obj)
    self.CipherText = obj.CipherText
    self.AuthChallenge = obj.AuthChallenge
    self.SessionMode = obj.SessionMode
end

function TNewVNCSessionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewVNCSessionReq.group)
end

TNewVNCSessionReq.from_obj = TNewVNCSessionReq_from_obj

TNewVNCSessionReq.proto_property = {'CipherText', 'AuthChallenge', 'SessionMode'}

TNewVNCSessionReq.default = {'', '', 0}

TNewVNCSessionReq.struct = {
    {name = 'CipherText', is_array = false, struct = nil}, {name = 'AuthChallenge', is_array = false, struct = nil},
    {name = 'SessionMode', is_array = false, struct = nil}
}

function TNewVNCSessionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CipherText', self.CipherText, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'AuthChallenge', self.AuthChallenge, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionMode', self.SessionMode, 'uint8', false, errs, need_convert)

    TNewVNCSessionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewVNCSessionReq.proto_property, errs, need_convert)
    return self
end

function TNewVNCSessionReq:unpack(_)
    return self.CipherText, self.AuthChallenge, self.SessionMode
end

Sessions.NewVNCSessionReq = TNewVNCSessionReq

---@class Sessions.NewRemoteConsoleSessionRsp
---@field RemoteConsoleToken string
---@field RemoteConsoleSessionId string
local TNewRemoteConsoleSessionRsp = {}
TNewRemoteConsoleSessionRsp.__index = TNewRemoteConsoleSessionRsp
TNewRemoteConsoleSessionRsp.group = {}

local function TNewRemoteConsoleSessionRsp_from_obj(obj)
    return setmetatable(obj, TNewRemoteConsoleSessionRsp)
end

function TNewRemoteConsoleSessionRsp.new(RemoteConsoleToken, RemoteConsoleSessionId)
    return TNewRemoteConsoleSessionRsp_from_obj({
        RemoteConsoleToken = RemoteConsoleToken,
        RemoteConsoleSessionId = RemoteConsoleSessionId
    })
end
---@param obj Sessions.NewRemoteConsoleSessionRsp
function TNewRemoteConsoleSessionRsp:init_from_obj(obj)
    self.RemoteConsoleToken = obj.RemoteConsoleToken
    self.RemoteConsoleSessionId = obj.RemoteConsoleSessionId
end

function TNewRemoteConsoleSessionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewRemoteConsoleSessionRsp.group)
end

TNewRemoteConsoleSessionRsp.from_obj = TNewRemoteConsoleSessionRsp_from_obj

TNewRemoteConsoleSessionRsp.proto_property = {'RemoteConsoleToken', 'RemoteConsoleSessionId'}

TNewRemoteConsoleSessionRsp.default = {'', ''}

TNewRemoteConsoleSessionRsp.struct = {
    {name = 'RemoteConsoleToken', is_array = false, struct = nil},
    {name = 'RemoteConsoleSessionId', is_array = false, struct = nil}
}

function TNewRemoteConsoleSessionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RemoteConsoleToken', self.RemoteConsoleToken, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'RemoteConsoleSessionId', self.RemoteConsoleSessionId, 'string', false, errs,
        need_convert)

    TNewRemoteConsoleSessionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewRemoteConsoleSessionRsp.proto_property, errs, need_convert)
    return self
end

function TNewRemoteConsoleSessionRsp:unpack(_)
    return self.RemoteConsoleToken, self.RemoteConsoleSessionId
end

Sessions.NewRemoteConsoleSessionRsp = TNewRemoteConsoleSessionRsp

---@class Sessions.NewRemoteConsoleSessionReq
---@field Token string
---@field SessionType integer
---@field SessionMode integer
local TNewRemoteConsoleSessionReq = {}
TNewRemoteConsoleSessionReq.__index = TNewRemoteConsoleSessionReq
TNewRemoteConsoleSessionReq.group = {}

local function TNewRemoteConsoleSessionReq_from_obj(obj)
    return setmetatable(obj, TNewRemoteConsoleSessionReq)
end

function TNewRemoteConsoleSessionReq.new(Token, SessionType, SessionMode)
    return TNewRemoteConsoleSessionReq_from_obj({Token = Token, SessionType = SessionType, SessionMode = SessionMode})
end
---@param obj Sessions.NewRemoteConsoleSessionReq
function TNewRemoteConsoleSessionReq:init_from_obj(obj)
    self.Token = obj.Token
    self.SessionType = obj.SessionType
    self.SessionMode = obj.SessionMode
end

function TNewRemoteConsoleSessionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewRemoteConsoleSessionReq.group)
end

TNewRemoteConsoleSessionReq.from_obj = TNewRemoteConsoleSessionReq_from_obj

TNewRemoteConsoleSessionReq.proto_property = {'Token', 'SessionType', 'SessionMode'}

TNewRemoteConsoleSessionReq.default = {'', 0, 0}

TNewRemoteConsoleSessionReq.struct = {
    {name = 'Token', is_array = false, struct = nil}, {name = 'SessionType', is_array = false, struct = nil},
    {name = 'SessionMode', is_array = false, struct = nil}
}

function TNewRemoteConsoleSessionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Token', self.Token, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionType', self.SessionType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionMode', self.SessionMode, 'uint8', false, errs, need_convert)

    TNewRemoteConsoleSessionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewRemoteConsoleSessionReq.proto_property, errs, need_convert)
    return self
end

function TNewRemoteConsoleSessionReq:unpack(_)
    return self.Token, self.SessionType, self.SessionMode
end

Sessions.NewRemoteConsoleSessionReq = TNewRemoteConsoleSessionReq

---@class Sessions.NewSessionRsp
---@field Token string
---@field CsrfToken string
---@field SessionId string
local TNewSessionRsp = {}
TNewSessionRsp.__index = TNewSessionRsp
TNewSessionRsp.group = {}

local function TNewSessionRsp_from_obj(obj)
    return setmetatable(obj, TNewSessionRsp)
end

function TNewSessionRsp.new(Token, CsrfToken, SessionId)
    return TNewSessionRsp_from_obj({Token = Token, CsrfToken = CsrfToken, SessionId = SessionId})
end
---@param obj Sessions.NewSessionRsp
function TNewSessionRsp:init_from_obj(obj)
    self.Token = obj.Token
    self.CsrfToken = obj.CsrfToken
    self.SessionId = obj.SessionId
end

function TNewSessionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewSessionRsp.group)
end

TNewSessionRsp.from_obj = TNewSessionRsp_from_obj

TNewSessionRsp.proto_property = {'Token', 'CsrfToken', 'SessionId'}

TNewSessionRsp.default = {'', '', ''}

TNewSessionRsp.struct = {
    {name = 'Token', is_array = false, struct = nil}, {name = 'CsrfToken', is_array = false, struct = nil},
    {name = 'SessionId', is_array = false, struct = nil}
}

function TNewSessionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Token', self.Token, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'CsrfToken', self.CsrfToken, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionId', self.SessionId, 'string', false, errs, need_convert)

    TNewSessionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewSessionRsp.proto_property, errs, need_convert)
    return self
end

function TNewSessionRsp:unpack(_)
    return self.Token, self.CsrfToken, self.SessionId
end

Sessions.NewSessionRsp = TNewSessionRsp

---@class Sessions.ExtraDataDict
---@field key string
---@field value string
local TExtraDataDict = {}
TExtraDataDict.__index = TExtraDataDict
TExtraDataDict.group = {}

local function TExtraDataDict_from_obj(obj)
    return setmetatable(obj, TExtraDataDict)
end

function TExtraDataDict.new(dict)
    return TExtraDataDict_from_obj(dict)
end

---@param obj Sessions.ExtraDataDict
function TExtraDataDict:init_from_obj(obj)
    self = obj
end

function TExtraDataDict:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExtraDataDict.group)
end

TExtraDataDict.from_obj = TExtraDataDict_from_obj

TExtraDataDict.proto_property = {}

TExtraDataDict.default = {}

TExtraDataDict.struct = {}

function TExtraDataDict:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TExtraDataDict:remove_error_props(errs, self)
    return self
end

function TExtraDataDict:unpack(_)
    return self
end

Sessions.ExtraDataDict = TExtraDataDict

---@class Sessions.NewSessionReq
---@field UserName string
---@field Password integer[]
---@field SessionType integer
---@field Domain string
---@field Ip string
---@field ExtraData Sessions.ExtraDataDict
local TNewSessionReq = {}
TNewSessionReq.__index = TNewSessionReq
TNewSessionReq.group = {}

local function TNewSessionReq_from_obj(obj)
    return setmetatable(obj, TNewSessionReq)
end

function TNewSessionReq.new(UserName, Password, SessionType, Domain, Ip, ExtraData)
    return TNewSessionReq_from_obj({
        UserName = UserName,
        Password = Password,
        SessionType = SessionType,
        Domain = Domain,
        Ip = Ip,
        ExtraData = ExtraData
    })
end
---@param obj Sessions.NewSessionReq
function TNewSessionReq:init_from_obj(obj)
    self.UserName = obj.UserName
    self.Password = obj.Password
    self.SessionType = obj.SessionType
    self.Domain = obj.Domain
    self.Ip = obj.Ip
    self.ExtraData = obj.ExtraData
end

function TNewSessionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewSessionReq.group)
end

TNewSessionReq.from_obj = TNewSessionReq_from_obj

TNewSessionReq.proto_property = {'UserName', 'Password', 'SessionType', 'Domain', 'Ip', 'ExtraData'}

TNewSessionReq.default = {'', {}, 0, '', '', Sessions.ExtraDataDict.default}

TNewSessionReq.struct = {
    {name = 'UserName', is_array = false, struct = nil}, {name = 'Password', is_array = true, struct = nil},
    {name = 'SessionType', is_array = false, struct = nil}, {name = 'Domain', is_array = false, struct = nil},
    {name = 'Ip', is_array = false, struct = nil},
    {name = 'ExtraData', is_array = false, struct = Sessions.ExtraDataDict.struct}
}

function TNewSessionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    Sessions.ExtraDataDict.new(self.ExtraData):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'UserName', self.UserName, 'string', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Password', self.Password, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionType', self.SessionType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Domain', self.Domain, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Ip', self.Ip, 'string', false, errs, need_convert)

    if self.UserName ~= nil then
        validate.lens(prefix .. 'UserName', self.UserName, 1, 32, errs, need_convert)
    end
    if self.Password ~= nil then
        validate.lens(prefix .. 'Password', self.Password, 1, 512, errs, need_convert)
    end

    TNewSessionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewSessionReq.proto_property, errs, need_convert)
    return self
end

function TNewSessionReq:unpack(_)
    return self.UserName, self.Password, self.SessionType, self.Domain, self.Ip, self.ExtraData
end

Sessions.NewSessionReq = TNewSessionReq

---@class Sessions.CLISession
---@field SessionId string
---@field Username string
---@field Ip string
---@field LoginTimeStr string
---@field Privilege string[]
---@field SessionType string
local TCLISession = {}
TCLISession.__index = TCLISession
TCLISession.group = {}

local function TCLISession_from_obj(obj)
    return setmetatable(obj, TCLISession)
end

function TCLISession.new(SessionId, Username, Ip, LoginTimeStr, Privilege, SessionType)
    return TCLISession_from_obj({
        SessionId = SessionId,
        Username = Username,
        Ip = Ip,
        LoginTimeStr = LoginTimeStr,
        Privilege = Privilege,
        SessionType = SessionType
    })
end
---@param obj Sessions.CLISession
function TCLISession:init_from_obj(obj)
    self.SessionId = obj.SessionId
    self.Username = obj.Username
    self.Ip = obj.Ip
    self.LoginTimeStr = obj.LoginTimeStr
    self.Privilege = obj.Privilege
    self.SessionType = obj.SessionType
end

function TCLISession:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCLISession.group)
end

TCLISession.from_obj = TCLISession_from_obj

TCLISession.proto_property = {'SessionId', 'Username', 'Ip', 'LoginTimeStr', 'Privilege', 'SessionType'}

TCLISession.default = {'', '', '', '', {}, ''}

TCLISession.struct = {
    {name = 'SessionId', is_array = false, struct = nil}, {name = 'Username', is_array = false, struct = nil},
    {name = 'Ip', is_array = false, struct = nil}, {name = 'LoginTimeStr', is_array = false, struct = nil},
    {name = 'Privilege', is_array = true, struct = nil}, {name = 'SessionType', is_array = false, struct = nil}
}

function TCLISession:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SessionId', self.SessionId, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Username', self.Username, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Ip', self.Ip, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'LoginTimeStr', self.LoginTimeStr, 'string', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Privilege', self.Privilege, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionType', self.SessionType, 'string', false, errs, need_convert)

    TCLISession:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCLISession.proto_property, errs, need_convert)
    return self
end

function TCLISession:unpack(_)
    return self.SessionId, self.Username, self.Ip, self.LoginTimeStr, self.Privilege, self.SessionType
end

Sessions.CLISession = TCLISession

---@class Sessions.GetCLISessionListRsp
---@field CLISessions Sessions.CLISession[]
local TGetCLISessionListRsp = {}
TGetCLISessionListRsp.__index = TGetCLISessionListRsp
TGetCLISessionListRsp.group = {}

local function TGetCLISessionListRsp_from_obj(obj)
    obj.CLISessions = utils.from_obj(Sessions.CLISession, obj.CLISessions, true)
    return setmetatable(obj, TGetCLISessionListRsp)
end

function TGetCLISessionListRsp.new(CLISessions)
    return TGetCLISessionListRsp_from_obj({CLISessions = CLISessions})
end
---@param obj Sessions.GetCLISessionListRsp
function TGetCLISessionListRsp:init_from_obj(obj)
    self.CLISessions = obj.CLISessions
end

function TGetCLISessionListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCLISessionListRsp.group)
end

TGetCLISessionListRsp.from_obj = TGetCLISessionListRsp_from_obj

TGetCLISessionListRsp.proto_property = {'CLISessions'}

TGetCLISessionListRsp.default = {{}}

TGetCLISessionListRsp.struct = {{name = 'CLISessions', is_array = true, struct = Sessions.CLISession.struct}}

function TGetCLISessionListRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.CLISessions) do
        Sessions.CLISession.new(v.SessionId, v.Username, v.Ip, v.LoginTimeStr, v.Privilege, v.SessionType):validate(
            prefix, errs, need_convert)
    end

    TGetCLISessionListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCLISessionListRsp.proto_property, errs, need_convert)
    return self
end

function TGetCLISessionListRsp:unpack(raw)
    return utils.unpack(raw, self.CLISessions, true)
end

Sessions.GetCLISessionListRsp = TGetCLISessionListRsp

Sessions.interface = mdb.register_interface('bmc.kepler.SessionService.Sessions', {
    ValidateSsoClient = {'b', nil, false, false, false},
    SsoEnabled = {'b', {'EMIT_CHANGE'}, false, true, false}
}, {
    NewSession = {'a{ss}sayyssa{ss}', 'sss', TNewSessionReq, TNewSessionRsp},
    NewRemoteConsoleSession = {'a{ss}syy', 'ss', TNewRemoteConsoleSessionReq, TNewRemoteConsoleSessionRsp},
    NewVNCSession = {'a{ss}ssy', 's', TNewVNCSessionReq, TNewVNCSessionRsp},
    SessionHeartBeat = {'a{ss}sy', '', TSessionHeartBeatReq, TSessionHeartBeatRsp},
    GetCLISessionList = {'a{ss}', 'a(ssssass)', TGetCLISessionListReq, TGetCLISessionListRsp},
    NewSessionBySSO = {'a{ss}syy', 'sss', TNewSessionBySSOReq, TNewSessionBySSORsp},
    SetKvmKey = {'a{ss}sy', '', TSetKvmKeyReq, TSetKvmKeyRsp},
    DeleteAllSessions = {'a{ss}yy', '', TDeleteAllSessionsReq, TDeleteAllSessionsRsp},
    NewSessionByCert = {'a{ss}ssssy', 'sss', TNewSessionByCertReq, TNewSessionByCertRsp},
    ValidateSessionWithCsrf = {'a{ss}yss', 's', TValidateSessionWithCsrfReq, TValidateSessionWithCsrfRsp},
    ValidateSession = {'a{ss}ys', 's', TValidateSessionReq, TValidateSessionRsp},
    GetSessionLogoutType = {'a{ss}s', 'y', TGetSessionLogoutTypeReq, TGetSessionLogoutTypeRsp}
}, {})

return Sessions
