-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local LDAPController = {}

---@class LDAPController.CertVerifyLevel
---@field CertVerifyLevel integer
local TCertVerifyLevel = {}
TCertVerifyLevel.__index = TCertVerifyLevel
TCertVerifyLevel.group = {}

local function TCertVerifyLevel_from_obj(obj)
    return setmetatable(obj, TCertVerifyLevel)
end

function TCertVerifyLevel.new(CertVerifyLevel)
    return TCertVerifyLevel_from_obj({CertVerifyLevel = CertVerifyLevel or 2})
end
---@param obj LDAPController.CertVerifyLevel
function TCertVerifyLevel:init_from_obj(obj)
    self.CertVerifyLevel = obj.CertVerifyLevel or 2
end

function TCertVerifyLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCertVerifyLevel.group)
end

TCertVerifyLevel.from_obj = TCertVerifyLevel_from_obj

TCertVerifyLevel.proto_property = {'CertVerifyLevel'}

TCertVerifyLevel.default = {0}

TCertVerifyLevel.struct = {{name = 'CertVerifyLevel', is_array = false, struct = nil}}

function TCertVerifyLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CertVerifyLevel', self.CertVerifyLevel, 'uint8', false, errs, need_convert)

    TCertVerifyLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCertVerifyLevel.proto_property, errs, need_convert)
    return self
end

function TCertVerifyLevel:unpack(_)
    return self.CertVerifyLevel
end

LDAPController.CertVerifyLevel = TCertVerifyLevel

---@class LDAPController.CertVerifyEnabled
---@field CertVerifyEnabled boolean
local TCertVerifyEnabled = {}
TCertVerifyEnabled.__index = TCertVerifyEnabled
TCertVerifyEnabled.group = {}

local function TCertVerifyEnabled_from_obj(obj)
    return setmetatable(obj, TCertVerifyEnabled)
end

function TCertVerifyEnabled.new(CertVerifyEnabled)
    return TCertVerifyEnabled_from_obj({CertVerifyEnabled = CertVerifyEnabled == nil and true or CertVerifyEnabled})
end
---@param obj LDAPController.CertVerifyEnabled
function TCertVerifyEnabled:init_from_obj(obj)
    self.CertVerifyEnabled = obj.CertVerifyEnabled == nil and true or obj.CertVerifyEnabled
end

function TCertVerifyEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCertVerifyEnabled.group)
end

TCertVerifyEnabled.from_obj = TCertVerifyEnabled_from_obj

TCertVerifyEnabled.proto_property = {'CertVerifyEnabled'}

TCertVerifyEnabled.default = {false}

TCertVerifyEnabled.struct = {{name = 'CertVerifyEnabled', is_array = false, struct = nil}}

function TCertVerifyEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CertVerifyEnabled', self.CertVerifyEnabled, 'bool', false, errs, need_convert)

    TCertVerifyEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCertVerifyEnabled.proto_property, errs, need_convert)
    return self
end

function TCertVerifyEnabled:unpack(_)
    return self.CertVerifyEnabled
end

LDAPController.CertVerifyEnabled = TCertVerifyEnabled

---@class LDAPController.BindDN
---@field BindDN string
local TBindDN = {}
TBindDN.__index = TBindDN
TBindDN.group = {}

local function TBindDN_from_obj(obj)
    return setmetatable(obj, TBindDN)
end

function TBindDN.new(BindDN)
    return TBindDN_from_obj({BindDN = BindDN})
end
---@param obj LDAPController.BindDN
function TBindDN:init_from_obj(obj)
    self.BindDN = obj.BindDN
end

function TBindDN:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBindDN.group)
end

TBindDN.from_obj = TBindDN_from_obj

TBindDN.proto_property = {'BindDN'}

TBindDN.default = {''}

TBindDN.struct = {{name = 'BindDN', is_array = false, struct = nil}}

function TBindDN:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'BindDN', self.BindDN, 'string', false, errs, need_convert)

    TBindDN:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBindDN.proto_property, errs, need_convert)
    return self
end

function TBindDN:unpack(_)
    return self.BindDN
end

LDAPController.BindDN = TBindDN

---@class LDAPController.Folder
---@field Folder string
local TFolder = {}
TFolder.__index = TFolder
TFolder.group = {}

local function TFolder_from_obj(obj)
    return setmetatable(obj, TFolder)
end

function TFolder.new(Folder)
    return TFolder_from_obj({Folder = Folder})
end
---@param obj LDAPController.Folder
function TFolder:init_from_obj(obj)
    self.Folder = obj.Folder
end

function TFolder:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFolder.group)
end

TFolder.from_obj = TFolder_from_obj

TFolder.proto_property = {'Folder'}

TFolder.default = {''}

TFolder.struct = {{name = 'Folder', is_array = false, struct = nil}}

function TFolder:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Folder', self.Folder, 'string', false, errs, need_convert)

    TFolder:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFolder.proto_property, errs, need_convert)
    return self
end

function TFolder:unpack(_)
    return self.Folder
end

LDAPController.Folder = TFolder

---@class LDAPController.UserDomain
---@field UserDomain string
local TUserDomain = {}
TUserDomain.__index = TUserDomain
TUserDomain.group = {}

local function TUserDomain_from_obj(obj)
    return setmetatable(obj, TUserDomain)
end

function TUserDomain.new(UserDomain)
    return TUserDomain_from_obj({UserDomain = UserDomain})
end
---@param obj LDAPController.UserDomain
function TUserDomain:init_from_obj(obj)
    self.UserDomain = obj.UserDomain
end

function TUserDomain:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUserDomain.group)
end

TUserDomain.from_obj = TUserDomain_from_obj

TUserDomain.proto_property = {'UserDomain'}

TUserDomain.default = {''}

TUserDomain.struct = {{name = 'UserDomain', is_array = false, struct = nil}}

function TUserDomain:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'UserDomain', self.UserDomain, 'string', false, errs, need_convert)

    TUserDomain:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUserDomain.proto_property, errs, need_convert)
    return self
end

function TUserDomain:unpack(_)
    return self.UserDomain
end

LDAPController.UserDomain = TUserDomain

---@class LDAPController.Port
---@field Port integer
local TPort = {}
TPort.__index = TPort
TPort.group = {}

local function TPort_from_obj(obj)
    return setmetatable(obj, TPort)
end

function TPort.new(Port)
    return TPort_from_obj({Port = Port or 636})
end
---@param obj LDAPController.Port
function TPort:init_from_obj(obj)
    self.Port = obj.Port or 636
end

function TPort:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPort.group)
end

TPort.from_obj = TPort_from_obj

TPort.proto_property = {'Port'}

TPort.default = {0}

TPort.struct = {{name = 'Port', is_array = false, struct = nil}}

function TPort:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Port', self.Port, 'int32', false, errs, need_convert)

    TPort:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPort.proto_property, errs, need_convert)
    return self
end

function TPort:unpack(_)
    return self.Port
end

LDAPController.Port = TPort

---@class LDAPController.HostAddr
---@field HostAddr string
local THostAddr = {}
THostAddr.__index = THostAddr
THostAddr.group = {}

local function THostAddr_from_obj(obj)
    return setmetatable(obj, THostAddr)
end

function THostAddr.new(HostAddr)
    return THostAddr_from_obj({HostAddr = HostAddr})
end
---@param obj LDAPController.HostAddr
function THostAddr:init_from_obj(obj)
    self.HostAddr = obj.HostAddr
end

function THostAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THostAddr.group)
end

THostAddr.from_obj = THostAddr_from_obj

THostAddr.proto_property = {'HostAddr'}

THostAddr.default = {''}

THostAddr.struct = {{name = 'HostAddr', is_array = false, struct = nil}}

function THostAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'HostAddr', self.HostAddr, 'string', false, errs, need_convert)

    THostAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THostAddr.proto_property, errs, need_convert)
    return self
end

function THostAddr:unpack(_)
    return self.HostAddr
end

LDAPController.HostAddr = THostAddr

---@class LDAPController.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled == nil and true or Enabled})
end
---@param obj LDAPController.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled == nil and true or obj.Enabled
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', false, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

LDAPController.Enabled = TEnabled

---@class LDAPController.SetBindDnPasswordRsp
local TSetBindDnPasswordRsp = {}
TSetBindDnPasswordRsp.__index = TSetBindDnPasswordRsp
TSetBindDnPasswordRsp.group = {}

local function TSetBindDnPasswordRsp_from_obj(obj)
    return setmetatable(obj, TSetBindDnPasswordRsp)
end

function TSetBindDnPasswordRsp.new()
    return TSetBindDnPasswordRsp_from_obj({})
end
---@param obj LDAPController.SetBindDnPasswordRsp
function TSetBindDnPasswordRsp:init_from_obj(obj)

end

function TSetBindDnPasswordRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBindDnPasswordRsp.group)
end

TSetBindDnPasswordRsp.from_obj = TSetBindDnPasswordRsp_from_obj

TSetBindDnPasswordRsp.proto_property = {}

TSetBindDnPasswordRsp.default = {}

TSetBindDnPasswordRsp.struct = {}

function TSetBindDnPasswordRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBindDnPasswordRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBindDnPasswordRsp.proto_property, errs, need_convert)
    return self
end

function TSetBindDnPasswordRsp:unpack(_)
end

LDAPController.SetBindDnPasswordRsp = TSetBindDnPasswordRsp

---@class LDAPController.SetBindDnPasswordReq
---@field Password integer[]
local TSetBindDnPasswordReq = {}
TSetBindDnPasswordReq.__index = TSetBindDnPasswordReq
TSetBindDnPasswordReq.group = {}

local function TSetBindDnPasswordReq_from_obj(obj)
    return setmetatable(obj, TSetBindDnPasswordReq)
end

function TSetBindDnPasswordReq.new(Password)
    return TSetBindDnPasswordReq_from_obj({Password = Password})
end
---@param obj LDAPController.SetBindDnPasswordReq
function TSetBindDnPasswordReq:init_from_obj(obj)
    self.Password = obj.Password
end

function TSetBindDnPasswordReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBindDnPasswordReq.group)
end

TSetBindDnPasswordReq.from_obj = TSetBindDnPasswordReq_from_obj

TSetBindDnPasswordReq.proto_property = {'Password'}

TSetBindDnPasswordReq.default = {{}}

TSetBindDnPasswordReq.struct = {{name = 'Password', is_array = true, struct = nil}}

function TSetBindDnPasswordReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Password', self.Password, 'uint8', false, errs, need_convert)

    if self.Password ~= nil then
        validate.lens(prefix .. 'Password', self.Password, 0, 20, errs, need_convert)
    end

    TSetBindDnPasswordReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBindDnPasswordReq.proto_property, errs, need_convert)
    return self
end

function TSetBindDnPasswordReq:unpack(_)
    return self.Password
end

LDAPController.SetBindDnPasswordReq = TSetBindDnPasswordReq

LDAPController.interface = mdb.register_interface('bmc.kepler.AccountService.LDAP.LDAPController', {
    Enabled = {'b', {}, false, true, false},
    HostAddr = {'s', {'EMIT_CHANGE'}, false, nil, false},
    Port = {'i', {'EMIT_CHANGE'}, false, 636, false},
    UserDomain = {'s', {'EMIT_CHANGE'}, false, nil, false},
    Folder = {'s', {'EMIT_CHANGE'}, false, nil, false},
    BindDN = {'s', {'EMIT_CHANGE'}, false, nil, false},
    CertVerifyEnabled = {'b', {'EMIT_CHANGE'}, false, true, false},
    CertVerifyLevel = {'y', {}, false, 2, false}
}, {SetBindDnPassword = {'a{ss}ay', '', TSetBindDnPasswordReq, TSetBindDnPasswordRsp}}, {})

return LDAPController
