-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Kerberos = {}

---@class Kerberos.Realm
---@field Realm string
local TRealm = {}
TRealm.__index = TRealm
TRealm.group = {}

local function TRealm_from_obj(obj)
    return setmetatable(obj, TRealm)
end

function TRealm.new(Realm)
    return TRealm_from_obj({Realm = Realm})
end
---@param obj Kerberos.Realm
function TRealm:init_from_obj(obj)
    self.Realm = obj.Realm
end

function TRealm:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRealm.group)
end

TRealm.from_obj = TRealm_from_obj

TRealm.proto_property = {'Realm'}

TRealm.default = {''}

TRealm.struct = {{name = 'Realm', is_array = false, struct = nil}}

function TRealm:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Realm', self.Realm, 'string', false, errs, need_convert)

    TRealm:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRealm.proto_property, errs, need_convert)
    return self
end

function TRealm:unpack(_)
    return self.Realm
end

Kerberos.Realm = TRealm

---@class Kerberos.Port
---@field Port integer
local TPort = {}
TPort.__index = TPort
TPort.group = {}

local function TPort_from_obj(obj)
    return setmetatable(obj, TPort)
end

function TPort.new(Port)
    return TPort_from_obj({Port = Port})
end
---@param obj Kerberos.Port
function TPort:init_from_obj(obj)
    self.Port = obj.Port
end

function TPort:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPort.group)
end

TPort.from_obj = TPort_from_obj

TPort.proto_property = {'Port'}

TPort.default = {0}

TPort.struct = {{name = 'Port', is_array = false, struct = nil}}

function TPort:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Port', self.Port, 'int32', false, errs, need_convert)

    TPort:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPort.proto_property, errs, need_convert)
    return self
end

function TPort:unpack(_)
    return self.Port
end

Kerberos.Port = TPort

---@class Kerberos.Address
---@field Address string
local TAddress = {}
TAddress.__index = TAddress
TAddress.group = {}

local function TAddress_from_obj(obj)
    return setmetatable(obj, TAddress)
end

function TAddress.new(Address)
    return TAddress_from_obj({Address = Address})
end
---@param obj Kerberos.Address
function TAddress:init_from_obj(obj)
    self.Address = obj.Address
end

function TAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddress.group)
end

TAddress.from_obj = TAddress_from_obj

TAddress.proto_property = {'Address'}

TAddress.default = {''}

TAddress.struct = {{name = 'Address', is_array = false, struct = nil}}

function TAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Address', self.Address, 'string', false, errs, need_convert)

    TAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddress.proto_property, errs, need_convert)
    return self
end

function TAddress:unpack(_)
    return self.Address
end

Kerberos.Address = TAddress

---@class Kerberos.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled == nil and true or Enabled})
end
---@param obj Kerberos.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled == nil and true or obj.Enabled
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', false, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

Kerberos.Enabled = TEnabled

---@class Kerberos.ImportKeyTableRsp
local TImportKeyTableRsp = {}
TImportKeyTableRsp.__index = TImportKeyTableRsp
TImportKeyTableRsp.group = {}

local function TImportKeyTableRsp_from_obj(obj)
    return setmetatable(obj, TImportKeyTableRsp)
end

function TImportKeyTableRsp.new()
    return TImportKeyTableRsp_from_obj({})
end
---@param obj Kerberos.ImportKeyTableRsp
function TImportKeyTableRsp:init_from_obj(obj)

end

function TImportKeyTableRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportKeyTableRsp.group)
end

TImportKeyTableRsp.from_obj = TImportKeyTableRsp_from_obj

TImportKeyTableRsp.proto_property = {}

TImportKeyTableRsp.default = {}

TImportKeyTableRsp.struct = {}

function TImportKeyTableRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TImportKeyTableRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportKeyTableRsp.proto_property, errs, need_convert)
    return self
end

function TImportKeyTableRsp:unpack(_)
end

Kerberos.ImportKeyTableRsp = TImportKeyTableRsp

---@class Kerberos.ImportKeyTableReq
---@field Path string
local TImportKeyTableReq = {}
TImportKeyTableReq.__index = TImportKeyTableReq
TImportKeyTableReq.group = {}

local function TImportKeyTableReq_from_obj(obj)
    return setmetatable(obj, TImportKeyTableReq)
end

function TImportKeyTableReq.new(Path)
    return TImportKeyTableReq_from_obj({Path = Path})
end
---@param obj Kerberos.ImportKeyTableReq
function TImportKeyTableReq:init_from_obj(obj)
    self.Path = obj.Path
end

function TImportKeyTableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportKeyTableReq.group)
end

TImportKeyTableReq.from_obj = TImportKeyTableReq_from_obj

TImportKeyTableReq.proto_property = {'Path'}

TImportKeyTableReq.default = {''}

TImportKeyTableReq.struct = {{name = 'Path', is_array = false, struct = nil}}

function TImportKeyTableReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Path', self.Path, 'string', false, errs, need_convert)

    if self.Path ~= nil then
        validate.lens(prefix .. 'Path', self.Path, 1, 256, errs, need_convert)
    end

    TImportKeyTableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportKeyTableReq.proto_property, errs, need_convert)
    return self
end

function TImportKeyTableReq:unpack(_)
    return self.Path
end

Kerberos.ImportKeyTableReq = TImportKeyTableReq

Kerberos.interface = mdb.register_interface('bmc.kepler.AccountService.Kerberos', {
    Enabled = {'b', nil, false, true, false},
    Address = {'s', nil, false, nil, false},
    Port = {'i', nil, false, nil, false},
    Realm = {'s', nil, false, nil, false}
}, {ImportKeyTable = {'a{ss}s', '', TImportKeyTableReq, TImportKeyTableRsp}}, {})

return Kerberos
