-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-11-26
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ConfigManage = {}

---@class ConfigManage.Preserve
---@field PreserveKey string
---@field PreserveValue string
local TPreserve = {}
TPreserve.__index = TPreserve
TPreserve.group = {}

local function TPreserve_from_obj(obj)
    return setmetatable(obj, TPreserve)
end

function TPreserve.new(PreserveKey, PreserveValue)
    return TPreserve_from_obj({PreserveKey = PreserveKey, PreserveValue = PreserveValue})
end
---@param obj ConfigManage.Preserve
function TPreserve:init_from_obj(obj)
    self.PreserveKey = obj.PreserveKey
    self.PreserveValue = obj.PreserveValue
end

function TPreserve:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPreserve.group)
end

TPreserve.from_obj = TPreserve_from_obj

TPreserve.proto_property = {'PreserveKey', 'PreserveValue'}

TPreserve.default = {'', ''}

TPreserve.struct = {
    {name = 'PreserveKey', is_array = false, struct = nil}, {name = 'PreserveValue', is_array = false, struct = nil}
}

function TPreserve:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreserveKey', self.PreserveKey, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'PreserveValue', self.PreserveValue, 'string', false, errs, need_convert)

    TPreserve:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPreserve.proto_property, errs, need_convert)
    return self
end

function TPreserve:unpack(_)
    return self.PreserveKey, self.PreserveValue
end

ConfigManage.Preserve = TPreserve

---@class ConfigManage.Object
---@field key string
---@field value string
local TObject = {}
TObject.__index = TObject
TObject.group = {}

local function TObject_from_obj(obj)
    return setmetatable(obj, TObject)
end

function TObject.new(dict)
    return TObject_from_obj(dict)
end

---@param obj ConfigManage.Object
function TObject:init_from_obj(obj)
    self = obj
end

function TObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TObject.group)
end

TObject.from_obj = TObject_from_obj

TObject.proto_property = {}

TObject.default = {}

TObject.struct = {}

function TObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TObject:remove_error_props(errs, self)
    return self
end

function TObject:unpack(_)
    return self
end

ConfigManage.Object = TObject

---@class ConfigManage.Items
---@field FileName string
---@field OriginPath string
local TItems = {}
TItems.__index = TItems
TItems.group = {}

local function TItems_from_obj(obj)
    return setmetatable(obj, TItems)
end

function TItems.new(FileName, OriginPath)
    return TItems_from_obj({FileName = FileName, OriginPath = OriginPath})
end
---@param obj ConfigManage.Items
function TItems:init_from_obj(obj)
    self.FileName = obj.FileName
    self.OriginPath = obj.OriginPath
end

function TItems:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TItems.group)
end

TItems.from_obj = TItems_from_obj

TItems.proto_property = {'FileName', 'OriginPath'}

TItems.default = {'', ''}

TItems.struct = {
    {name = 'FileName', is_array = false, struct = nil}, {name = 'OriginPath', is_array = false, struct = nil}
}

function TItems:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FileName', self.FileName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'OriginPath', self.OriginPath, 'string', false, errs, need_convert)

    TItems:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TItems.proto_property, errs, need_convert)
    return self
end

function TItems:unpack(_)
    return self.FileName, self.OriginPath
end

ConfigManage.Items = TItems

---@class ConfigManage.GetPreservedConfigRsp
---@field PreserveData string
local TGetPreservedConfigRsp = {}
TGetPreservedConfigRsp.__index = TGetPreservedConfigRsp
TGetPreservedConfigRsp.group = {}

local function TGetPreservedConfigRsp_from_obj(obj)
    return setmetatable(obj, TGetPreservedConfigRsp)
end

function TGetPreservedConfigRsp.new(PreserveData)
    return TGetPreservedConfigRsp_from_obj({PreserveData = PreserveData})
end
---@param obj ConfigManage.GetPreservedConfigRsp
function TGetPreservedConfigRsp:init_from_obj(obj)
    self.PreserveData = obj.PreserveData
end

function TGetPreservedConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPreservedConfigRsp.group)
end

TGetPreservedConfigRsp.from_obj = TGetPreservedConfigRsp_from_obj

TGetPreservedConfigRsp.proto_property = {'PreserveData'}

TGetPreservedConfigRsp.default = {''}

TGetPreservedConfigRsp.struct = {{name = 'PreserveData', is_array = false, struct = nil}}

function TGetPreservedConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreserveData', self.PreserveData, 'string', false, errs, need_convert)

    TGetPreservedConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPreservedConfigRsp.proto_property, errs, need_convert)
    return self
end

function TGetPreservedConfigRsp:unpack(_)
    return self.PreserveData
end

ConfigManage.GetPreservedConfigRsp = TGetPreservedConfigRsp

---@class ConfigManage.GetPreservedConfigReq
---@field PreserveFlag ConfigManage.Preserve
local TGetPreservedConfigReq = {}
TGetPreservedConfigReq.__index = TGetPreservedConfigReq
TGetPreservedConfigReq.group = {}

local function TGetPreservedConfigReq_from_obj(obj)
    obj.PreserveFlag = utils.from_obj(ConfigManage.Preserve, obj.PreserveFlag)
    return setmetatable(obj, TGetPreservedConfigReq)
end

function TGetPreservedConfigReq.new(PreserveFlag)
    return TGetPreservedConfigReq_from_obj({PreserveFlag = PreserveFlag})
end
---@param obj ConfigManage.GetPreservedConfigReq
function TGetPreservedConfigReq:init_from_obj(obj)
    self.PreserveFlag = obj.PreserveFlag
end

function TGetPreservedConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPreservedConfigReq.group)
end

TGetPreservedConfigReq.from_obj = TGetPreservedConfigReq_from_obj

TGetPreservedConfigReq.proto_property = {'PreserveFlag'}

TGetPreservedConfigReq.default = {ConfigManage.Preserve.default}

TGetPreservedConfigReq.struct = {{name = 'PreserveFlag', is_array = false, struct = ConfigManage.Preserve.struct}}

function TGetPreservedConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    ConfigManage.Preserve.new(self.PreserveFlag.PreserveKey, self.PreserveFlag.PreserveValue):validate(prefix, errs,
        need_convert)

    TGetPreservedConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPreservedConfigReq.proto_property, errs, need_convert)
    return self
end

function TGetPreservedConfigReq:unpack(raw)
    return utils.unpack(raw, self.PreserveFlag)
end

ConfigManage.GetPreservedConfigReq = TGetPreservedConfigReq

---@class ConfigManage.GetTrustedConfigRsp
---@field Configuration string
local TGetTrustedConfigRsp = {}
TGetTrustedConfigRsp.__index = TGetTrustedConfigRsp
TGetTrustedConfigRsp.group = {}

local function TGetTrustedConfigRsp_from_obj(obj)
    return setmetatable(obj, TGetTrustedConfigRsp)
end

function TGetTrustedConfigRsp.new(Configuration)
    return TGetTrustedConfigRsp_from_obj({Configuration = Configuration})
end
---@param obj ConfigManage.GetTrustedConfigRsp
function TGetTrustedConfigRsp:init_from_obj(obj)
    self.Configuration = obj.Configuration
end

function TGetTrustedConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTrustedConfigRsp.group)
end

TGetTrustedConfigRsp.from_obj = TGetTrustedConfigRsp_from_obj

TGetTrustedConfigRsp.proto_property = {'Configuration'}

TGetTrustedConfigRsp.default = {''}

TGetTrustedConfigRsp.struct = {{name = 'Configuration', is_array = false, struct = nil}}

function TGetTrustedConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Configuration', self.Configuration, 'string', false, errs, need_convert)

    TGetTrustedConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTrustedConfigRsp.proto_property, errs, need_convert)
    return self
end

function TGetTrustedConfigRsp:unpack(_)
    return self.Configuration
end

ConfigManage.GetTrustedConfigRsp = TGetTrustedConfigRsp

---@class ConfigManage.GetTrustedConfigReq
local TGetTrustedConfigReq = {}
TGetTrustedConfigReq.__index = TGetTrustedConfigReq
TGetTrustedConfigReq.group = {}

local function TGetTrustedConfigReq_from_obj(obj)
    return setmetatable(obj, TGetTrustedConfigReq)
end

function TGetTrustedConfigReq.new()
    return TGetTrustedConfigReq_from_obj({})
end
---@param obj ConfigManage.GetTrustedConfigReq
function TGetTrustedConfigReq:init_from_obj(obj)

end

function TGetTrustedConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTrustedConfigReq.group)
end

TGetTrustedConfigReq.from_obj = TGetTrustedConfigReq_from_obj

TGetTrustedConfigReq.proto_property = {}

TGetTrustedConfigReq.default = {}

TGetTrustedConfigReq.struct = {}

function TGetTrustedConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetTrustedConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTrustedConfigReq.proto_property, errs, need_convert)
    return self
end

function TGetTrustedConfigReq:unpack(_)
end

ConfigManage.GetTrustedConfigReq = TGetTrustedConfigReq

---@class ConfigManage.VerifyRsp
---@field Result string
local TVerifyRsp = {}
TVerifyRsp.__index = TVerifyRsp
TVerifyRsp.group = {}

local function TVerifyRsp_from_obj(obj)
    return setmetatable(obj, TVerifyRsp)
end

function TVerifyRsp.new(Result)
    return TVerifyRsp_from_obj({Result = Result})
end
---@param obj ConfigManage.VerifyRsp
function TVerifyRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TVerifyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVerifyRsp.group)
end

TVerifyRsp.from_obj = TVerifyRsp_from_obj

TVerifyRsp.proto_property = {'Result'}

TVerifyRsp.default = {''}

TVerifyRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TVerifyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'string', false, errs, need_convert)

    TVerifyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVerifyRsp.proto_property, errs, need_convert)
    return self
end

function TVerifyRsp:unpack(_)
    return self.Result
end

ConfigManage.VerifyRsp = TVerifyRsp

---@class ConfigManage.VerifyReq
---@field Data string
local TVerifyReq = {}
TVerifyReq.__index = TVerifyReq
TVerifyReq.group = {}

local function TVerifyReq_from_obj(obj)
    return setmetatable(obj, TVerifyReq)
end

function TVerifyReq.new(Data)
    return TVerifyReq_from_obj({Data = Data})
end
---@param obj ConfigManage.VerifyReq
function TVerifyReq:init_from_obj(obj)
    self.Data = obj.Data
end

function TVerifyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVerifyReq.group)
end

TVerifyReq.from_obj = TVerifyReq_from_obj

TVerifyReq.proto_property = {'Data'}

TVerifyReq.default = {''}

TVerifyReq.struct = {{name = 'Data', is_array = false, struct = nil}}

function TVerifyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TVerifyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVerifyReq.proto_property, errs, need_convert)
    return self
end

function TVerifyReq:unpack(_)
    return self.Data
end

ConfigManage.VerifyReq = TVerifyReq

---@class ConfigManage.RecoverRsp
local TRecoverRsp = {}
TRecoverRsp.__index = TRecoverRsp
TRecoverRsp.group = {}

local function TRecoverRsp_from_obj(obj)
    return setmetatable(obj, TRecoverRsp)
end

function TRecoverRsp.new()
    return TRecoverRsp_from_obj({})
end
---@param obj ConfigManage.RecoverRsp
function TRecoverRsp:init_from_obj(obj)

end

function TRecoverRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecoverRsp.group)
end

TRecoverRsp.from_obj = TRecoverRsp_from_obj

TRecoverRsp.proto_property = {}

TRecoverRsp.default = {}

TRecoverRsp.struct = {}

function TRecoverRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TRecoverRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecoverRsp.proto_property, errs, need_convert)
    return self
end

function TRecoverRsp:unpack(_)
end

ConfigManage.RecoverRsp = TRecoverRsp

---@class ConfigManage.RecoverReq
---@field PreserveList ConfigManage.Object
local TRecoverReq = {}
TRecoverReq.__index = TRecoverReq
TRecoverReq.group = {}

local function TRecoverReq_from_obj(obj)
    return setmetatable(obj, TRecoverReq)
end

function TRecoverReq.new(PreserveList)
    return TRecoverReq_from_obj({PreserveList = PreserveList})
end
---@param obj ConfigManage.RecoverReq
function TRecoverReq:init_from_obj(obj)
    self.PreserveList = obj.PreserveList
end

function TRecoverReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecoverReq.group)
end

TRecoverReq.from_obj = TRecoverReq_from_obj

TRecoverReq.proto_property = {'PreserveList'}

TRecoverReq.default = {ConfigManage.Object.default}

TRecoverReq.struct = {{name = 'PreserveList', is_array = false, struct = ConfigManage.Object.struct}}

function TRecoverReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    ConfigManage.Object.new(self.PreserveList):validate(prefix, errs, need_convert)

    TRecoverReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecoverReq.proto_property, errs, need_convert)
    return self
end

function TRecoverReq:unpack(_)
    return self.PreserveList
end

ConfigManage.RecoverReq = TRecoverReq

---@class ConfigManage.ImportRsp
local TImportRsp = {}
TImportRsp.__index = TImportRsp
TImportRsp.group = {}

local function TImportRsp_from_obj(obj)
    return setmetatable(obj, TImportRsp)
end

function TImportRsp.new()
    return TImportRsp_from_obj({})
end
---@param obj ConfigManage.ImportRsp
function TImportRsp:init_from_obj(obj)

end

function TImportRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportRsp.group)
end

TImportRsp.from_obj = TImportRsp_from_obj

TImportRsp.proto_property = {}

TImportRsp.default = {}

TImportRsp.struct = {}

function TImportRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TImportRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportRsp.proto_property, errs, need_convert)
    return self
end

function TImportRsp:unpack(_)
end

ConfigManage.ImportRsp = TImportRsp

---@class ConfigManage.ImportReq
---@field Data string
---@field Type string
local TImportReq = {}
TImportReq.__index = TImportReq
TImportReq.group = {}

local function TImportReq_from_obj(obj)
    return setmetatable(obj, TImportReq)
end

function TImportReq.new(Data, Type)
    return TImportReq_from_obj({Data = Data, Type = Type})
end
---@param obj ConfigManage.ImportReq
function TImportReq:init_from_obj(obj)
    self.Data = obj.Data
    self.Type = obj.Type
end

function TImportReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportReq.group)
end

TImportReq.from_obj = TImportReq_from_obj

TImportReq.proto_property = {'Data', 'Type'}

TImportReq.default = {'', ''}

TImportReq.struct = {{name = 'Data', is_array = false, struct = nil}, {name = 'Type', is_array = false, struct = nil}}

function TImportReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)

    if self.Type ~= nil then
        validate.Enum(prefix .. 'Type', self.Type, '', {'custom', 'configuration'}, errs, need_convert)
    end

    TImportReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportReq.proto_property, errs, need_convert)
    return self
end

function TImportReq:unpack(_)
    return self.Data, self.Type
end

ConfigManage.ImportReq = TImportReq

---@class ConfigManage.ExportRsp
---@field Data string
local TExportRsp = {}
TExportRsp.__index = TExportRsp
TExportRsp.group = {}

local function TExportRsp_from_obj(obj)
    return setmetatable(obj, TExportRsp)
end

function TExportRsp.new(Data)
    return TExportRsp_from_obj({Data = Data})
end
---@param obj ConfigManage.ExportRsp
function TExportRsp:init_from_obj(obj)
    self.Data = obj.Data
end

function TExportRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportRsp.group)
end

TExportRsp.from_obj = TExportRsp_from_obj

TExportRsp.proto_property = {'Data'}

TExportRsp.default = {''}

TExportRsp.struct = {{name = 'Data', is_array = false, struct = nil}}

function TExportRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TExportRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportRsp.proto_property, errs, need_convert)
    return self
end

function TExportRsp:unpack(_)
    return self.Data
end

ConfigManage.ExportRsp = TExportRsp

---@class ConfigManage.ExportReq
---@field Type string
local TExportReq = {}
TExportReq.__index = TExportReq
TExportReq.group = {}

local function TExportReq_from_obj(obj)
    return setmetatable(obj, TExportReq)
end

function TExportReq.new(Type)
    return TExportReq_from_obj({Type = Type})
end
---@param obj ConfigManage.ExportReq
function TExportReq:init_from_obj(obj)
    self.Type = obj.Type
end

function TExportReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportReq.group)
end

TExportReq.from_obj = TExportReq_from_obj

TExportReq.proto_property = {'Type'}

TExportReq.default = {''}

TExportReq.struct = {{name = 'Type', is_array = false, struct = nil}}

function TExportReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)

    if self.Type ~= nil then
        validate.Enum(prefix .. 'Type', self.Type, '', {'custom', 'configuration'}, errs, need_convert)
    end

    TExportReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportReq.proto_property, errs, need_convert)
    return self
end

function TExportReq:unpack(_)
    return self.Type
end

ConfigManage.ExportReq = TExportReq

---@class ConfigManage.BackupRsp
---@field List ConfigManage.Items[]
local TBackupRsp = {}
TBackupRsp.__index = TBackupRsp
TBackupRsp.group = {}

local function TBackupRsp_from_obj(obj)
    obj.List = utils.from_obj(ConfigManage.Items, obj.List, true)
    return setmetatable(obj, TBackupRsp)
end

function TBackupRsp.new(List)
    return TBackupRsp_from_obj({List = List})
end
---@param obj ConfigManage.BackupRsp
function TBackupRsp:init_from_obj(obj)
    self.List = obj.List
end

function TBackupRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBackupRsp.group)
end

TBackupRsp.from_obj = TBackupRsp_from_obj

TBackupRsp.proto_property = {'List'}

TBackupRsp.default = {{}}

TBackupRsp.struct = {{name = 'List', is_array = true, struct = ConfigManage.Items.struct}}

function TBackupRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.List) do
        ConfigManage.Items.new(v.FileName, v.OriginPath):validate(prefix, errs, need_convert)
    end

    TBackupRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBackupRsp.proto_property, errs, need_convert)
    return self
end

function TBackupRsp:unpack(raw)
    return utils.unpack(raw, self.List, true)
end

ConfigManage.BackupRsp = TBackupRsp

---@class ConfigManage.BackupReq
---@field FilePath string
local TBackupReq = {}
TBackupReq.__index = TBackupReq
TBackupReq.group = {}

local function TBackupReq_from_obj(obj)
    return setmetatable(obj, TBackupReq)
end

function TBackupReq.new(FilePath)
    return TBackupReq_from_obj({FilePath = FilePath})
end
---@param obj ConfigManage.BackupReq
function TBackupReq:init_from_obj(obj)
    self.FilePath = obj.FilePath
end

function TBackupReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBackupReq.group)
end

TBackupReq.from_obj = TBackupReq_from_obj

TBackupReq.proto_property = {'FilePath'}

TBackupReq.default = {''}

TBackupReq.struct = {{name = 'FilePath', is_array = false, struct = nil}}

function TBackupReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FilePath', self.FilePath, 'string', false, errs, need_convert)

    TBackupReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBackupReq.proto_property, errs, need_convert)
    return self
end

function TBackupReq:unpack(_)
    return self.FilePath
end

ConfigManage.BackupReq = TBackupReq

ConfigManage.interface = mdb.register_interface('bmc.kepler.MicroComponent.ConfigManage', {}, {
    Backup = {'a{ss}s', 'a(ss)', TBackupReq, TBackupRsp},
    Export = {'a{ss}s', 's', TExportReq, TExportRsp},
    Import = {'a{ss}ss', '', TImportReq, TImportRsp},
    Recover = {'a{ss}a{ss}', '', TRecoverReq, TRecoverRsp},
    Verify = {'a{ss}s', 's', TVerifyReq, TVerifyRsp},
    GetTrustedConfig = {'a{ss}', 's', TGetTrustedConfigReq, TGetTrustedConfigRsp},
    GetPreservedConfig = {'a{ss}(ss)', 's', TGetPreservedConfigReq, TGetPreservedConfigRsp}
}, {})

return ConfigManage
