-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CertificateAuthentication = {}

---@class CertificateAuthentication.InterChassisValidation
---@field InterChassisValidation string
local TInterChassisValidation = {}
TInterChassisValidation.__index = TInterChassisValidation
TInterChassisValidation.group = {}

local function TInterChassisValidation_from_obj(obj)
    return setmetatable(obj, TInterChassisValidation)
end

function TInterChassisValidation.new(InterChassisValidation)
    return TInterChassisValidation_from_obj({InterChassisValidation = InterChassisValidation or [=[LLDP]=]})
end
---@param obj CertificateAuthentication.InterChassisValidation
function TInterChassisValidation:init_from_obj(obj)
    self.InterChassisValidation = obj.InterChassisValidation or [=[LLDP]=]
end

function TInterChassisValidation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInterChassisValidation.group)
end

TInterChassisValidation.from_obj = TInterChassisValidation_from_obj

TInterChassisValidation.proto_property = {'InterChassisValidation'}

TInterChassisValidation.default = {''}

TInterChassisValidation.struct = {{name = 'InterChassisValidation', is_array = false, struct = nil}}

function TInterChassisValidation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InterChassisValidation', self.InterChassisValidation, 'string', false, errs,
        need_convert)

    if self.InterChassisValidation ~= nil then
        validate.Enum(prefix .. 'InterChassisValidation', self.InterChassisValidation, '', {'None', 'LLDP'}, errs,
            need_convert)
    end

    TInterChassisValidation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInterChassisValidation.proto_property, errs, need_convert)
    return self
end

function TInterChassisValidation:unpack(_)
    return self.InterChassisValidation
end

CertificateAuthentication.InterChassisValidation = TInterChassisValidation

---@class CertificateAuthentication.InterChassisAuthEnabled
---@field InterChassisAuthEnabled boolean
local TInterChassisAuthEnabled = {}
TInterChassisAuthEnabled.__index = TInterChassisAuthEnabled
TInterChassisAuthEnabled.group = {}

local function TInterChassisAuthEnabled_from_obj(obj)
    return setmetatable(obj, TInterChassisAuthEnabled)
end

function TInterChassisAuthEnabled.new(InterChassisAuthEnabled)
    return TInterChassisAuthEnabled_from_obj({InterChassisAuthEnabled = InterChassisAuthEnabled or false})
end
---@param obj CertificateAuthentication.InterChassisAuthEnabled
function TInterChassisAuthEnabled:init_from_obj(obj)
    self.InterChassisAuthEnabled = obj.InterChassisAuthEnabled or false
end

function TInterChassisAuthEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInterChassisAuthEnabled.group)
end

TInterChassisAuthEnabled.from_obj = TInterChassisAuthEnabled_from_obj

TInterChassisAuthEnabled.proto_property = {'InterChassisAuthEnabled'}

TInterChassisAuthEnabled.default = {false}

TInterChassisAuthEnabled.struct = {{name = 'InterChassisAuthEnabled', is_array = false, struct = nil}}

function TInterChassisAuthEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InterChassisAuthEnabled', self.InterChassisAuthEnabled, 'bool', false, errs,
        need_convert)

    TInterChassisAuthEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInterChassisAuthEnabled.proto_property, errs, need_convert)
    return self
end

function TInterChassisAuthEnabled:unpack(_)
    return self.InterChassisAuthEnabled
end

CertificateAuthentication.InterChassisAuthEnabled = TInterChassisAuthEnabled

---@class CertificateAuthentication.OCSPEnabled
---@field OCSPEnabled boolean
local TOCSPEnabled = {}
TOCSPEnabled.__index = TOCSPEnabled
TOCSPEnabled.group = {}

local function TOCSPEnabled_from_obj(obj)
    return setmetatable(obj, TOCSPEnabled)
end

function TOCSPEnabled.new(OCSPEnabled)
    return TOCSPEnabled_from_obj({OCSPEnabled = OCSPEnabled or false})
end
---@param obj CertificateAuthentication.OCSPEnabled
function TOCSPEnabled:init_from_obj(obj)
    self.OCSPEnabled = obj.OCSPEnabled or false
end

function TOCSPEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOCSPEnabled.group)
end

TOCSPEnabled.from_obj = TOCSPEnabled_from_obj

TOCSPEnabled.proto_property = {'OCSPEnabled'}

TOCSPEnabled.default = {false}

TOCSPEnabled.struct = {{name = 'OCSPEnabled', is_array = false, struct = nil}}

function TOCSPEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OCSPEnabled', self.OCSPEnabled, 'bool', false, errs, need_convert)

    TOCSPEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOCSPEnabled.proto_property, errs, need_convert)
    return self
end

function TOCSPEnabled:unpack(_)
    return self.OCSPEnabled
end

CertificateAuthentication.OCSPEnabled = TOCSPEnabled

---@class CertificateAuthentication.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled or false})
end
---@param obj CertificateAuthentication.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled or false
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', false, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

CertificateAuthentication.Enabled = TEnabled

CertificateAuthentication.interface = mdb.register_interface('bmc.kepler.AccountService.CertificateAuthentication', {
    Enabled = {'b', nil, false, false, false},
    OCSPEnabled = {'b', nil, false, false, false},
    InterChassisAuthEnabled = {'b', {'EMIT_CHANGE'}, false, false, false},
    InterChassisValidation = {'s', {}, false, 'LLDP', false}
}, {}, {})

return CertificateAuthentication
