-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local create_enum_type = require 'mc.enum'

local Authentication = {}

---@class Authentication.SessionLogoutType: Enum
local ESessionLogoutType = create_enum_type('SessionLogoutType')
ESessionLogoutType.default = ESessionLogoutType.new(2147483647)
ESessionLogoutType.struct = nil
ESessionLogoutType.SessionLogout = ESessionLogoutType.new(0)
ESessionLogoutType.SessionTimeout = ESessionLogoutType.new(1)
ESessionLogoutType.SessionKickout = ESessionLogoutType.new(2)
ESessionLogoutType.SessionRelogin = ESessionLogoutType.new(3)
ESessionLogoutType.AccountConfigChange = ESessionLogoutType.new(4)
ESessionLogoutType.BMCConfigChange = ESessionLogoutType.new(5)

Authentication.SessionLogoutType = ESessionLogoutType

---@class Authentication.RmcpAuthAlgo: Enum
local ERmcpAuthAlgo = create_enum_type('RmcpAuthAlgo')
ERmcpAuthAlgo.default = ERmcpAuthAlgo.new(2147483647)
ERmcpAuthAlgo.struct = nil
ERmcpAuthAlgo.None = ERmcpAuthAlgo.new(0)
ERmcpAuthAlgo.HmacSha1 = ERmcpAuthAlgo.new(1)
ERmcpAuthAlgo.HmacMd5 = ERmcpAuthAlgo.new(2)
ERmcpAuthAlgo.HmacSha2 = ERmcpAuthAlgo.new(3)

Authentication.RmcpAuthAlgo = ERmcpAuthAlgo

---@class Authentication.AuthType: Enum
local EAuthType = create_enum_type('AuthType')
EAuthType.default = EAuthType.new(2147483647)
EAuthType.struct = nil
EAuthType.Local = EAuthType.new(0)
EAuthType.ldap_auto_match = EAuthType.new(1)
EAuthType.ldap_server1 = EAuthType.new(2)
EAuthType.ldap_server2 = EAuthType.new(3)
EAuthType.ldap_server3 = EAuthType.new(4)
EAuthType.ldap_server4 = EAuthType.new(5)
EAuthType.ldap_server5 = EAuthType.new(6)
EAuthType.ldap_server6 = EAuthType.new(7)
EAuthType.ldap_kerberos_sso = EAuthType.new(12)
EAuthType.kerberos_server = EAuthType.new(13)
EAuthType.sso_local = EAuthType.new(14)
EAuthType.sso_ldap = EAuthType.new(15)
EAuthType.auto_match = EAuthType.new(255)

Authentication.AuthType = EAuthType

---@class Authentication.LocalAccountAuth
---@field LocalAccountAuth string
local TLocalAccountAuth = {}
TLocalAccountAuth.__index = TLocalAccountAuth
TLocalAccountAuth.group = {}

local function TLocalAccountAuth_from_obj(obj)
    return setmetatable(obj, TLocalAccountAuth)
end

function TLocalAccountAuth.new(LocalAccountAuth)
    return TLocalAccountAuth_from_obj({LocalAccountAuth = LocalAccountAuth or [=[LocalFirst]=]})
end
---@param obj Authentication.LocalAccountAuth
function TLocalAccountAuth:init_from_obj(obj)
    self.LocalAccountAuth = obj.LocalAccountAuth or [=[LocalFirst]=]
end

function TLocalAccountAuth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocalAccountAuth.group)
end

TLocalAccountAuth.from_obj = TLocalAccountAuth_from_obj

TLocalAccountAuth.proto_property = {'LocalAccountAuth'}

TLocalAccountAuth.default = {''}

TLocalAccountAuth.struct = {{name = 'LocalAccountAuth', is_array = false, struct = nil}}

function TLocalAccountAuth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocalAccountAuth', self.LocalAccountAuth, 'string', false, errs, need_convert)

    if self.LocalAccountAuth ~= nil then
        validate.Enum(prefix .. 'LocalAccountAuth', self.LocalAccountAuth, '',
            {'Disabled', 'Enabled', 'Fallback', 'LocalFirst'}, errs, need_convert)
    end

    TLocalAccountAuth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocalAccountAuth.proto_property, errs, need_convert)
    return self
end

function TLocalAccountAuth:unpack(_)
    return self.LocalAccountAuth
end

Authentication.LocalAccountAuth = TLocalAccountAuth

---@class Authentication.AccountLockoutCounterResetAfter
---@field AccountLockoutCounterResetAfter integer
local TAccountLockoutCounterResetAfter = {}
TAccountLockoutCounterResetAfter.__index = TAccountLockoutCounterResetAfter
TAccountLockoutCounterResetAfter.group = {}

local function TAccountLockoutCounterResetAfter_from_obj(obj)
    return setmetatable(obj, TAccountLockoutCounterResetAfter)
end

function TAccountLockoutCounterResetAfter.new(AccountLockoutCounterResetAfter)
    return TAccountLockoutCounterResetAfter_from_obj({
        AccountLockoutCounterResetAfter = AccountLockoutCounterResetAfter or 300
    })
end
---@param obj Authentication.AccountLockoutCounterResetAfter
function TAccountLockoutCounterResetAfter:init_from_obj(obj)
    self.AccountLockoutCounterResetAfter = obj.AccountLockoutCounterResetAfter or 300
end

function TAccountLockoutCounterResetAfter:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccountLockoutCounterResetAfter.group)
end

TAccountLockoutCounterResetAfter.from_obj = TAccountLockoutCounterResetAfter_from_obj

TAccountLockoutCounterResetAfter.proto_property = {'AccountLockoutCounterResetAfter'}

TAccountLockoutCounterResetAfter.default = {0}

TAccountLockoutCounterResetAfter.struct = {{name = 'AccountLockoutCounterResetAfter', is_array = false, struct = nil}}

function TAccountLockoutCounterResetAfter:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AccountLockoutCounterResetAfter', self.AccountLockoutCounterResetAfter, 'int32', false,
        errs, need_convert)

    if self.AccountLockoutCounterResetAfter ~= nil then
        validate.ranges(prefix .. 'AccountLockoutCounterResetAfter', self.AccountLockoutCounterResetAfter, 0, 1800,
            errs, need_convert)
    end

    TAccountLockoutCounterResetAfter:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccountLockoutCounterResetAfter.proto_property, errs, need_convert)
    return self
end

function TAccountLockoutCounterResetAfter:unpack(_)
    return self.AccountLockoutCounterResetAfter
end

Authentication.AccountLockoutCounterResetAfter = TAccountLockoutCounterResetAfter

---@class Authentication.MaxAccountLockoutThreshold
---@field MaxAccountLockoutThreshold integer
local TMaxAccountLockoutThreshold = {}
TMaxAccountLockoutThreshold.__index = TMaxAccountLockoutThreshold
TMaxAccountLockoutThreshold.group = {}

local function TMaxAccountLockoutThreshold_from_obj(obj)
    return setmetatable(obj, TMaxAccountLockoutThreshold)
end

function TMaxAccountLockoutThreshold.new(MaxAccountLockoutThreshold)
    return TMaxAccountLockoutThreshold_from_obj({MaxAccountLockoutThreshold = MaxAccountLockoutThreshold or 6})
end
---@param obj Authentication.MaxAccountLockoutThreshold
function TMaxAccountLockoutThreshold:init_from_obj(obj)
    self.MaxAccountLockoutThreshold = obj.MaxAccountLockoutThreshold or 6
end

function TMaxAccountLockoutThreshold:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxAccountLockoutThreshold.group)
end

TMaxAccountLockoutThreshold.from_obj = TMaxAccountLockoutThreshold_from_obj

TMaxAccountLockoutThreshold.proto_property = {'MaxAccountLockoutThreshold'}

TMaxAccountLockoutThreshold.default = {0}

TMaxAccountLockoutThreshold.struct = {{name = 'MaxAccountLockoutThreshold', is_array = false, struct = nil}}

function TMaxAccountLockoutThreshold:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxAccountLockoutThreshold', self.MaxAccountLockoutThreshold, 'int32', false, errs,
        need_convert)

    if self.MaxAccountLockoutThreshold ~= nil then
        validate.ranges(prefix .. 'MaxAccountLockoutThreshold', self.MaxAccountLockoutThreshold, 6, 255, errs,
            need_convert)
    end

    TMaxAccountLockoutThreshold:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxAccountLockoutThreshold.proto_property, errs, need_convert)
    return self
end

function TMaxAccountLockoutThreshold:unpack(_)
    return self.MaxAccountLockoutThreshold
end

Authentication.MaxAccountLockoutThreshold = TMaxAccountLockoutThreshold

---@class Authentication.MaxAccountLockoutDuration
---@field MaxAccountLockoutDuration integer
local TMaxAccountLockoutDuration = {}
TMaxAccountLockoutDuration.__index = TMaxAccountLockoutDuration
TMaxAccountLockoutDuration.group = {}

local function TMaxAccountLockoutDuration_from_obj(obj)
    return setmetatable(obj, TMaxAccountLockoutDuration)
end

function TMaxAccountLockoutDuration.new(MaxAccountLockoutDuration)
    return TMaxAccountLockoutDuration_from_obj({MaxAccountLockoutDuration = MaxAccountLockoutDuration or 1800})
end
---@param obj Authentication.MaxAccountLockoutDuration
function TMaxAccountLockoutDuration:init_from_obj(obj)
    self.MaxAccountLockoutDuration = obj.MaxAccountLockoutDuration or 1800
end

function TMaxAccountLockoutDuration:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxAccountLockoutDuration.group)
end

TMaxAccountLockoutDuration.from_obj = TMaxAccountLockoutDuration_from_obj

TMaxAccountLockoutDuration.proto_property = {'MaxAccountLockoutDuration'}

TMaxAccountLockoutDuration.default = {0}

TMaxAccountLockoutDuration.struct = {{name = 'MaxAccountLockoutDuration', is_array = false, struct = nil}}

function TMaxAccountLockoutDuration:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxAccountLockoutDuration', self.MaxAccountLockoutDuration, 'int32', false, errs,
        need_convert)

    if self.MaxAccountLockoutDuration ~= nil then
        validate.ranges(prefix .. 'MaxAccountLockoutDuration', self.MaxAccountLockoutDuration, 1800, 86400, errs,
            need_convert)
    end

    TMaxAccountLockoutDuration:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxAccountLockoutDuration.proto_property, errs, need_convert)
    return self
end

function TMaxAccountLockoutDuration:unpack(_)
    return self.MaxAccountLockoutDuration
end

Authentication.MaxAccountLockoutDuration = TMaxAccountLockoutDuration

---@class Authentication.AccountLockoutThreshold
---@field AccountLockoutThreshold integer
local TAccountLockoutThreshold = {}
TAccountLockoutThreshold.__index = TAccountLockoutThreshold
TAccountLockoutThreshold.group = {}

local function TAccountLockoutThreshold_from_obj(obj)
    return setmetatable(obj, TAccountLockoutThreshold)
end

function TAccountLockoutThreshold.new(AccountLockoutThreshold)
    return TAccountLockoutThreshold_from_obj({AccountLockoutThreshold = AccountLockoutThreshold or 5})
end
---@param obj Authentication.AccountLockoutThreshold
function TAccountLockoutThreshold:init_from_obj(obj)
    self.AccountLockoutThreshold = obj.AccountLockoutThreshold or 5
end

function TAccountLockoutThreshold:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccountLockoutThreshold.group)
end

TAccountLockoutThreshold.from_obj = TAccountLockoutThreshold_from_obj

TAccountLockoutThreshold.proto_property = {'AccountLockoutThreshold'}

TAccountLockoutThreshold.default = {0}

TAccountLockoutThreshold.struct = {{name = 'AccountLockoutThreshold', is_array = false, struct = nil}}

function TAccountLockoutThreshold:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AccountLockoutThreshold', self.AccountLockoutThreshold, 'int32', false, errs,
        need_convert)

    if self.AccountLockoutThreshold ~= nil then
        validate.ranges(prefix .. 'AccountLockoutThreshold', self.AccountLockoutThreshold, 0, 255, errs, need_convert)
    end

    TAccountLockoutThreshold:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccountLockoutThreshold.proto_property, errs, need_convert)
    return self
end

function TAccountLockoutThreshold:unpack(_)
    return self.AccountLockoutThreshold
end

Authentication.AccountLockoutThreshold = TAccountLockoutThreshold

---@class Authentication.AccountLockoutDuration
---@field AccountLockoutDuration integer
local TAccountLockoutDuration = {}
TAccountLockoutDuration.__index = TAccountLockoutDuration
TAccountLockoutDuration.group = {}

local function TAccountLockoutDuration_from_obj(obj)
    return setmetatable(obj, TAccountLockoutDuration)
end

function TAccountLockoutDuration.new(AccountLockoutDuration)
    return TAccountLockoutDuration_from_obj({AccountLockoutDuration = AccountLockoutDuration or 300})
end
---@param obj Authentication.AccountLockoutDuration
function TAccountLockoutDuration:init_from_obj(obj)
    self.AccountLockoutDuration = obj.AccountLockoutDuration or 300
end

function TAccountLockoutDuration:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccountLockoutDuration.group)
end

TAccountLockoutDuration.from_obj = TAccountLockoutDuration_from_obj

TAccountLockoutDuration.proto_property = {'AccountLockoutDuration'}

TAccountLockoutDuration.default = {0}

TAccountLockoutDuration.struct = {{name = 'AccountLockoutDuration', is_array = false, struct = nil}}

function TAccountLockoutDuration:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AccountLockoutDuration', self.AccountLockoutDuration, 'int32', false, errs,
        need_convert)

    if self.AccountLockoutDuration ~= nil then
        validate.ranges(prefix .. 'AccountLockoutDuration', self.AccountLockoutDuration, 60, 86400, errs, need_convert)
    end

    TAccountLockoutDuration:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccountLockoutDuration.proto_property, errs, need_convert)
    return self
end

function TAccountLockoutDuration:unpack(_)
    return self.AccountLockoutDuration
end

Authentication.AccountLockoutDuration = TAccountLockoutDuration

---@class Authentication.AuthenticateReq
---@field UserName string
---@field Password integer[]
---@field Domain string
local TAuthenticateReq = {}
TAuthenticateReq.__index = TAuthenticateReq
TAuthenticateReq.group = {}

local function TAuthenticateReq_from_obj(obj)
    return setmetatable(obj, TAuthenticateReq)
end

function TAuthenticateReq.new(UserName, Password, Domain)
    return TAuthenticateReq_from_obj({UserName = UserName, Password = Password, Domain = Domain})
end
---@param obj Authentication.AuthenticateReq
function TAuthenticateReq:init_from_obj(obj)
    self.UserName = obj.UserName
    self.Password = obj.Password
    self.Domain = obj.Domain
end

function TAuthenticateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAuthenticateReq.group)
end

TAuthenticateReq.from_obj = TAuthenticateReq_from_obj

TAuthenticateReq.proto_property = {'UserName', 'Password', 'Domain'}

TAuthenticateReq.default = {'', {}, ''}

TAuthenticateReq.struct = {
    {name = 'UserName', is_array = false, struct = nil}, {name = 'Password', is_array = true, struct = nil},
    {name = 'Domain', is_array = false, struct = nil}
}

function TAuthenticateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UserName', self.UserName, 'string', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Password', self.Password, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Domain', self.Domain, 'string', false, errs, need_convert)

    if self.UserName ~= nil then
        validate.lens(prefix .. 'UserName', self.UserName, 1, 32, errs, need_convert)
    end

    TAuthenticateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAuthenticateReq.proto_property, errs, need_convert)
    return self
end

function TAuthenticateReq:unpack(_)
    return self.UserName, self.Password, self.Domain
end

Authentication.AuthenticateReq = TAuthenticateReq

---@class Authentication.ExtraDataDict
---@field key string
---@field value string
local TExtraDataDict = {}
TExtraDataDict.__index = TExtraDataDict
TExtraDataDict.group = {}

local function TExtraDataDict_from_obj(obj)
    return setmetatable(obj, TExtraDataDict)
end

function TExtraDataDict.new(dict)
    return TExtraDataDict_from_obj(dict)
end

---@param obj Authentication.ExtraDataDict
function TExtraDataDict:init_from_obj(obj)
    self = obj
end

function TExtraDataDict:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExtraDataDict.group)
end

TExtraDataDict.from_obj = TExtraDataDict_from_obj

TExtraDataDict.proto_property = {}

TExtraDataDict.default = {}

TExtraDataDict.struct = {}

function TExtraDataDict:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TExtraDataDict:remove_error_props(errs, self)
    return self
end

function TExtraDataDict:unpack(_)
    return self
end

Authentication.ExtraDataDict = TExtraDataDict

---@class Authentication.AuthenticateRsp
---@field UserId integer
---@field Privileges string[]
---@field RoleId integer
---@field ExtraData Authentication.ExtraDataDict
local TAuthenticateRsp = {}
TAuthenticateRsp.__index = TAuthenticateRsp
TAuthenticateRsp.group = {}

local function TAuthenticateRsp_from_obj(obj)
    return setmetatable(obj, TAuthenticateRsp)
end

function TAuthenticateRsp.new(UserId, Privileges, RoleId, ExtraData)
    return TAuthenticateRsp_from_obj({UserId = UserId, Privileges = Privileges, RoleId = RoleId, ExtraData = ExtraData})
end
---@param obj Authentication.AuthenticateRsp
function TAuthenticateRsp:init_from_obj(obj)
    self.UserId = obj.UserId
    self.Privileges = obj.Privileges
    self.RoleId = obj.RoleId
    self.ExtraData = obj.ExtraData
end

function TAuthenticateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAuthenticateRsp.group)
end

TAuthenticateRsp.from_obj = TAuthenticateRsp_from_obj

TAuthenticateRsp.proto_property = {'UserId', 'Privileges', 'RoleId', 'ExtraData'}

TAuthenticateRsp.default = {0, {}, 0, Authentication.ExtraDataDict.default}

TAuthenticateRsp.struct = {
    {name = 'UserId', is_array = false, struct = nil}, {name = 'Privileges', is_array = true, struct = nil},
    {name = 'RoleId', is_array = false, struct = nil},
    {name = 'ExtraData', is_array = false, struct = Authentication.ExtraDataDict.struct}
}

function TAuthenticateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    Authentication.ExtraDataDict.new(self.ExtraData):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'UserId', self.UserId, 'int32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Privileges', self.Privileges, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'RoleId', self.RoleId, 'uint8', false, errs, need_convert)

    TAuthenticateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAuthenticateRsp.proto_property, errs, need_convert)
    return self
end

function TAuthenticateRsp:unpack(_)
    return self.UserId, self.Privileges, self.RoleId, self.ExtraData
end

Authentication.AuthenticateRsp = TAuthenticateRsp

Authentication.interface = mdb.register_interface('bmc.kepler.AccountService.Authentication', {
    AccountLockoutDuration = {'i', {'EMIT_CHANGE'}, false, 300, false},
    AccountLockoutThreshold = {'i', {'EMIT_CHANGE'}, false, 5, false},
    MaxAccountLockoutDuration = {'i', {}, false, 1800, false},
    MaxAccountLockoutThreshold = {'i', {}, false, 6, false},
    AccountLockoutCounterResetAfter = {'i', {}, false, 300, false},
    LocalAccountAuth = {'s', {}, false, 'LocalFirst', false}
}, {Authenticate = {'a{ss}says', 'iasya{ss}', TAuthenticateReq, TAuthenticateRsp}}, {})

return Authentication
