--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "ipmi_message.lua.mako"
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local UserAuthentication = {}

---@class IamIpmiCmds.UserAuthenticationReq
---@field ManufactureId integer
---@field LoginType integer
---@field UnlockFlag integer
---@field UserName string
---@field PasswordData string
local TUserAuthenticationReq = {}
TUserAuthenticationReq.__index = TUserAuthenticationReq
TUserAuthenticationReq.group = {}

local function TUserAuthenticationReq_from_obj(obj)
    return setmetatable(obj, TUserAuthenticationReq)
end

function TUserAuthenticationReq.new(ManufactureId, LoginType, UnlockFlag, UserName, PasswordData)
    return TUserAuthenticationReq_from_obj({
        ManufactureId = ManufactureId,
        LoginType = LoginType,
        UnlockFlag = UnlockFlag,
        UserName = UserName,
        PasswordData = PasswordData
    })
end
---@param obj IamIpmiCmds.UserAuthenticationReq
function TUserAuthenticationReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.LoginType = obj.LoginType
    self.UnlockFlag = obj.UnlockFlag
    self.UserName = obj.UserName
    self.PasswordData = obj.PasswordData
end

function TUserAuthenticationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUserAuthenticationReq.group)
end

TUserAuthenticationReq.from_obj = TUserAuthenticationReq_from_obj

TUserAuthenticationReq.proto_property = {'ManufactureId', 'LoginType', 'UnlockFlag', 'UserName', 'PasswordData'}

TUserAuthenticationReq.default = {0, 0, 0, '', ''}

TUserAuthenticationReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'LoginType', is_array = false, struct = nil},
    {name = 'UnlockFlag', is_array = false, struct = nil}, {name = 'UserName', is_array = false, struct = nil},
    {name = 'PasswordData', is_array = false, struct = nil}
}

function TUserAuthenticationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'LoginType', self.LoginType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UnlockFlag', self.UnlockFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UserName', self.UserName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'PasswordData', self.PasswordData, 'string', false, errs, need_convert)

    TUserAuthenticationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUserAuthenticationReq.proto_property, errs, need_convert)
    return self
end

function TUserAuthenticationReq:unpack(_)
    return self.ManufactureId, self.LoginType, self.UnlockFlag, self.UserName, self.PasswordData
end

UserAuthentication.UserAuthenticationReq = TUserAuthenticationReq

---@class IamIpmiCmds.UserAuthenticationRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field UserPrivilege integer
---@field PrivilegeMaskReserved integer
local TUserAuthenticationRsp = {}
TUserAuthenticationRsp.__index = TUserAuthenticationRsp
TUserAuthenticationRsp.group = {}

local function TUserAuthenticationRsp_from_obj(obj)
    return setmetatable(obj, TUserAuthenticationRsp)
end

function TUserAuthenticationRsp.new(CompletionCode, ManufactureId, UserPrivilege, PrivilegeMaskReserved)
    return TUserAuthenticationRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        UserPrivilege = UserPrivilege,
        PrivilegeMaskReserved = PrivilegeMaskReserved
    })
end
---@param obj IamIpmiCmds.UserAuthenticationRsp
function TUserAuthenticationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.UserPrivilege = obj.UserPrivilege
    self.PrivilegeMaskReserved = obj.PrivilegeMaskReserved
end

function TUserAuthenticationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUserAuthenticationRsp.group)
end

TUserAuthenticationRsp.from_obj = TUserAuthenticationRsp_from_obj

TUserAuthenticationRsp.proto_property = {'CompletionCode', 'ManufactureId', 'UserPrivilege', 'PrivilegeMaskReserved'}

TUserAuthenticationRsp.default = {0, 0, 0, 0}

TUserAuthenticationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'UserPrivilege', is_array = false, struct = nil},
    {name = 'PrivilegeMaskReserved', is_array = false, struct = nil}
}

function TUserAuthenticationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'UserPrivilege', self.UserPrivilege, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PrivilegeMaskReserved', self.PrivilegeMaskReserved, 'uint32', false, errs, need_convert)

    TUserAuthenticationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUserAuthenticationRsp.proto_property, errs, need_convert)
    return self
end

function TUserAuthenticationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.UserPrivilege, self.PrivilegeMaskReserved
end

UserAuthentication.UserAuthenticationRsp = TUserAuthenticationRsp

return UserAuthentication
