--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "ipmi_message.lua.mako"
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSessionTimeout = {}

---@class IamIpmiCmds.SetSessionTimeoutReq
---@field ManufactureId integer
---@field SessionType integer
---@field Reserved integer
---@field Length integer
---@field SessionTimeout string
local TSetSessionTimeoutReq = {}
TSetSessionTimeoutReq.__index = TSetSessionTimeoutReq
TSetSessionTimeoutReq.group = {}

local function TSetSessionTimeoutReq_from_obj(obj)
    return setmetatable(obj, TSetSessionTimeoutReq)
end

function TSetSessionTimeoutReq.new(ManufactureId, SessionType, Reserved, Length, SessionTimeout)
    return TSetSessionTimeoutReq_from_obj({
        ManufactureId = ManufactureId,
        SessionType = SessionType,
        Reserved = Reserved,
        Length = Length,
        SessionTimeout = SessionTimeout
    })
end
---@param obj IamIpmiCmds.SetSessionTimeoutReq
function TSetSessionTimeoutReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.SessionType = obj.SessionType
    self.Reserved = obj.Reserved
    self.Length = obj.Length
    self.SessionTimeout = obj.SessionTimeout
end

function TSetSessionTimeoutReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSessionTimeoutReq.group)
end

TSetSessionTimeoutReq.from_obj = TSetSessionTimeoutReq_from_obj

TSetSessionTimeoutReq.proto_property = {'ManufactureId', 'SessionType', 'Reserved', 'Length', 'SessionTimeout'}

TSetSessionTimeoutReq.default = {0, 0, 0, 0, ''}

TSetSessionTimeoutReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'SessionType', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'SessionTimeout', is_array = false, struct = nil}
}

function TSetSessionTimeoutReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionType', self.SessionType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionTimeout', self.SessionTimeout, 'string', false, errs, need_convert)

    TSetSessionTimeoutReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSessionTimeoutReq.proto_property, errs, need_convert)
    return self
end

function TSetSessionTimeoutReq:unpack(_)
    return self.ManufactureId, self.SessionType, self.Reserved, self.Length, self.SessionTimeout
end

SetSessionTimeout.SetSessionTimeoutReq = TSetSessionTimeoutReq

---@class IamIpmiCmds.SetSessionTimeoutRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetSessionTimeoutRsp = {}
TSetSessionTimeoutRsp.__index = TSetSessionTimeoutRsp
TSetSessionTimeoutRsp.group = {}

local function TSetSessionTimeoutRsp_from_obj(obj)
    return setmetatable(obj, TSetSessionTimeoutRsp)
end

function TSetSessionTimeoutRsp.new(CompletionCode, ManufactureId)
    return TSetSessionTimeoutRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj IamIpmiCmds.SetSessionTimeoutRsp
function TSetSessionTimeoutRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetSessionTimeoutRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSessionTimeoutRsp.group)
end

TSetSessionTimeoutRsp.from_obj = TSetSessionTimeoutRsp_from_obj

TSetSessionTimeoutRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetSessionTimeoutRsp.default = {0, 0}

TSetSessionTimeoutRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetSessionTimeoutRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetSessionTimeoutRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSessionTimeoutRsp.proto_property, errs, need_convert)
    return self
end

function TSetSessionTimeoutRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetSessionTimeout.SetSessionTimeoutRsp = TSetSessionTimeoutRsp

return SetSessionTimeout
