--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "ipmi_message.lua.mako"
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSessionMode = {}

---@class IamIpmiCmds.SetSessionModeReq
---@field ManufactureId integer
---@field SessionType integer
---@field Reserved integer
---@field Length integer
---@field SessionMode string
local TSetSessionModeReq = {}
TSetSessionModeReq.__index = TSetSessionModeReq
TSetSessionModeReq.group = {}

local function TSetSessionModeReq_from_obj(obj)
    return setmetatable(obj, TSetSessionModeReq)
end

function TSetSessionModeReq.new(ManufactureId, SessionType, Reserved, Length, SessionMode)
    return TSetSessionModeReq_from_obj({
        ManufactureId = ManufactureId,
        SessionType = SessionType,
        Reserved = Reserved,
        Length = Length,
        SessionMode = SessionMode
    })
end
---@param obj IamIpmiCmds.SetSessionModeReq
function TSetSessionModeReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.SessionType = obj.SessionType
    self.Reserved = obj.Reserved
    self.Length = obj.Length
    self.SessionMode = obj.SessionMode
end

function TSetSessionModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSessionModeReq.group)
end

TSetSessionModeReq.from_obj = TSetSessionModeReq_from_obj

TSetSessionModeReq.proto_property = {'ManufactureId', 'SessionType', 'Reserved', 'Length', 'SessionMode'}

TSetSessionModeReq.default = {0, 0, 0, 0, ''}

TSetSessionModeReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'SessionType', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'SessionMode', is_array = false, struct = nil}
}

function TSetSessionModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionType', self.SessionType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SessionMode', self.SessionMode, 'string', false, errs, need_convert)

    TSetSessionModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSessionModeReq.proto_property, errs, need_convert)
    return self
end

function TSetSessionModeReq:unpack(_)
    return self.ManufactureId, self.SessionType, self.Reserved, self.Length, self.SessionMode
end

SetSessionMode.SetSessionModeReq = TSetSessionModeReq

---@class IamIpmiCmds.SetSessionModeRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetSessionModeRsp = {}
TSetSessionModeRsp.__index = TSetSessionModeRsp
TSetSessionModeRsp.group = {}

local function TSetSessionModeRsp_from_obj(obj)
    return setmetatable(obj, TSetSessionModeRsp)
end

function TSetSessionModeRsp.new(CompletionCode, ManufactureId)
    return TSetSessionModeRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj IamIpmiCmds.SetSessionModeRsp
function TSetSessionModeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetSessionModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSessionModeRsp.group)
end

TSetSessionModeRsp.from_obj = TSetSessionModeRsp_from_obj

TSetSessionModeRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetSessionModeRsp.default = {0, 0}

TSetSessionModeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetSessionModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetSessionModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSessionModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetSessionModeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetSessionMode.SetSessionModeRsp = TSetSessionModeRsp

return SetSessionMode
