--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "ipmi_message.lua.mako"
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetLdapConfiguration = {}

---@class IamIpmiCmds.SetLdapConfigurationReq
---@field ManufactureId integer
---@field ControllerId integer
---@field GroupId integer
---@field ParameterSelector integer
---@field Reserved1 integer
---@field Reserved2 integer
---@field Flag integer
---@field Reserved integer
---@field Offset integer
---@field Length integer
---@field Data string
local TSetLdapConfigurationReq = {}
TSetLdapConfigurationReq.__index = TSetLdapConfigurationReq
TSetLdapConfigurationReq.group = {}

local function TSetLdapConfigurationReq_from_obj(obj)
    return setmetatable(obj, TSetLdapConfigurationReq)
end

function TSetLdapConfigurationReq.new(ManufactureId, ControllerId, GroupId, ParameterSelector, Reserved1, Reserved2,
    Flag, Reserved, Offset, Length, Data)
    return TSetLdapConfigurationReq_from_obj({
        ManufactureId = ManufactureId,
        ControllerId = ControllerId,
        GroupId = GroupId,
        ParameterSelector = ParameterSelector,
        Reserved1 = Reserved1,
        Reserved2 = Reserved2,
        Flag = Flag,
        Reserved = Reserved,
        Offset = Offset,
        Length = Length,
        Data = Data
    })
end
---@param obj IamIpmiCmds.SetLdapConfigurationReq
function TSetLdapConfigurationReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.ControllerId = obj.ControllerId
    self.GroupId = obj.GroupId
    self.ParameterSelector = obj.ParameterSelector
    self.Reserved1 = obj.Reserved1
    self.Reserved2 = obj.Reserved2
    self.Flag = obj.Flag
    self.Reserved = obj.Reserved
    self.Offset = obj.Offset
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetLdapConfigurationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLdapConfigurationReq.group)
end

TSetLdapConfigurationReq.from_obj = TSetLdapConfigurationReq_from_obj

TSetLdapConfigurationReq.proto_property = {
    'ManufactureId', 'ControllerId', 'GroupId', 'ParameterSelector', 'Reserved1', 'Reserved2', 'Flag', 'Reserved',
    'Offset', 'Length', 'Data'
}

TSetLdapConfigurationReq.default = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ''}

TSetLdapConfigurationReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'ControllerId', is_array = false, struct = nil},
    {name = 'GroupId', is_array = false, struct = nil}, {name = 'ParameterSelector', is_array = false, struct = nil},
    {name = 'Reserved1', is_array = false, struct = nil}, {name = 'Reserved2', is_array = false, struct = nil},
    {name = 'Flag', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TSetLdapConfigurationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'GroupId', self.GroupId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ParameterSelector', self.ParameterSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved1', self.Reserved1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved2', self.Reserved2, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Flag', self.Flag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLdapConfigurationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLdapConfigurationReq.proto_property, errs, need_convert)
    return self
end

function TSetLdapConfigurationReq:unpack(_)
    return self.ManufactureId, self.ControllerId, self.GroupId, self.ParameterSelector, self.Reserved1, self.Reserved2,
        self.Flag, self.Reserved, self.Offset, self.Length, self.Data
end

SetLdapConfiguration.SetLdapConfigurationReq = TSetLdapConfigurationReq

---@class IamIpmiCmds.SetLdapConfigurationRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetLdapConfigurationRsp = {}
TSetLdapConfigurationRsp.__index = TSetLdapConfigurationRsp
TSetLdapConfigurationRsp.group = {}

local function TSetLdapConfigurationRsp_from_obj(obj)
    return setmetatable(obj, TSetLdapConfigurationRsp)
end

function TSetLdapConfigurationRsp.new(CompletionCode, ManufactureId)
    return TSetLdapConfigurationRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj IamIpmiCmds.SetLdapConfigurationRsp
function TSetLdapConfigurationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetLdapConfigurationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLdapConfigurationRsp.group)
end

TSetLdapConfigurationRsp.from_obj = TSetLdapConfigurationRsp_from_obj

TSetLdapConfigurationRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetLdapConfigurationRsp.default = {0, 0}

TSetLdapConfigurationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetLdapConfigurationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetLdapConfigurationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLdapConfigurationRsp.proto_property, errs, need_convert)
    return self
end

function TSetLdapConfigurationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetLdapConfiguration.SetLdapConfigurationRsp = TSetLdapConfigurationRsp

return SetLdapConfiguration
