--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "ipmi_message.lua.mako"
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetRemoteGroupConfiguration = {}

---@class IamIpmiCmds.GetRemoteGroupConfigurationReq
---@field ManufactureId integer
---@field GroupId integer
---@field ConfigurationType integer
---@field Offset integer
---@field Length integer
local TGetRemoteGroupConfigurationReq = {}
TGetRemoteGroupConfigurationReq.__index = TGetRemoteGroupConfigurationReq
TGetRemoteGroupConfigurationReq.group = {}

local function TGetRemoteGroupConfigurationReq_from_obj(obj)
    return setmetatable(obj, TGetRemoteGroupConfigurationReq)
end

function TGetRemoteGroupConfigurationReq.new(ManufactureId, GroupId, ConfigurationType, Offset, Length)
    return TGetRemoteGroupConfigurationReq_from_obj({
        ManufactureId = ManufactureId,
        GroupId = GroupId,
        ConfigurationType = ConfigurationType,
        Offset = Offset,
        Length = Length
    })
end
---@param obj IamIpmiCmds.GetRemoteGroupConfigurationReq
function TGetRemoteGroupConfigurationReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.GroupId = obj.GroupId
    self.ConfigurationType = obj.ConfigurationType
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetRemoteGroupConfigurationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetRemoteGroupConfigurationReq.group)
end

TGetRemoteGroupConfigurationReq.from_obj = TGetRemoteGroupConfigurationReq_from_obj

TGetRemoteGroupConfigurationReq.proto_property = {'ManufactureId', 'GroupId', 'ConfigurationType', 'Offset', 'Length'}

TGetRemoteGroupConfigurationReq.default = {0, 0, 0, 0, 0}

TGetRemoteGroupConfigurationReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'GroupId', is_array = false, struct = nil},
    {name = 'ConfigurationType', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetRemoteGroupConfigurationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'GroupId', self.GroupId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ConfigurationType', self.ConfigurationType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetRemoteGroupConfigurationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetRemoteGroupConfigurationReq.proto_property, errs, need_convert)
    return self
end

function TGetRemoteGroupConfigurationReq:unpack(_)
    return self.ManufactureId, self.GroupId, self.ConfigurationType, self.Offset, self.Length
end

GetRemoteGroupConfiguration.GetRemoteGroupConfigurationReq = TGetRemoteGroupConfigurationReq

---@class IamIpmiCmds.GetRemoteGroupConfigurationRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Reserved integer
---@field Data string
local TGetRemoteGroupConfigurationRsp = {}
TGetRemoteGroupConfigurationRsp.__index = TGetRemoteGroupConfigurationRsp
TGetRemoteGroupConfigurationRsp.group = {}

local function TGetRemoteGroupConfigurationRsp_from_obj(obj)
    return setmetatable(obj, TGetRemoteGroupConfigurationRsp)
end

function TGetRemoteGroupConfigurationRsp.new(CompletionCode, ManufactureId, EndOfList, Reserved, Data)
    return TGetRemoteGroupConfigurationRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Reserved = Reserved,
        Data = Data
    })
end
---@param obj IamIpmiCmds.GetRemoteGroupConfigurationRsp
function TGetRemoteGroupConfigurationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Reserved = obj.Reserved
    self.Data = obj.Data
end

function TGetRemoteGroupConfigurationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetRemoteGroupConfigurationRsp.group)
end

TGetRemoteGroupConfigurationRsp.from_obj = TGetRemoteGroupConfigurationRsp_from_obj

TGetRemoteGroupConfigurationRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Reserved', 'Data'}

TGetRemoteGroupConfigurationRsp.default = {0, 0, 0, 0, ''}

TGetRemoteGroupConfigurationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetRemoteGroupConfigurationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetRemoteGroupConfigurationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetRemoteGroupConfigurationRsp.proto_property, errs, need_convert)
    return self
end

function TGetRemoteGroupConfigurationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Reserved, self.Data
end

GetRemoteGroupConfiguration.GetRemoteGroupConfigurationRsp = TGetRemoteGroupConfigurationRsp

return GetRemoteGroupConfiguration
