--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "ipmi_message.lua.mako"
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetLdapHostAddr = {}

---@class IamIpmiCmds.GetLdapHostAddrReq
---@field ManufactureId integer
---@field Offset integer
---@field Length integer
local TGetLdapHostAddrReq = {}
TGetLdapHostAddrReq.__index = TGetLdapHostAddrReq
TGetLdapHostAddrReq.group = {}

local function TGetLdapHostAddrReq_from_obj(obj)
    return setmetatable(obj, TGetLdapHostAddrReq)
end

function TGetLdapHostAddrReq.new(ManufactureId, Offset, Length)
    return TGetLdapHostAddrReq_from_obj({ManufactureId = ManufactureId, Offset = Offset, Length = Length})
end
---@param obj IamIpmiCmds.GetLdapHostAddrReq
function TGetLdapHostAddrReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetLdapHostAddrReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLdapHostAddrReq.group)
end

TGetLdapHostAddrReq.from_obj = TGetLdapHostAddrReq_from_obj

TGetLdapHostAddrReq.proto_property = {'ManufactureId', 'Offset', 'Length'}

TGetLdapHostAddrReq.default = {0, 0, 0}

TGetLdapHostAddrReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetLdapHostAddrReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetLdapHostAddrReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLdapHostAddrReq.proto_property, errs, need_convert)
    return self
end

function TGetLdapHostAddrReq:unpack(_)
    return self.ManufactureId, self.Offset, self.Length
end

GetLdapHostAddr.GetLdapHostAddrReq = TGetLdapHostAddrReq

---@class IamIpmiCmds.GetLdapHostAddrRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Reserved integer
---@field Data string
local TGetLdapHostAddrRsp = {}
TGetLdapHostAddrRsp.__index = TGetLdapHostAddrRsp
TGetLdapHostAddrRsp.group = {}

local function TGetLdapHostAddrRsp_from_obj(obj)
    return setmetatable(obj, TGetLdapHostAddrRsp)
end

function TGetLdapHostAddrRsp.new(CompletionCode, ManufactureId, EndOfList, Reserved, Data)
    return TGetLdapHostAddrRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Reserved = Reserved,
        Data = Data
    })
end
---@param obj IamIpmiCmds.GetLdapHostAddrRsp
function TGetLdapHostAddrRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Reserved = obj.Reserved
    self.Data = obj.Data
end

function TGetLdapHostAddrRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLdapHostAddrRsp.group)
end

TGetLdapHostAddrRsp.from_obj = TGetLdapHostAddrRsp_from_obj

TGetLdapHostAddrRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Reserved', 'Data'}

TGetLdapHostAddrRsp.default = {0, 0, 0, 0, ''}

TGetLdapHostAddrRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetLdapHostAddrRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetLdapHostAddrRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLdapHostAddrRsp.proto_property, errs, need_convert)
    return self
end

function TGetLdapHostAddrRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Reserved, self.Data
end

GetLdapHostAddr.GetLdapHostAddrRsp = TGetLdapHostAddrRsp

return GetLdapHostAddr
