--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "ipmi_message.lua.mako"
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetLdapDomain = {}

---@class IamIpmiCmds.GetLdapDomainReq
---@field ManufactureId integer
---@field Offset integer
---@field Length integer
local TGetLdapDomainReq = {}
TGetLdapDomainReq.__index = TGetLdapDomainReq
TGetLdapDomainReq.group = {}

local function TGetLdapDomainReq_from_obj(obj)
    return setmetatable(obj, TGetLdapDomainReq)
end

function TGetLdapDomainReq.new(ManufactureId, Offset, Length)
    return TGetLdapDomainReq_from_obj({ManufactureId = ManufactureId, Offset = Offset, Length = Length})
end
---@param obj IamIpmiCmds.GetLdapDomainReq
function TGetLdapDomainReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetLdapDomainReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLdapDomainReq.group)
end

TGetLdapDomainReq.from_obj = TGetLdapDomainReq_from_obj

TGetLdapDomainReq.proto_property = {'ManufactureId', 'Offset', 'Length'}

TGetLdapDomainReq.default = {0, 0, 0}

TGetLdapDomainReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetLdapDomainReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetLdapDomainReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLdapDomainReq.proto_property, errs, need_convert)
    return self
end

function TGetLdapDomainReq:unpack(_)
    return self.ManufactureId, self.Offset, self.Length
end

GetLdapDomain.GetLdapDomainReq = TGetLdapDomainReq

---@class IamIpmiCmds.GetLdapDomainRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Reserved integer
---@field Data string
local TGetLdapDomainRsp = {}
TGetLdapDomainRsp.__index = TGetLdapDomainRsp
TGetLdapDomainRsp.group = {}

local function TGetLdapDomainRsp_from_obj(obj)
    return setmetatable(obj, TGetLdapDomainRsp)
end

function TGetLdapDomainRsp.new(CompletionCode, ManufactureId, EndOfList, Reserved, Data)
    return TGetLdapDomainRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Reserved = Reserved,
        Data = Data
    })
end
---@param obj IamIpmiCmds.GetLdapDomainRsp
function TGetLdapDomainRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Reserved = obj.Reserved
    self.Data = obj.Data
end

function TGetLdapDomainRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLdapDomainRsp.group)
end

TGetLdapDomainRsp.from_obj = TGetLdapDomainRsp_from_obj

TGetLdapDomainRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Reserved', 'Data'}

TGetLdapDomainRsp.default = {0, 0, 0, 0, ''}

TGetLdapDomainRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetLdapDomainRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetLdapDomainRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLdapDomainRsp.proto_property, errs, need_convert)
    return self
end

function TGetLdapDomainRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Reserved, self.Data
end

GetLdapDomain.GetLdapDomainRsp = TGetLdapDomainRsp

return GetLdapDomain
