--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "ipmi_message.lua.mako"
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetLdapConfiguration = {}

---@class IamIpmiCmds.GetLdapConfigurationReq
---@field ManufactureId integer
---@field ControllerId integer
---@field GroupId integer
---@field ParameterSelector integer
---@field Offset integer
---@field Length integer
local TGetLdapConfigurationReq = {}
TGetLdapConfigurationReq.__index = TGetLdapConfigurationReq
TGetLdapConfigurationReq.group = {}

local function TGetLdapConfigurationReq_from_obj(obj)
    return setmetatable(obj, TGetLdapConfigurationReq)
end

function TGetLdapConfigurationReq.new(ManufactureId, ControllerId, GroupId, ParameterSelector, Offset, Length)
    return TGetLdapConfigurationReq_from_obj({
        ManufactureId = ManufactureId,
        ControllerId = ControllerId,
        GroupId = GroupId,
        ParameterSelector = ParameterSelector,
        Offset = Offset,
        Length = Length
    })
end
---@param obj IamIpmiCmds.GetLdapConfigurationReq
function TGetLdapConfigurationReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.ControllerId = obj.ControllerId
    self.GroupId = obj.GroupId
    self.ParameterSelector = obj.ParameterSelector
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetLdapConfigurationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLdapConfigurationReq.group)
end

TGetLdapConfigurationReq.from_obj = TGetLdapConfigurationReq_from_obj

TGetLdapConfigurationReq.proto_property = {
    'ManufactureId', 'ControllerId', 'GroupId', 'ParameterSelector', 'Offset', 'Length'
}

TGetLdapConfigurationReq.default = {0, 0, 0, 0, 0, 0}

TGetLdapConfigurationReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'ControllerId', is_array = false, struct = nil},
    {name = 'GroupId', is_array = false, struct = nil}, {name = 'ParameterSelector', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TGetLdapConfigurationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'GroupId', self.GroupId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ParameterSelector', self.ParameterSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetLdapConfigurationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLdapConfigurationReq.proto_property, errs, need_convert)
    return self
end

function TGetLdapConfigurationReq:unpack(_)
    return self.ManufactureId, self.ControllerId, self.GroupId, self.ParameterSelector, self.Offset, self.Length
end

GetLdapConfiguration.GetLdapConfigurationReq = TGetLdapConfigurationReq

---@class IamIpmiCmds.GetLdapConfigurationRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Reserved integer
---@field Data string
local TGetLdapConfigurationRsp = {}
TGetLdapConfigurationRsp.__index = TGetLdapConfigurationRsp
TGetLdapConfigurationRsp.group = {}

local function TGetLdapConfigurationRsp_from_obj(obj)
    return setmetatable(obj, TGetLdapConfigurationRsp)
end

function TGetLdapConfigurationRsp.new(CompletionCode, ManufactureId, EndOfList, Reserved, Data)
    return TGetLdapConfigurationRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Reserved = Reserved,
        Data = Data
    })
end
---@param obj IamIpmiCmds.GetLdapConfigurationRsp
function TGetLdapConfigurationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Reserved = obj.Reserved
    self.Data = obj.Data
end

function TGetLdapConfigurationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLdapConfigurationRsp.group)
end

TGetLdapConfigurationRsp.from_obj = TGetLdapConfigurationRsp_from_obj

TGetLdapConfigurationRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Reserved', 'Data'}

TGetLdapConfigurationRsp.default = {0, 0, 0, 0, ''}

TGetLdapConfigurationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetLdapConfigurationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetLdapConfigurationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLdapConfigurationRsp.proto_property, errs, need_convert)
    return self
end

function TGetLdapConfigurationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Reserved, self.Data
end

GetLdapConfiguration.GetLdapConfigurationRsp = TGetLdapConfigurationRsp

return GetLdapConfiguration
