-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MLDAPController = {}

---@class MLDAPController.CRLVerificationEnable
---@field CRLVerificationEnable boolean
local TCRLVerificationEnable = {}
TCRLVerificationEnable.__index = TCRLVerificationEnable
TCRLVerificationEnable.group = {}

local function TCRLVerificationEnable_from_obj(obj)
    return setmetatable(obj, TCRLVerificationEnable)
end

function TCRLVerificationEnable.new(CRLVerificationEnable)
    return TCRLVerificationEnable_from_obj({CRLVerificationEnable = CRLVerificationEnable or false})
end
---@param obj MLDAPController.CRLVerificationEnable
function TCRLVerificationEnable:init_from_obj(obj)
    self.CRLVerificationEnable = obj.CRLVerificationEnable or false
end

function TCRLVerificationEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCRLVerificationEnable.group)
end

TCRLVerificationEnable.from_obj = TCRLVerificationEnable_from_obj

TCRLVerificationEnable.proto_property = {'CRLVerificationEnable'}

TCRLVerificationEnable.default = {false}

TCRLVerificationEnable.struct = {{name = 'CRLVerificationEnable', is_array = false, struct = nil}}

function TCRLVerificationEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CRLVerificationEnable', self.CRLVerificationEnable, 'bool', false, errs, need_convert)

    TCRLVerificationEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCRLVerificationEnable.proto_property, errs, need_convert)
    return self
end

function TCRLVerificationEnable:unpack(_)
    return self.CRLVerificationEnable
end

MLDAPController.CRLVerificationEnable = TCRLVerificationEnable

---@class MLDAPController.BindTimeLimit
---@field BindTimeLimit integer
local TBindTimeLimit = {}
TBindTimeLimit.__index = TBindTimeLimit
TBindTimeLimit.group = {}

local function TBindTimeLimit_from_obj(obj)
    return setmetatable(obj, TBindTimeLimit)
end

function TBindTimeLimit.new(BindTimeLimit)
    return TBindTimeLimit_from_obj({BindTimeLimit = BindTimeLimit or 2})
end
---@param obj MLDAPController.BindTimeLimit
function TBindTimeLimit:init_from_obj(obj)
    self.BindTimeLimit = obj.BindTimeLimit or 2
end

function TBindTimeLimit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBindTimeLimit.group)
end

TBindTimeLimit.from_obj = TBindTimeLimit_from_obj

TBindTimeLimit.proto_property = {'BindTimeLimit'}

TBindTimeLimit.default = {0}

TBindTimeLimit.struct = {{name = 'BindTimeLimit', is_array = false, struct = nil}}

function TBindTimeLimit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BindTimeLimit', self.BindTimeLimit, 'int32', false, errs, need_convert)

    TBindTimeLimit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBindTimeLimit.proto_property, errs, need_convert)
    return self
end

function TBindTimeLimit:unpack(_)
    return self.BindTimeLimit
end

MLDAPController.BindTimeLimit = TBindTimeLimit

---@class MLDAPController.TimeLimit
---@field TimeLimit integer
local TTimeLimit = {}
TTimeLimit.__index = TTimeLimit
TTimeLimit.group = {}

local function TTimeLimit_from_obj(obj)
    return setmetatable(obj, TTimeLimit)
end

function TTimeLimit.new(TimeLimit)
    return TTimeLimit_from_obj({TimeLimit = TimeLimit or 2})
end
---@param obj MLDAPController.TimeLimit
function TTimeLimit:init_from_obj(obj)
    self.TimeLimit = obj.TimeLimit or 2
end

function TTimeLimit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTimeLimit.group)
end

TTimeLimit.from_obj = TTimeLimit_from_obj

TTimeLimit.proto_property = {'TimeLimit'}

TTimeLimit.default = {0}

TTimeLimit.struct = {{name = 'TimeLimit', is_array = false, struct = nil}}

function TTimeLimit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TimeLimit', self.TimeLimit, 'int32', false, errs, need_convert)

    TTimeLimit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTimeLimit.proto_property, errs, need_convert)
    return self
end

function TTimeLimit:unpack(_)
    return self.TimeLimit
end

MLDAPController.TimeLimit = TTimeLimit

---@class MLDAPController.Scope
---@field Scope string
local TScope = {}
TScope.__index = TScope
TScope.group = {}

local function TScope_from_obj(obj)
    return setmetatable(obj, TScope)
end

function TScope.new(Scope)
    return TScope_from_obj({Scope = Scope or [=[sub]=]})
end
---@param obj MLDAPController.Scope
function TScope:init_from_obj(obj)
    self.Scope = obj.Scope or [=[sub]=]
end

function TScope:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TScope.group)
end

TScope.from_obj = TScope_from_obj

TScope.proto_property = {'Scope'}

TScope.default = {''}

TScope.struct = {{name = 'Scope', is_array = false, struct = nil}}

function TScope:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Scope', self.Scope, 'string', false, errs, need_convert)

    TScope:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TScope.proto_property, errs, need_convert)
    return self
end

function TScope:unpack(_)
    return self.Scope
end

MLDAPController.Scope = TScope

---@class MLDAPController.BindDNPsw
---@field BindDNPsw string
local TBindDNPsw = {}
TBindDNPsw.__index = TBindDNPsw
TBindDNPsw.group = {}

local function TBindDNPsw_from_obj(obj)
    return setmetatable(obj, TBindDNPsw)
end

function TBindDNPsw.new(BindDNPsw)
    return TBindDNPsw_from_obj({BindDNPsw = BindDNPsw})
end
---@param obj MLDAPController.BindDNPsw
function TBindDNPsw:init_from_obj(obj)
    self.BindDNPsw = obj.BindDNPsw
end

function TBindDNPsw:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBindDNPsw.group)
end

TBindDNPsw.from_obj = TBindDNPsw_from_obj

TBindDNPsw.proto_property = {'BindDNPsw'}

TBindDNPsw.default = {''}

TBindDNPsw.struct = {{name = 'BindDNPsw', is_array = false, struct = nil}}

function TBindDNPsw:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'BindDNPsw', self.BindDNPsw, 'string', false, errs, need_convert)

    TBindDNPsw:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBindDNPsw.proto_property, errs, need_convert)
    return self
end

function TBindDNPsw:unpack(_)
    return self.BindDNPsw
end

MLDAPController.BindDNPsw = TBindDNPsw

---@class MLDAPController.BaseDN
---@field BaseDN string
local TBaseDN = {}
TBaseDN.__index = TBaseDN
TBaseDN.group = {}

local function TBaseDN_from_obj(obj)
    return setmetatable(obj, TBaseDN)
end

function TBaseDN.new(BaseDN)
    return TBaseDN_from_obj({BaseDN = BaseDN})
end
---@param obj MLDAPController.BaseDN
function TBaseDN:init_from_obj(obj)
    self.BaseDN = obj.BaseDN
end

function TBaseDN:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBaseDN.group)
end

TBaseDN.from_obj = TBaseDN_from_obj

TBaseDN.proto_property = {'BaseDN'}

TBaseDN.default = {''}

TBaseDN.struct = {{name = 'BaseDN', is_array = false, struct = nil}}

function TBaseDN:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'BaseDN', self.BaseDN, 'string', false, errs, need_convert)

    TBaseDN:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBaseDN.proto_property, errs, need_convert)
    return self
end

function TBaseDN:unpack(_)
    return self.BaseDN
end

MLDAPController.BaseDN = TBaseDN

---@class MLDAPController.LdapVer
---@field LdapVer integer
local TLdapVer = {}
TLdapVer.__index = TLdapVer
TLdapVer.group = {}

local function TLdapVer_from_obj(obj)
    return setmetatable(obj, TLdapVer)
end

function TLdapVer.new(LdapVer)
    return TLdapVer_from_obj({LdapVer = LdapVer or 3})
end
---@param obj MLDAPController.LdapVer
function TLdapVer:init_from_obj(obj)
    self.LdapVer = obj.LdapVer or 3
end

function TLdapVer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLdapVer.group)
end

TLdapVer.from_obj = TLdapVer_from_obj

TLdapVer.proto_property = {'LdapVer'}

TLdapVer.default = {0}

TLdapVer.struct = {{name = 'LdapVer', is_array = false, struct = nil}}

function TLdapVer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LdapVer', self.LdapVer, 'uint8', false, errs, need_convert)

    TLdapVer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLdapVer.proto_property, errs, need_convert)
    return self
end

function TLdapVer:unpack(_)
    return self.LdapVer
end

MLDAPController.LdapVer = TLdapVer

---@class MLDAPController.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MLDAPController.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint32', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MLDAPController.Id = TId

return MLDAPController
