-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-8-21
-- Description: DO NOT EDIT; Code generated by "model.lua.mako"
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local session_service_class_types = require 'class.types.SessionService'
local authentication_class_types = require 'class.types.Authentication'
local sessions_class_types = require 'class.types.Sessions'
local ldap_class_types = require 'class.types.LDAP'
local ldap_controller_class_types = require 'class.types.LDAPController'
local kerberos_class_types = require 'class.types.Kerberos'
local remote_groups_db_class_types = require 'class.types.RemoteGroupsDB'
local remote_group_class_types = require 'class.types.RemoteGroup'
local certificate_authentication_class_types = require 'class.types.CertificateAuthentication'
local session_service_intf_types = require 'iam.json_types.SessionService'
local properties_intf_types = require 'iam.json_types.Properties'
local session_intf_types = require 'iam.json_types.Session'
local authentication_intf_types = require 'iam.json_types.Authentication'
local rmcp_intf_types = require 'iam.json_types.RMCP'
local sessions_intf_types = require 'iam.json_types.Sessions'
local ldap_intf_types = require 'iam.json_types.LDAP'
local ldap_controller_intf_types = require 'iam.json_types.LDAPController'
local kerberos_intf_types = require 'iam.json_types.Kerberos'
local remote_groups_intf_types = require 'iam.json_types.RemoteGroups'
local remote_group_intf_types = require 'iam.json_types.RemoteGroup'
local certificate_authentication_intf_types = require 'iam.json_types.CertificateAuthentication'

local SessionService = {
    ['table_name'] = 't_session_service',
    ['prop_configs'] = {
        ['SessionType'] = {
            ['baseType'] = 'Enum',
            ['$ref'] = 'types.json#/defs/SessionType',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = session_service_class_types.SessionType
        },
        ['SessionModeDB'] = {
            ['baseType'] = 'Enum',
            ['$ref'] = 'types.json#/defs/OccupationMode',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = session_service_class_types.SessionModeDB
        }
    },
    ['default_props'] = {
        ['SessionType'] = session_service_class_types.SessionType.default[1]:value(),
        ['SessionModeDB'] = session_service_class_types.SessionModeDB.default[1]:value()
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.SessionService'] = {
            ['SessionTimeout'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = session_service_intf_types.SessionTimeout
            },
            ['SessionMode'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 1,
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = session_service_intf_types.SessionMode
            },
            ['SessionMaxCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = session_service_intf_types.SessionMaxCount
            },
            ['ServiceEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = session_service_intf_types.ServiceEnabled
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/SessionService/:SessionType'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.SessionService'] = {
            ['property_defaults'] = {
                ['SessionTimeout'] = session_service_intf_types.SessionTimeout.default[1],
                ['SessionMode'] = 1,
                ['SessionMaxCount'] = session_service_intf_types.SessionMaxCount.default[1],
                ['ServiceEnabled'] = true
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['SessionTimeout'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting},
                    ['SessionMode'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting},
                    ['SessionMaxCount'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting},
                    ['ServiceEnabled'] = {['read'] = privilege.ReadOnly}
                }
            },
            ['interface_types'] = session_service_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Session = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.SessionService.Session'] = {
            ['ClientOriginIPAddress'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.ClientOriginIPAddress
            },
            ['CreatedTime'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.CreatedTime
            },
            ['SessionId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.SessionId
            },
            ['OemSessionType'] = {
                ['baseType'] = 'S8',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.OemSessionType
            },
            ['AccountPassword'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.AccountPassword
            },
            ['SessionType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.SessionType
            },
            ['UserName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.UserName
            },
            ['LastLoginIp'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.LastLoginIp
            },
            ['LastLoginTime'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.LastLoginTime
            },
            ['AuthType'] = {
                ['baseType'] = 'S8',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.AuthType
            },
            ['Role'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.Role
            },
            ['Privileges'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.Privileges
            },
            ['AccountId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.AccountId
            },
            ['BrowserType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'UserMgmt'}},
                ['validator'] = session_intf_types.BrowserType
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.SessionService.Session'] = {
            ['SessionDelete'] = {
                ['initiator'] = true,
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'LogoutType'}},
                ['rsp'] = {},
                ['privilege'] = {'ConfigureSelf'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/SessionService/Sessions/:SessionId'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.SessionService.Session'] = {
            ['property_defaults'] = {
                ['ClientOriginIPAddress'] = session_intf_types.ClientOriginIPAddress.default[1],
                ['CreatedTime'] = session_intf_types.CreatedTime.default[1],
                ['SessionId'] = session_intf_types.SessionId.default[1],
                ['OemSessionType'] = session_intf_types.OemSessionType.default[1],
                ['AccountPassword'] = session_intf_types.AccountPassword.default[1],
                ['SessionType'] = session_intf_types.SessionType.default[1],
                ['UserName'] = session_intf_types.UserName.default[1],
                ['LastLoginIp'] = session_intf_types.LastLoginIp.default[1],
                ['LastLoginTime'] = session_intf_types.LastLoginTime.default[1],
                ['AuthType'] = session_intf_types.AuthType.default[1],
                ['Role'] = session_intf_types.Role.default[1],
                ['Privileges'] = session_intf_types.Privileges.default[1],
                ['AccountId'] = session_intf_types.AccountId.default[1],
                ['BrowserType'] = session_intf_types.BrowserType.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ConfigureSelf,
                ['props'] = {
                    ['ClientOriginIPAddress'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt},
                    ['CreatedTime'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt},
                    ['SessionId'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt},
                    ['OemSessionType'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt},
                    ['AccountPassword'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt},
                    ['SessionType'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt},
                    ['UserName'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt},
                    ['LastLoginIp'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt},
                    ['LastLoginTime'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt},
                    ['AuthType'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt},
                    ['Role'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt},
                    ['Privileges'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt},
                    ['AccountId'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt},
                    ['BrowserType'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.UserMgmt}
                },
                ['methods'] = {['SessionDelete'] = privilege.ConfigureSelf}
            },
            ['interface_types'] = session_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Authentication = {
    ['table_name'] = 't_authentication',
    ['prop_configs'] = {
        ['DoubleCertificationEnable'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = authentication_class_types.DoubleCertificationEnable
        },
        ['CertificateAuthenticationEnable'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = authentication_class_types.CertificateAuthenticationEnable
        },
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = authentication_class_types.Id
        }
    },
    ['default_props'] = {
        ['DoubleCertificationEnable'] = false,
        ['CertificateAuthenticationEnable'] = false,
        ['Id'] = authentication_class_types.Id.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.Authentication'] = {
            ['AccountLockoutDuration'] = {
                ['baseType'] = 'S32',
                ['readOnly'] = false,
                ['default'] = 300,
                ['minimum'] = 60,
                ['maximum'] = 86400,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'SecurityMgmt'}},
                ['validator'] = authentication_intf_types.AccountLockoutDuration
            },
            ['AccountLockoutThreshold'] = {
                ['baseType'] = 'S32',
                ['readOnly'] = false,
                ['default'] = 5,
                ['minimum'] = 0,
                ['maximum'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'SecurityMgmt'}},
                ['validator'] = authentication_intf_types.AccountLockoutThreshold
            },
            ['MaxAccountLockoutDuration'] = {
                ['baseType'] = 'S32',
                ['readOnly'] = false,
                ['default'] = 1800,
                ['minimum'] = 1800,
                ['maximum'] = 86400,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'TemporaryPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'SecurityMgmt'}},
                ['validator'] = authentication_intf_types.MaxAccountLockoutDuration
            },
            ['MaxAccountLockoutThreshold'] = {
                ['baseType'] = 'S32',
                ['readOnly'] = false,
                ['default'] = 6,
                ['minimum'] = 6,
                ['maximum'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'TemporaryPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'SecurityMgmt'}},
                ['validator'] = authentication_intf_types.MaxAccountLockoutThreshold
            },
            ['AccountLockoutCounterResetAfter'] = {
                ['baseType'] = 'S32',
                ['readOnly'] = false,
                ['default'] = 300,
                ['minimum'] = 0,
                ['maximum'] = 1800,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'SecurityMgmt'}},
                ['validator'] = authentication_intf_types.AccountLockoutCounterResetAfter
            },
            ['LocalAccountAuth'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['default'] = 'LocalFirst',
                ['enum'] = {'Disabled', 'Enabled', 'Fallback', 'LocalFirst'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'SecurityMgmt'}},
                ['validator'] = authentication_intf_types.LocalAccountAuth
            }
        },
        ['bmc.kepler.AccountService.Authentication.RMCP'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.AccountService.Authentication'] = {
            ['Authenticate'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'String', ['maxLength'] = 32, ['minLength'] = 1, ['param'] = 'UserName'},
                    {['baseType'] = 'U8[]', ['param'] = 'Password'}, {['baseType'] = 'String', ['param'] = 'Domain'}
                },
                ['rsp'] = {
                    {['baseType'] = 'S32', ['param'] = 'UserId'}, {['baseType'] = 'String[]', ['param'] = 'Privileges'},
                    {['baseType'] = 'U8', ['param'] = 'RoleId'},
                    {['baseType'] = 'Dictionary', ['$ref'] = '#/defs/ExtraDataDict', ['param'] = 'ExtraData'}
                }
            }
        },
        ['bmc.kepler.AccountService.Authentication.RMCP'] = {
            ['GenRakp2AuthCode'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'AuthAlgo'},
                    {['baseType'] = 'String', ['maxLength'] = 32, ['minLength'] = 1, ['param'] = 'UserName'},
                    {['baseType'] = 'U32', ['param'] = 'ConsoleSid'}, {['baseType'] = 'U32', ['param'] = 'ManagedSid'},
                    {['baseType'] = 'U8[]', ['maxLength'] = 16, ['minLength'] = 16, ['param'] = 'ConsoleRandom'},
                    {['baseType'] = 'U8[]', ['maxLength'] = 16, ['minLength'] = 16, ['param'] = 'ManagedRandom'},
                    {['baseType'] = 'U8[]', ['maxLength'] = 16, ['minLength'] = 16, ['param'] = 'ManagedGuid'},
                    {['baseType'] = 'U8', ['param'] = 'Role'}, {['baseType'] = 'String', ['param'] = 'Ip'}
                },
                ['rsp'] = {{['baseType'] = 'U8[]', ['param'] = 'AuthCode'}}
            },
            ['AuthRakp3'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'AuthAlgo'}, {['baseType'] = 'String', ['param'] = 'UserName'},
                    {['baseType'] = 'U8[]', ['maxLength'] = 16, ['minLength'] = 16, ['param'] = 'ManagedRandom'},
                    {['baseType'] = 'U32', ['param'] = 'ConsoleSid'}, {['baseType'] = 'U8', ['param'] = 'Role'},
                    {['baseType'] = 'U8[]', ['param'] = 'AuthCode'}, {['baseType'] = 'String', ['param'] = 'Ip'}
                },
                ['rsp'] = {}
            },
            ['GenSik'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'AuthAlgo'},
                    {['baseType'] = 'String', ['maxLength'] = 32, ['minLength'] = 1, ['param'] = 'UserName'},
                    {['baseType'] = 'U8[]', ['maxLength'] = 16, ['minLength'] = 16, ['param'] = 'ConsoleRandom'},
                    {['baseType'] = 'U8[]', ['maxLength'] = 16, ['minLength'] = 16, ['param'] = 'ManagedRandom'},
                    {['baseType'] = 'U8', ['param'] = 'Role'}, {['baseType'] = 'String', ['param'] = 'Ip'}
                },
                ['rsp'] = {{['baseType'] = 'U8[]', ['param'] = 'AuthCode'}}
            },
            ['GenRmcpAuthCode'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'AuthAlgo'},
                    {['baseType'] = 'U8[]', ['maxLength'] = 255, ['minLength'] = 1, ['param'] = 'PayLoad'},
                    {['baseType'] = 'U8', ['param'] = 'UserId'}, {['baseType'] = 'U32', ['param'] = 'SessionId'},
                    {['baseType'] = 'U32', ['param'] = 'SessionSequence'}, {['baseType'] = 'String', ['param'] = 'Ip'}
                },
                ['rsp'] = {{['baseType'] = 'U8[]', ['param'] = 'AuthCode'}}
            },
            ['CheckRmcpAuthCode'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'U8[]', ['param'] = 'AuthCode'}, {['baseType'] = 'U8', ['param'] = 'AuthAlgo'},
                    {['baseType'] = 'U8[]', ['maxLength'] = 255, ['minLength'] = 1, ['param'] = 'PayLoad'},
                    {['baseType'] = 'U8', ['param'] = 'UserId'}, {['baseType'] = 'U32', ['param'] = 'SessionId'},
                    {['baseType'] = 'U32', ['param'] = 'SessionSequence'}
                },
                ['rsp'] = {}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/AccountService/Authentication'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.Authentication'] = {
            ['property_defaults'] = {
                ['AccountLockoutDuration'] = 300,
                ['AccountLockoutThreshold'] = 5,
                ['MaxAccountLockoutDuration'] = 1800,
                ['MaxAccountLockoutThreshold'] = 6,
                ['AccountLockoutCounterResetAfter'] = 300,
                ['LocalAccountAuth'] = 'LocalFirst'
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['AccountLockoutDuration'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.SecurityMgmt},
                    ['AccountLockoutThreshold'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.SecurityMgmt},
                    ['MaxAccountLockoutDuration'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.SecurityMgmt},
                    ['MaxAccountLockoutThreshold'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.SecurityMgmt},
                    ['AccountLockoutCounterResetAfter'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['LocalAccountAuth'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.SecurityMgmt}
                }
            },
            ['interface_types'] = authentication_intf_types
        },
        ['bmc.kepler.AccountService.Authentication.RMCP'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = rmcp_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Sessions = {
    ['table_name'] = 't_sessions',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'S32',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = sessions_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = sessions_class_types.Id.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.SessionService.Sessions'] = {
            ['ValidateSsoClient'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = false,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'SecurityMgmt'}},
                ['validator'] = sessions_intf_types.ValidateSsoClient
            },
            ['SsoEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'SecurityMgmt'}},
                ['default'] = true,
                ['validator'] = sessions_intf_types.SsoEnabled
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.SessionService.Sessions'] = {
            ['NewSession'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'String', ['maxLength'] = 32, ['minLength'] = 1, ['param'] = 'UserName'},
                    {['baseType'] = 'U8[]', ['maxLength'] = 512, ['minLength'] = 1, ['param'] = 'Password'},
                    {['baseType'] = 'U8', ['param'] = 'SessionType'}, {['baseType'] = 'String', ['param'] = 'Domain'},
                    {['baseType'] = 'String', ['param'] = 'Ip'},
                    {['baseType'] = 'Dictionary', ['$ref'] = '#/defs/ExtraDataDict', ['param'] = 'ExtraData'}
                },
                ['rsp'] = {
                    {['baseType'] = 'String', ['param'] = 'Token'}, {['baseType'] = 'String', ['param'] = 'CsrfToken'},
                    {['baseType'] = 'String', ['param'] = 'SessionId'}
                },
                ['privilege'] = {'ConfigureSelf'}
            },
            ['NewRemoteConsoleSession'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'Token'}, {['baseType'] = 'U8', ['param'] = 'SessionType'},
                    {['baseType'] = 'U8', ['param'] = 'SessionMode'}
                },
                ['rsp'] = {
                    {['baseType'] = 'String', ['param'] = 'RemoteConsoleToken'},
                    {['baseType'] = 'String', ['param'] = 'RemoteConsoleSessionId'}
                },
                ['privilege'] = {'ConfigureSelf'}
            },
            ['NewVNCSession'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'CipherText'},
                    {['baseType'] = 'String', ['param'] = 'AuthChallenge'},
                    {['baseType'] = 'U8', ['param'] = 'SessionMode'}
                },
                ['rsp'] = {{['baseType'] = 'String', ['param'] = 'VNCSessionId'}},
                ['privilege'] = {'ConfigureSelf'}
            },
            ['SessionHeartBeat'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'SessionId'},
                    {['baseType'] = 'U8', ['param'] = 'RemainActiveSeconds'}
                },
                ['rsp'] = {},
                ['privilege'] = {'ConfigureSelf'}
            },
            ['GetCLISessionList'] = {
                ['initiator'] = true,
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/CLISession'}, ['param'] = 'CLISessions'}
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['NewSessionBySSO'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'Token'}, {['baseType'] = 'U8', ['param'] = 'SessionType'},
                    {['baseType'] = 'U8', ['param'] = 'SessionMode'}
                },
                ['rsp'] = {
                    {['baseType'] = 'String', ['param'] = 'Token'}, {['baseType'] = 'String', ['param'] = 'CsrfToken'},
                    {['baseType'] = 'String', ['param'] = 'SessionId'}
                },
                ['privilege'] = {'ConfigureSelf'}
            },
            ['SetKvmKey'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'SecretKey'}, {['baseType'] = 'U8', ['param'] = 'SessionMode'}
                },
                ['rsp'] = {},
                ['privilege'] = {'KVMMgmt'}
            },
            ['DeleteAllSessions'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'SessionType'},
                    {['baseType'] = 'U8', ['param'] = 'SessionLogoutType'}
                },
                ['rsp'] = {},
                ['privilege'] = {'SecurityMgmt'}
            },
            ['NewSessionByCert'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'SerialNumber'},
                    {['baseType'] = 'String', ['param'] = 'Issuer'}, {['baseType'] = 'String', ['param'] = 'Subject'},
                    {['baseType'] = 'String', ['param'] = 'Ip'}, {['baseType'] = 'U8', ['param'] = 'BrowserType'}
                },
                ['rsp'] = {
                    {['baseType'] = 'String', ['param'] = 'Token'}, {['baseType'] = 'String', ['param'] = 'CsrfToken'},
                    {['baseType'] = 'String', ['param'] = 'SessionId'}
                },
                ['privilege'] = {'ConfigureSelf'}
            },
            ['ValidateSessionWithCsrf'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'SessionType'}, {['baseType'] = 'String', ['param'] = 'Token'},
                    {['baseType'] = 'String', ['param'] = 'CsrfToken'}
                },
                ['rsp'] = {{['baseType'] = 'String', ['param'] = 'SessionId'}}
            },
            ['ValidateSession'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'SessionType'}, {['baseType'] = 'String', ['param'] = 'Token'}
                },
                ['rsp'] = {{['baseType'] = 'String', ['param'] = 'SessionId'}}
            },
            ['GetSessionLogoutType'] = {
                ['initiator'] = true,
                ['req'] = {{['baseType'] = 'String', ['param'] = 'SessionId'}},
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'LogoutType'}}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/SessionService/Sessions'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.SessionService.Sessions'] = {
            ['property_defaults'] = {['ValidateSsoClient'] = false, ['SsoEnabled'] = true},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['ValidateSsoClient'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.SecurityMgmt},
                    ['SsoEnabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.SecurityMgmt}
                },
                ['methods'] = {
                    ['NewSession'] = privilege.ConfigureSelf,
                    ['NewRemoteConsoleSession'] = privilege.ConfigureSelf,
                    ['NewVNCSession'] = privilege.ConfigureSelf,
                    ['SessionHeartBeat'] = privilege.ConfigureSelf,
                    ['GetCLISessionList'] = privilege.ReadOnly,
                    ['NewSessionBySSO'] = privilege.ConfigureSelf,
                    ['SetKvmKey'] = privilege.KVMMgmt,
                    ['DeleteAllSessions'] = privilege.SecurityMgmt,
                    ['NewSessionByCert'] = privilege.ConfigureSelf
                }
            },
            ['interface_types'] = sessions_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local LDAP = {
    ['table_name'] = 't_ldap',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'S32',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = ldap_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = ldap_class_types.Id.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.LDAP'] = {
            ['Enabled'] = {
                ['baseType'] = 'Boolean',
                ['default'] = true,
                ['readOnly'] = false,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = ldap_intf_types.Enabled
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/AccountService/LDAP'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.LDAP'] = {
            ['property_defaults'] = {['Enabled'] = true},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {['Enabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt}}
            },
            ['interface_types'] = ldap_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local LDAPController = {
    ['table_name'] = 't_ldap_controller',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U32',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = ldap_controller_class_types.Id
        },
        ['LdapVer'] = {
            ['baseType'] = 'U8',
            ['default'] = 3,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = ldap_controller_class_types.LdapVer
        },
        ['BaseDN'] = {
            ['baseType'] = 'String',
            ['notAllowNull'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = ldap_controller_class_types.BaseDN
        },
        ['BindDNPsw'] = {
            ['baseType'] = 'String',
            ['notAllowNull'] = true,
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['validator'] = ldap_controller_class_types.BindDNPsw
        },
        ['Scope'] = {
            ['baseType'] = 'String',
            ['default'] = 'sub',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = ldap_controller_class_types.Scope
        },
        ['TimeLimit'] = {
            ['baseType'] = 'S32',
            ['default'] = 2,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = ldap_controller_class_types.TimeLimit
        },
        ['BindTimeLimit'] = {
            ['baseType'] = 'S32',
            ['default'] = 2,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = ldap_controller_class_types.BindTimeLimit
        },
        ['CRLVerificationEnable'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = ldap_controller_class_types.CRLVerificationEnable
        }
    },
    ['default_props'] = {
        ['Id'] = ldap_controller_class_types.Id.default[1],
        ['LdapVer'] = 3,
        ['BaseDN'] = ldap_controller_class_types.BaseDN.default[1],
        ['BindDNPsw'] = ldap_controller_class_types.BindDNPsw.default[1],
        ['Scope'] = 'sub',
        ['TimeLimit'] = 2,
        ['BindTimeLimit'] = 2,
        ['CRLVerificationEnable'] = false
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.LDAP.LDAPController'] = {
            ['Enabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = ldap_controller_intf_types.Enabled
            },
            ['HostAddr'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['notAllowNull'] = true,
                ['validator'] = ldap_controller_intf_types.HostAddr
            },
            ['Port'] = {
                ['baseType'] = 'S32',
                ['readOnly'] = false,
                ['default'] = 636,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = ldap_controller_intf_types.Port
            },
            ['UserDomain'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['notAllowNull'] = true,
                ['validator'] = ldap_controller_intf_types.UserDomain
            },
            ['Folder'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['notAllowNull'] = true,
                ['validator'] = ldap_controller_intf_types.Folder
            },
            ['BindDN'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['notAllowNull'] = true,
                ['validator'] = ldap_controller_intf_types.BindDN
            },
            ['CertVerifyEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = ldap_controller_intf_types.CertVerifyEnabled
            },
            ['CertVerifyLevel'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 2,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = ldap_controller_intf_types.CertVerifyLevel
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.AccountService.LDAP.LDAPController'] = {
            ['SetBindDnPassword'] = {
                ['initiator'] = true,
                ['req'] = {{['baseType'] = 'U8[]', ['maxLength'] = 20, ['minLength'] = 0, ['param'] = 'Password'}},
                ['rsp'] = {},
                ['privilege'] = {'UserMgmt'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/AccountService/LDAP/LDAPController/:ControllerId'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.LDAP.LDAPController'] = {
            ['property_defaults'] = {
                ['Enabled'] = true,
                ['HostAddr'] = ldap_controller_intf_types.HostAddr.default[1],
                ['Port'] = 636,
                ['UserDomain'] = ldap_controller_intf_types.UserDomain.default[1],
                ['Folder'] = ldap_controller_intf_types.Folder.default[1],
                ['BindDN'] = ldap_controller_intf_types.BindDN.default[1],
                ['CertVerifyEnabled'] = true,
                ['CertVerifyLevel'] = 2
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['Enabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['HostAddr'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['Port'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['UserDomain'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['Folder'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['BindDN'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['CertVerifyEnabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['CertVerifyLevel'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt}
                },
                ['methods'] = {['SetBindDnPassword'] = privilege.UserMgmt}
            },
            ['interface_types'] = ldap_controller_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Kerberos = {
    ['table_name'] = 't_kerberos',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = kerberos_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = kerberos_class_types.Id.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.Kerberos'] = {
            ['Enabled'] = {
                ['baseType'] = 'Boolean',
                ['default'] = true,
                ['readOnly'] = false,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = kerberos_intf_types.Enabled
            },
            ['Address'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = kerberos_intf_types.Address
            },
            ['Port'] = {
                ['baseType'] = 'S32',
                ['readOnly'] = false,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = kerberos_intf_types.Port
            },
            ['Realm'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = kerberos_intf_types.Realm
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.AccountService.Kerberos'] = {
            ['ImportKeyTable'] = {
                ['initiator'] = true,
                ['req'] = {{['baseType'] = 'String', ['maxLength'] = 256, ['minLength'] = 1, ['param'] = 'Path'}},
                ['rsp'] = {},
                ['privilege'] = {'UserMgmt'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/AccountService/Kerberos'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.Kerberos'] = {
            ['property_defaults'] = {
                ['Enabled'] = true,
                ['Address'] = kerberos_intf_types.Address.default[1],
                ['Port'] = kerberos_intf_types.Port.default[1],
                ['Realm'] = kerberos_intf_types.Realm.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['Enabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['Address'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['Port'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['Realm'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt}
                },
                ['methods'] = {['ImportKeyTable'] = privilege.UserMgmt}
            },
            ['interface_types'] = kerberos_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local RemoteGroups = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.RemoteGroups'] = {
            ['AllowedLoginInterfaces'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = false,
                ['default'] = {'Web', 'SSH', 'Redfish'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = remote_groups_intf_types.AllowedLoginInterfaces
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.AccountService.RemoteGroups'] = {
            ['New'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'U8', ['readOnly'] = true, ['param'] = 'GroupType'},
                    {['baseType'] = 'U8', ['param'] = 'ControllerId'},
                    {['baseType'] = 'U8', ['maximum'] = 5, ['minimum'] = 0, ['param'] = 'MemberId'},
                    {['baseType'] = 'String', ['param'] = 'Name'}, {['baseType'] = 'String', ['param'] = 'Folder'},
                    {['baseType'] = 'String', ['param'] = 'SID'}, {['baseType'] = 'U8', ['param'] = 'UserRoleId'},
                    {['baseType'] = 'String[]', ['param'] = 'PermitRuleIds'},
                    {['baseType'] = 'String[]', ['param'] = 'LoginInterface'}
                },
                ['rsp'] = {{['baseType'] = 'String', ['param'] = 'GroupId'}},
                ['privilege'] = {'UserMgmt'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/AccountService/RemoteGroups'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.RemoteGroups'] = {
            ['property_defaults'] = {['AllowedLoginInterfaces'] = {'Web', 'SSH', 'Redfish'}},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['AllowedLoginInterfaces'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt}
                },
                ['methods'] = {['New'] = privilege.UserMgmt}
            },
            ['interface_types'] = remote_groups_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local RemoteGroupsDB = {
    ['table_name'] = 't_remote_groups',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = remote_groups_db_class_types.Id
        },
        ['AllowedLoginInterfaces'] = {
            ['baseType'] = 'U32',
            ['default'] = 137,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = remote_groups_db_class_types.AllowedLoginInterfaces
        }
    },
    ['default_props'] = {['Id'] = remote_groups_db_class_types.Id.default[1], ['AllowedLoginInterfaces'] = 137}
}

local RemoteGroup = {
    ['table_name'] = 't_remote_group',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U32',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = remote_group_class_types.Id
        },
        ['ControllerInnerId'] = {
            ['baseType'] = 'U32',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = remote_group_class_types.ControllerInnerId
        },
        ['Domain'] = {
            ['baseType'] = 'String',
            ['notAllowNull'] = false,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = remote_group_class_types.Domain
        },
        ['Privilege'] = {
            ['baseType'] = 'U8',
            ['notAllowNull'] = false,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = remote_group_class_types.Privilege
        },
        ['PrivilegeMask'] = {
            ['baseType'] = 'U32',
            ['notAllowNull'] = false,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = remote_group_class_types.PrivilegeMask
        },
        ['PermitRuleIdsDB'] = {
            ['baseType'] = 'U8',
            ['notAllowNull'] = false,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = remote_group_class_types.PermitRuleIdsDB
        },
        ['LoginInterfaceDB'] = {
            ['baseType'] = 'U8',
            ['notAllowNull'] = false,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = remote_group_class_types.LoginInterfaceDB
        }
    },
    ['default_props'] = {
        ['Id'] = remote_group_class_types.Id.default[1],
        ['ControllerInnerId'] = remote_group_class_types.ControllerInnerId.default[1],
        ['Domain'] = remote_group_class_types.Domain.default[1],
        ['Privilege'] = remote_group_class_types.Privilege.default[1],
        ['PrivilegeMask'] = remote_group_class_types.PrivilegeMask.default[1],
        ['PermitRuleIdsDB'] = remote_group_class_types.PermitRuleIdsDB.default[1],
        ['LoginInterfaceDB'] = remote_group_class_types.LoginInterfaceDB.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.RemoteGroup'] = {
            ['GroupType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = remote_group_intf_types.GroupType
            },
            ['ControllerId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = remote_group_intf_types.ControllerId
            },
            ['SID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['notAllowNull'] = true,
                ['validator'] = remote_group_intf_types.SID
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['notAllowNull'] = true,
                ['validator'] = remote_group_intf_types.Name
            },
            ['UserRoleId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['notAllowNull'] = true,
                ['validator'] = remote_group_intf_types.UserRoleId
            },
            ['Folder'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = remote_group_intf_types.Folder
            },
            ['PermitRuleIds'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = false,
                ['default'] = {},
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = remote_group_intf_types.PermitRuleIds
            },
            ['LoginInterface'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = false,
                ['default'] = {},
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = remote_group_intf_types.LoginInterface
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.AccountService.RemoteGroup'] = {
            ['Delete'] = {['initiator'] = true, ['req'] = {}, ['rsp'] = {}, ['privilege'] = {'UserMgmt'}}
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/AccountService/RemoteGroups/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.RemoteGroup'] = {
            ['property_defaults'] = {
                ['GroupType'] = remote_group_intf_types.GroupType.default[1],
                ['ControllerId'] = remote_group_intf_types.ControllerId.default[1],
                ['SID'] = remote_group_intf_types.SID.default[1],
                ['Name'] = remote_group_intf_types.Name.default[1],
                ['UserRoleId'] = remote_group_intf_types.UserRoleId.default[1],
                ['Folder'] = remote_group_intf_types.Folder.default[1],
                ['PermitRuleIds'] = {},
                ['LoginInterface'] = {}
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['GroupType'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['ControllerId'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['SID'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['Name'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['UserRoleId'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['Folder'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['PermitRuleIds'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['LoginInterface'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt}
                },
                ['methods'] = {['Delete'] = privilege.UserMgmt}
            },
            ['interface_types'] = remote_group_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local CertificateAuthentication = {
    ['table_name'] = 't_certificate_authentication',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = certificate_authentication_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = certificate_authentication_class_types.Id.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.CertificateAuthentication'] = {
            ['Enabled'] = {
                ['baseType'] = 'Boolean',
                ['default'] = false,
                ['readOnly'] = false,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = certificate_authentication_intf_types.Enabled
            },
            ['OCSPEnabled'] = {
                ['baseType'] = 'Boolean',
                ['default'] = false,
                ['readOnly'] = false,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = certificate_authentication_intf_types.OCSPEnabled
            },
            ['InterChassisAuthEnabled'] = {
                ['baseType'] = 'Boolean',
                ['default'] = false,
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = certificate_authentication_intf_types.InterChassisAuthEnabled
            },
            ['InterChassisValidation'] = {
                ['baseType'] = 'String',
                ['default'] = 'LLDP',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'None', 'LLDP'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = certificate_authentication_intf_types.InterChassisValidation
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/AccountService/CertificateAuthentication'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.CertificateAuthentication'] = {
            ['property_defaults'] = {
                ['Enabled'] = false,
                ['OCSPEnabled'] = false,
                ['InterChassisAuthEnabled'] = false,
                ['InterChassisValidation'] = 'LLDP'
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['Enabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['OCSPEnabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['InterChassisAuthEnabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['InterChassisValidation'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt}
                }
            },
            ['interface_types'] = certificate_authentication_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('SessionService', SessionService):set_bus(bus)
    class('Session', Session):set_bus(bus)
    class('Authentication', Authentication):set_bus(bus)
    class('Sessions', Sessions):set_bus(bus)
    class('LDAP', LDAP):set_bus(bus)
    class('LDAPController', LDAPController):set_bus(bus)
    class('Kerberos', Kerberos):set_bus(bus)
    class('RemoteGroups', RemoteGroups):set_bus(bus)
    class('RemoteGroupsDB', RemoteGroupsDB):set_bus(bus)
    class('RemoteGroup', RemoteGroup):set_bus(bus)
    class('CertificateAuthentication', CertificateAuthentication):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplSessionSessionSessionDelete(cb)
    class('Session')['bmc.kepler.SessionService.Session'].SessionDelete = function(obj, ctx, ...)
        local req = session_intf_types.SessionDeleteReq.new(...):validate(nil, nil, true)
        local rsp = session_intf_types.SessionDeleteRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplAuthenticationAuthenticationAuthenticate(cb)
    class('Authentication')['bmc.kepler.AccountService.Authentication'].Authenticate = function(obj, ctx, ...)
        local req = authentication_intf_types.AuthenticateReq.new(...):validate(nil, nil, true)
        local rsp = authentication_intf_types.AuthenticateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplAuthenticationRMCPGenRakp2AuthCode(cb)
    class('Authentication')['bmc.kepler.AccountService.Authentication.RMCP'].GenRakp2AuthCode = function(obj, ctx, ...)
        local req = rmcp_intf_types.GenRakp2AuthCodeReq.new(...):validate(nil, nil, true)
        local rsp = rmcp_intf_types.GenRakp2AuthCodeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplAuthenticationRMCPAuthRakp3(cb)
    class('Authentication')['bmc.kepler.AccountService.Authentication.RMCP'].AuthRakp3 = function(obj, ctx, ...)
        local req = rmcp_intf_types.AuthRakp3Req.new(...):validate(nil, nil, true)
        local rsp = rmcp_intf_types.AuthRakp3Rsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplAuthenticationRMCPGenSik(cb)
    class('Authentication')['bmc.kepler.AccountService.Authentication.RMCP'].GenSik = function(obj, ctx, ...)
        local req = rmcp_intf_types.GenSikReq.new(...):validate(nil, nil, true)
        local rsp = rmcp_intf_types.GenSikRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplAuthenticationRMCPGenRmcpAuthCode(cb)
    class('Authentication')['bmc.kepler.AccountService.Authentication.RMCP'].GenRmcpAuthCode = function(obj, ctx, ...)
        local req = rmcp_intf_types.GenRmcpAuthCodeReq.new(...):validate(nil, nil, true)
        local rsp = rmcp_intf_types.GenRmcpAuthCodeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplAuthenticationRMCPCheckRmcpAuthCode(cb)
    class('Authentication')['bmc.kepler.AccountService.Authentication.RMCP'].CheckRmcpAuthCode = function(obj, ctx, ...)
        local req = rmcp_intf_types.CheckRmcpAuthCodeReq.new(...):validate(nil, nil, true)
        local rsp = rmcp_intf_types.CheckRmcpAuthCodeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSessionsSessionsNewSession(cb)
    class('Sessions')['bmc.kepler.SessionService.Sessions'].NewSession = function(obj, ctx, ...)
        local req = sessions_intf_types.NewSessionReq.new(...):validate(nil, nil, true)
        local rsp = sessions_intf_types.NewSessionRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSessionsSessionsNewRemoteConsoleSession(cb)
    class('Sessions')['bmc.kepler.SessionService.Sessions'].NewRemoteConsoleSession = function(obj, ctx, ...)
        local req = sessions_intf_types.NewRemoteConsoleSessionReq.new(...):validate(nil, nil, true)
        local rsp = sessions_intf_types.NewRemoteConsoleSessionRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSessionsSessionsNewVNCSession(cb)
    class('Sessions')['bmc.kepler.SessionService.Sessions'].NewVNCSession = function(obj, ctx, ...)
        local req = sessions_intf_types.NewVNCSessionReq.new(...):validate(nil, nil, true)
        local rsp = sessions_intf_types.NewVNCSessionRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSessionsSessionsSessionHeartBeat(cb)
    class('Sessions')['bmc.kepler.SessionService.Sessions'].SessionHeartBeat = function(obj, ctx, ...)
        local req = sessions_intf_types.SessionHeartBeatReq.new(...):validate(nil, nil, true)
        local rsp = sessions_intf_types.SessionHeartBeatRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSessionsSessionsGetCLISessionList(cb)
    class('Sessions')['bmc.kepler.SessionService.Sessions'].GetCLISessionList = function(obj, ctx, ...)
        local req = sessions_intf_types.GetCLISessionListReq.new(...):validate(nil, nil, true)
        local rsp = sessions_intf_types.GetCLISessionListRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSessionsSessionsNewSessionBySSO(cb)
    class('Sessions')['bmc.kepler.SessionService.Sessions'].NewSessionBySSO = function(obj, ctx, ...)
        local req = sessions_intf_types.NewSessionBySSOReq.new(...):validate(nil, nil, true)
        local rsp = sessions_intf_types.NewSessionBySSORsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSessionsSessionsSetKvmKey(cb)
    class('Sessions')['bmc.kepler.SessionService.Sessions'].SetKvmKey = function(obj, ctx, ...)
        local req = sessions_intf_types.SetKvmKeyReq.new(...):validate(nil, nil, true)
        local rsp = sessions_intf_types.SetKvmKeyRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSessionsSessionsDeleteAllSessions(cb)
    class('Sessions')['bmc.kepler.SessionService.Sessions'].DeleteAllSessions = function(obj, ctx, ...)
        local req = sessions_intf_types.DeleteAllSessionsReq.new(...):validate(nil, nil, true)
        local rsp = sessions_intf_types.DeleteAllSessionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSessionsSessionsNewSessionByCert(cb)
    class('Sessions')['bmc.kepler.SessionService.Sessions'].NewSessionByCert = function(obj, ctx, ...)
        local req = sessions_intf_types.NewSessionByCertReq.new(...):validate(nil, nil, true)
        local rsp = sessions_intf_types.NewSessionByCertRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSessionsSessionsValidateSessionWithCsrf(cb)
    class('Sessions')['bmc.kepler.SessionService.Sessions'].ValidateSessionWithCsrf = function(obj, ctx, ...)
        local req = sessions_intf_types.ValidateSessionWithCsrfReq.new(...):validate(nil, nil, true)
        local rsp = sessions_intf_types.ValidateSessionWithCsrfRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSessionsSessionsValidateSession(cb)
    class('Sessions')['bmc.kepler.SessionService.Sessions'].ValidateSession = function(obj, ctx, ...)
        local req = sessions_intf_types.ValidateSessionReq.new(...):validate(nil, nil, true)
        local rsp = sessions_intf_types.ValidateSessionRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSessionsSessionsGetSessionLogoutType(cb)
    class('Sessions')['bmc.kepler.SessionService.Sessions'].GetSessionLogoutType = function(obj, ctx, ...)
        local req = sessions_intf_types.GetSessionLogoutTypeReq.new(...):validate(nil, nil, true)
        local rsp = sessions_intf_types.GetSessionLogoutTypeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplLDAPControllerLDAPControllerSetBindDnPassword(cb)
    class('LDAPController')['bmc.kepler.AccountService.LDAP.LDAPController'].SetBindDnPassword = function(obj, ctx, ...)
        local req = ldap_controller_intf_types.SetBindDnPasswordReq.new(...):validate(nil, nil, true)
        local rsp = ldap_controller_intf_types.SetBindDnPasswordRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplKerberosKerberosImportKeyTable(cb)
    class('Kerberos')['bmc.kepler.AccountService.Kerberos'].ImportKeyTable = function(obj, ctx, ...)
        local req = kerberos_intf_types.ImportKeyTableReq.new(...):validate(nil, nil, true)
        local rsp = kerberos_intf_types.ImportKeyTableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplRemoteGroupsRemoteGroupsNew(cb)
    class('RemoteGroups')['bmc.kepler.AccountService.RemoteGroups'].New = function(obj, ctx, ...)
        local req = remote_groups_intf_types.NewReq.new(...):validate(nil, nil, true)
        local rsp = remote_groups_intf_types.NewRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplRemoteGroupRemoteGroupDelete(cb)
    class('RemoteGroup')['bmc.kepler.AccountService.RemoteGroup'].Delete = function(obj, ctx, ...)
        local req = remote_group_intf_types.DeleteReq.new(...):validate(nil, nil, true)
        local rsp = remote_group_intf_types.DeleteRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
