--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetUserPasswordCompareInfo = {}

---@class AccountIpmiCmds.SetUserPasswordCompareInfoReq
---@field ManufactureId integer
---@field CompareEnabled integer
---@field CompareLength integer
local TSetUserPasswordCompareInfoReq = {}
TSetUserPasswordCompareInfoReq.__index = TSetUserPasswordCompareInfoReq
TSetUserPasswordCompareInfoReq.group = {}

local function TSetUserPasswordCompareInfoReq_from_obj(obj)
    return setmetatable(obj, TSetUserPasswordCompareInfoReq)
end

function TSetUserPasswordCompareInfoReq.new(ManufactureId, CompareEnabled, CompareLength)
    return TSetUserPasswordCompareInfoReq_from_obj({
        ManufactureId = ManufactureId,
        CompareEnabled = CompareEnabled,
        CompareLength = CompareLength
    })
end
---@param obj AccountIpmiCmds.SetUserPasswordCompareInfoReq
function TSetUserPasswordCompareInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.CompareEnabled = obj.CompareEnabled
    self.CompareLength = obj.CompareLength
end

function TSetUserPasswordCompareInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetUserPasswordCompareInfoReq.group)
end

TSetUserPasswordCompareInfoReq.from_obj = TSetUserPasswordCompareInfoReq_from_obj

TSetUserPasswordCompareInfoReq.proto_property = {'ManufactureId', 'CompareEnabled', 'CompareLength'}

TSetUserPasswordCompareInfoReq.default = {0, 0, 0}

TSetUserPasswordCompareInfoReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'CompareEnabled', is_array = false, struct = nil},
    {name = 'CompareLength', is_array = false, struct = nil}
}

function TSetUserPasswordCompareInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'CompareEnabled', self.CompareEnabled, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'CompareLength', self.CompareLength, 'uint8', false, errs, need_convert)

    TSetUserPasswordCompareInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetUserPasswordCompareInfoReq.proto_property, errs, need_convert)
    return self
end

function TSetUserPasswordCompareInfoReq:unpack(_)
    return self.ManufactureId, self.CompareEnabled, self.CompareLength
end

SetUserPasswordCompareInfo.SetUserPasswordCompareInfoReq = TSetUserPasswordCompareInfoReq

---@class AccountIpmiCmds.SetUserPasswordCompareInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetUserPasswordCompareInfoRsp = {}
TSetUserPasswordCompareInfoRsp.__index = TSetUserPasswordCompareInfoRsp
TSetUserPasswordCompareInfoRsp.group = {}

local function TSetUserPasswordCompareInfoRsp_from_obj(obj)
    return setmetatable(obj, TSetUserPasswordCompareInfoRsp)
end

function TSetUserPasswordCompareInfoRsp.new(CompletionCode, ManufactureId)
    return TSetUserPasswordCompareInfoRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj AccountIpmiCmds.SetUserPasswordCompareInfoRsp
function TSetUserPasswordCompareInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetUserPasswordCompareInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetUserPasswordCompareInfoRsp.group)
end

TSetUserPasswordCompareInfoRsp.from_obj = TSetUserPasswordCompareInfoRsp_from_obj

TSetUserPasswordCompareInfoRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetUserPasswordCompareInfoRsp.default = {0, 0}

TSetUserPasswordCompareInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetUserPasswordCompareInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetUserPasswordCompareInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetUserPasswordCompareInfoRsp.proto_property, errs, need_convert)
    return self
end

function TSetUserPasswordCompareInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetUserPasswordCompareInfo.SetUserPasswordCompareInfoRsp = TSetUserPasswordCompareInfoRsp

return SetUserPasswordCompareInfo
