
interface ResolverOptions {
  /**
     * import style css or sass with components
     *
     * @default 'css'
     */
  importStyle?: boolean | 'css' | 'sass';
  /**
   * use commonjs lib & source css or scss for ssr
   */
  ssr?: boolean;
  /**
   * specify element-plus version to load style
   *
   * @default installed version
   */
  version?: string;
  /**
   * auto import for directives
   *
   * @default true
   */
  directives?: boolean;
  /**
   * exclude component name, if match do not resolve the name
   */
  exclude?: RegExp;
}

declare function OpenDesignResolver(resolver: (p: any) => any, resolverOptions?: ResolverOptions, opendesignPath?: string): any;

export { OpenDesignResolver, ResolverOptions };