#!/usr/bin/env bash

CANGJIE_HOME=/opt/cangjie

function setup_cangjie()
{
    if [cjc -v &>/dev/null]; then
        return 0
    fi

    if [ -d $CANGJIE_HOME ]; then
        source "${CANGJIE_HOME}/envsetup.sh"
        return 0
    fi

    echo "please install cangjie at /opt/cangjie and execute 'source /opt/cangjie/envsetup.sh' manually"
}

function setup_env()
{
    RET=$(grep -c "CANGJIE_HOME" /etc/profile)
    if [[ "${RET}" -eq '0' ]]; then
        echo 'export CANGJIE_HOME=/opt/cangjie' >> /etc/profile
        echo 'export PATH=${CANGJIE_HOME}/bin:${CANGJIE_HOME}/tools/bin:${PATH}' >> /etc/profile
        echo 'export LD_LIBRARY_PATH=${CANGJIE_HOME}/runtime/lib/linux_x86_64_llvm:/usr/share/bmc_studio/server:${LD_LIBRARY_PATH}' >> /etc/profile
        echo 'export cjHeapSize=1024MB' >> /etc/profile
    fi
    source /etc/profile
}

function install_wslu()
{
    sudo  apt install -y wslu
}


function install_xdg()
{
    sudo apt install -y xdg-utils
}

setup_cangjie
setup_env
install_xdg
install_wslu
