#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
import argparse
import json
import os
import yaml


def run(args):
    input_file = args.input
    output_file = args.output
    if input_file is None or not os.path.exists(input_file) or output_file is None:
        raise RuntimeError("缺少参数或输入文件不存在")
    if args.reverse:
        with open(input_file, 'r') as file_descriptor:
            content = json.load(file_descriptor)
        with open(output_file, 'w') as file_descriptor:
            yaml.dump(content, file_descriptor)
    else:
        with open(input_file, 'r') as file_descriptor:
            content = yaml.safe_load(file_descriptor)
        with open(output_file, 'w') as file_descriptor:
            json.dump(content, file_descriptor)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="yaml文件转化为json文件")
    parser.add_argument("-i", "--input", help="输入文件")
    parser.add_argument("-o", "--output", help="输出文件")
    parser.add_argument("-r", "--reverse", help="json文件转化为yaml文件", action="store_true")
    args, _ = parser.parse_known_args()
    run(args)