-- interface mapping 解析表
DROP TABLE IF EXISTS interface_mapping_processing_flow_parser;
CREATE TABLE IF NOT EXISTS interface_mapping_processing_flow_parser(
    Id INTEGER PRIMARY KEY,
    BatchId TEXT,
    FileType TEXT,
    FilePath TEXT,
    Uri TEXT,
    MethodType TEXT,
    IgnoreEtags JSON,
    ItemIndex INTEGER,
    Type TEXT,
    Path TEXT,
    RegexPath TEXT,
    Interface TEXT,
    Destination JSON
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

-- interface mapping 解析表
DROP TABLE IF EXISTS interface_mapping_parser;
CREATE TABLE IF NOT EXISTS interface_mapping_parser(
    Id INTEGER PRIMARY KEY,
    BatchId TEXT,
    FileType TEXT,
    FilePath TEXT,
    Uri TEXT,
    MethodType TEXT,
    IntfData JSON,
    IgnoreEtags JSON,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS IntfMappingUnique on interface_mapping_parser(FilePath, FileType, Uri, MethodType);

-- interface mapping 非json文件表
DROP TABLE IF EXISTS interface_mapping_non_json_parser;
CREATE TABLE IF NOT EXISTS interface_mapping_non_json_parser(
    Id INTEGER PRIMARY KEY,
    BatchId TEXT,
    FileType TEXT,
    FilePath TEXT,
    RelPath TEXT,
    ContentType TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

-- interface mapping 脚本数据表
DROP TABLE IF EXISTS interface_mapping_script_parser;
CREATE TABLE IF NOT EXISTS interface_mapping_script_parser(
    Id INTEGER PRIMARY KEY,
    BatchId TEXT,
    FileType TEXT,
    FilePath TEXT,
    RelPath TEXT,
    Reference TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

-- interface mapping 插件数据表
DROP TABLE IF EXISTS interface_mapping_plugin_parser;
CREATE TABLE IF NOT EXISTS interface_mapping_plugin_parser(
    Id INTEGER PRIMARY KEY,
    BatchId TEXT,
    FileType TEXT,
    FilePath TEXT,
    RelPath TEXT,
    FunctionName TEXT,
    ParamCount INTEGER,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

-- interface mapping 插件脚本formula数据表
DROP TABLE IF EXISTS interface_mapping_formula_parser;
CREATE TABLE IF NOT EXISTS interface_mapping_formula_parser(
    Id INTEGER PRIMARY KEY,
    BatchId TEXT,
    FileType TEXT,
    FilePath TEXT,
    Type TEXT,
    Formula TEXT,
    Source TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

-- interface mapping 全局变量表
DROP TABLE IF EXISTS interface_mapping_global_variable_parser;
CREATE TABLE IF NOT EXISTS interface_mapping_global_variable_parser(
    Id INTEGER PRIMARY KEY,
    BatchId TEXT,
    FileType TEXT,
    FilePath TEXT,
    Key TEXT,
    Value TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

-- mds service 解析表
DROP TABLE IF EXISTS mds_service_required_parser;
CREATE TABLE IF NOT EXISTS mds_service_required_parser(
    Id INTEGER PRIMARY KEY autoincrement,
    BatchId TEXT,
    FilePath TEXT,
    AppName TEXT,
    RequireIndex INTEGER,
    InterfacePath TEXT,
    NewIntfPath TEXT,
    IntfName TEXT,
    IntfDesc TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS MdsServiceReqUnique on mds_service_required_parser(FilePath, AppName, InterfacePath, IntfName);

-- mds model 解析表
DROP TABLE IF EXISTS mds_model_prop_parser;
CREATE TABLE IF NOT EXISTS mds_model_prop_parser(
    Id INTEGER PRIMARY KEY autoincrement,
    BatchId TEXT,
    FilePath TEXT,
    AppName TEXT,
    ClassName TEXT,
    TableName TEXT,
    Descript TEXT,
    TableType TEXT,
    TableLocation TEXT,
    DataKey TEXT,
    DataValue JSON,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS MdsModelPropUnique on mds_model_prop_parser(FilePath, AppName, ClassName, DataKey);

DROP TABLE IF EXISTS mds_model_intf_parser;
CREATE TABLE IF NOT EXISTS mds_model_intf_parser(
    Id INTEGER PRIMARY KEY autoincrement,
    BatchId TEXT,
    FilePath TEXT,
    AppName TEXT,
    ClassName TEXT,
    TableName TEXT,
    TableType TEXT,
    TableLocation TEXT,
    InterfacePath TEXT,
    NewIntfPath TEXT,
    privilege TEXT,
    IntfName TEXT,
    IntfType TEXT,
    IntfJson JSON,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS MdsModelIntfUnique on mds_model_intf_parser(FilePath, AppName, ClassName, InterfacePath, IntfName, IntfType);

DROP TABLE IF EXISTS mds_model_class_parser;
CREATE TABLE IF NOT EXISTS mds_model_class_parser(
    Id INTEGER PRIMARY KEY,
    BatchId TEXT,
    FilePath TEXT,
    AppName TEXT,
    ClassName TEXT,
    ClassData JSON,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

DROP TABLE IF EXISTS mds_types_parser;
CREATE TABLE IF NOT EXISTS mds_types_parser(
    Id INTEGER PRIMARY KEY autoincrement,
    BatchId TEXT,
    FilePath TEXT,
    AppName TEXT,
    DefName TEXT,
    DefsData JSON,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS MdsTypesUnique on mds_types_parser(FilePath, AppName, defName);

DROP TABLE IF EXISTS mds_model_intf_path_parser;
CREATE TABLE IF NOT EXISTS mds_model_intf_path_parser(
    Id INTEGER PRIMARY KEY autoincrement,
    BatchId TEXT,
    FilePath TEXT,
    AppName TEXT,
    ClassName TEXT,
    TableName TEXT,
    TableType TEXT,
    TableLocation TEXT,
    InterfacePath TEXT,
    NewIntfPath TEXT,
    privilege TEXT,
    IntfList JSON,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS MdsModelPathUnique on mds_model_intf_path_parser(FilePath, AppName, ClassName, InterfacePath);

-- csr 解析表
DROP TABLE IF EXISTS csr_parser;
CREATE TABLE IF NOT EXISTS csr_parser(
    Id INTEGER PRIMARY KEY,
    BatchId TEXT,
    FilePath TEXT,
    FileId TEXT,
    RepoName TEXT,
    BaseName TEXT,
    FormatVersion TEXT,
    DataVersion TEXT,
    UnitType TEXT,
    UnitName TEXT,
    DataType TEXT,
    ManagementTopology JSON,
    Objects JSON,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS csr_parser_unique_index on csr_parser(RepoName, FilePath);

-- dds 解析表
DROP TABLE IF EXISTS dds_file_parser;
CREATE TABLE IF NOT EXISTS dds_file_parser(
    Id INTEGER PRIMARY KEY,
    BatchId TEXT,
    FilePath TEXT,
    BaseName TEXT,
    Schema TEXT,
    FileType TEXT,
    DeviceCategory TEXT,
    ComponentId TEXT,
    ChipPath TEXT,
    Interfaces JSON,
    Objects JSON,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS dds_file_parser_unique_index on dds_file_parser(FilePath);

DROP TABLE IF EXISTS dds_parser;
CREATE TABLE IF NOT EXISTS dds_parser(
    Id INTEGER PRIMARY KEY autoincrement,
    BatchId TEXT,
    FilePath TEXT,
    SchemaId TEXT,
    DdsType TEXT,
    DeviceCategory TEXT,
    DeviceId TEXT,
    ObjectName TEXT,
    DdsPath TEXT,
    RegexPath TEXT,
    Interface JSON,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS DdsUnique on dds_parser(FilePath, ObjectName);

DROP TABLE IF EXISTS dds_intf_parser;
CREATE TABLE IF NOT EXISTS dds_intf_parser(
    Id INTEGER PRIMARY KEY autoincrement,
    BatchId TEXT,
    FilePath TEXT,
    SchemaId TEXT,
    DdsType TEXT,
    DeviceCategory TEXT,
    DeviceId TEXT,
    ObjectName TEXT,
    DdsPath TEXT,
    RegexPath TEXT,
    Interface TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS DdsIntfUnique on dds_intf_parser(FilePath, ObjectName, Interface);

-- 设备树资源协作接口实现解析表
DROP TABLE IF EXISTS tree_path_parse;
CREATE TABLE IF NOT EXISTS tree_path_parse(
    Id INTEGER PRIMARY KEY autoincrement,
    BatchId TEXT,
    FilePath TEXT,
    TableType TEXT,
    ObjectName TEXT,
    ObjectPath TEXT,
    RawPath TEXT,
    RegexPath TEXT,
    Interface TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS TreePathUnique on tree_path_parse(FilePath, TableType, ObjectName, ObjectPath);

-- 设备树资源协作接口实现详情解析表
DROP TABLE IF EXISTS tree_path_parse_detail;
CREATE TABLE IF NOT EXISTS tree_path_parse_detail(
    Id INTEGER PRIMARY KEY autoincrement,
    BatchId TEXT,
    FilePath TEXT,
    TableType TEXT,
    ObjectName TEXT, 
    ObjectPath TEXT,
    RawPath TEXT,
    RegexPath TEXT,
    Interface TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS TreePathDetailUnique on tree_path_parse_detail(FilePath, TableType, ObjectName, ObjectPath, Interface);

-- 设备树资源协作接口解析表
DROP TABLE IF EXISTS tree_intf_parser;
CREATE TABLE IF NOT EXISTS tree_intf_parser(
    Id INTEGER PRIMARY KEY autoincrement,
    BatchId TEXT,
    FilePath TEXT,
    TableType TEXT,
    IntfName TEXT,
    IntfType TEXT,
    DataKey TEXT,
    DataValue JSON,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS TreeIntfUnique on tree_intf_parser(FilePath, TableType, IntfName, IntfType, DataKey);

-- 设备树资源协作接口自定义类型解析表
DROP TABLE IF EXISTS tree_defs_data_parser;
CREATE TABLE IF NOT EXISTS tree_defs_data_parser(
    Id INTEGER PRIMARY KEY autoincrement,
    BatchId TEXT,
    FilePath TEXT,
    TableType TEXT,
    IntfName TEXT,
    DefsData JSON,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS DefsDataUnique on tree_defs_data_parser(FilePath, TableType);

-- 设备树资源协作接口名称解析表
DROP TABLE IF EXISTS tree_intf_name_parser;
CREATE TABLE IF NOT EXISTS tree_intf_name_parser(
    Id INTEGER PRIMARY KEY autoincrement,
    BatchId TEXT,
    FilePath TEXT,
    TableType TEXT,
    IntfName TEXT,
    IntfData JSON,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS TreeIntfNameUnique on tree_intf_name_parser(FilePath, TableType, IntfName);

-- 一致性检查结果持久化
DROP TABLE IF EXISTS consistency_check_result;
DROP TABLE IF EXISTS consistency_checked_result;
DROP TABLE IF EXISTS consistency_check_result_v1;
DROP TABLE IF EXISTS consistency_check_result_v2;
DROP TABLE IF EXISTS consistency_check_result_v3;
DROP TABLE IF EXISTS consistency_check_result_v4;
CREATE TABLE IF NOT EXISTS consistency_check_result_v5(
    Id INTEGER PRIMARY KEY autoincrement,
    RuleId TEXT,
    Category TEXT,
    ModelName TEXT,
    ModelId Id,
    AlarmId Id,
    ErrorInfluence TEXT,
    UniqueCode TEXT,
    ErrorObject TEXT,
    ErrorMsg TEXT,
    RepairJson TEXT,
    RepairSugJson JSON,
    RepairSugString TEXT,
    FilePath TEXT,
    FileType TEXT,
    DataIgnore INTEGER,
    CiEnabled BOOLEAN DEFAULT 0,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);
CREATE UNIQUE INDEX IF NOT EXISTS UniqueCode on consistency_check_result_v5(UniqueCode);

-- 一致性检查用户选择持久化
CREATE TABLE IF NOT EXISTS consistency_rule_select(
    Id INTEGER PRIMARY KEY autoincrement,
    SelectType TEXT,
    SelectValue TEXT,
    Checkstatus TEXT
);
CREATE UNIQUE INDEX IF NOT EXISTS typeValue on consistency_rule_select(SelectType, SelectValue);

-- git仓库远端配置表
CREATE TABLE IF NOT EXISTS repo_remotes_data(
    RepoName TEXT PRIMARY KEY,
    TrunkAddress TEXT,
    TrunkBranch TEXT,
    PersonAddress TEXT,
    PersonBranch TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

CREATE TRIGGER IF NOT EXISTS repo_remotes_data_updatetime_trig
AFTER UPDATE OF TrunkAddress, TrunkBranch, PersonAddress, PersonBranch ON repo_remotes_data
FOR EACH ROW
BEGIN
  UPDATE repo_remotes_data SET UpdateTime = (strftime('%Y%m%d%H%M%S', 'now', 'localtime')) WHERE RepoName = NEW.RepoName;
END;

-- manifest部署状态表
CREATE TABLE IF NOT EXISTS manifest_deploy_status_v2(
    ProductName TEXT,
    ManifestBranch TEXT,
    Deployed BOOLEAN DEFAULT 0,
    IsCurrent BOOLEAN DEFAULT 0,
    Stage TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y-%m-%d %H:%M:%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y-%m-%d %H:%M:%S', 'now', 'localtime')),
    PRIMARY KEY (ProductName, ManifestBranch)
);

-- manifest出包记录表
CREATE TABLE IF NOT EXISTS manifest_build_history(
    ProductName TEXT,
    PackageCode TEXT,
    ManifestBranch TEXT,
    FileName TEXT,  -- 此字段保存的是结果文件的绝对路径
    BuildTime TEXT,
    ComponentList JSON,
    CreateTime TEXT DEFAULT (strftime('%Y-%m-%d %H:%M:%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y-%m-%d %H:%M:%S', 'now', 'localtime')),
    PRIMARY KEY (ProductName, ManifestBranch)
);

-- manifest出包错误日志表
CREATE TABLE IF NOT EXISTS manifest_build_error_log(
    ProductName TEXT,
    ManifestBranch TEXT,
    ErrorLog TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y-%m-%d %H:%M:%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y-%m-%d %H:%M:%S', 'now', 'localtime')),
    PRIMARY KEY (ProductName, ManifestBranch)
);

-- 空间内仓库管理表
CREATE TABLE IF NOT EXISTS manifest_repo_data(
    Id INTEGER PRIMARY KEY autoincrement,
    ReportName TEXT,
    ServceName TEXT,
    RemoteUrl TEXT,
    Branch TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

-- 一键部署错误信息
CREATE TABLE IF NOT EXISTS reploy_repo_history(
    Id INTEGER PRIMARY KEY autoincrement,
    SpaceName TEXT,
    InfoMsg TEXT,
    InfoType TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);