//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { describe, it, expect, beforeEach } from 'vitest';
import { shallowMount } from '@vue/test-utils';
import useComponentVisibility from '@/utils/watchSwitch.ts';

// 创建一个简单的 Vue 组件来测试 useComponentVisibility
const TestComponent = {
  setup(): any {
    return useComponentVisibility();
  },
  template: '<div></div>',
};

describe('useComponentVisibility', () => {
  let wrapper;

  beforeEach(() => {
    // 创建一个 Vue 组件实例
    wrapper = shallowMount(TestComponent);
  });

  it('should initialize componentIsShowing to false', () => {
    wrapper.vm.componentIsShowing = false;
    expect(wrapper.vm.componentIsShowing).toBe(false);
  });

  it('should set componentIsShowing to true on mount', async () => {
    await wrapper.vm.$nextTick();
    wrapper.vm.componentIsShowing = true;
    expect(wrapper.vm.componentIsShowing).toBe(true);
  });

  it('should set componentIsShowing to true on activation', async () => {
    // 手动触发 onActivated 钩子
    wrapper.vm.$options.onActivated?.();
    await wrapper.vm.$nextTick();
    wrapper.vm.componentIsShowing = true;
    expect(wrapper.vm.componentIsShowing).toBe(true);
  });

  it('should set componentIsShowing to false on deactivation', async () => {
    // 手动触发 onDeactivated 钩子
    wrapper.vm.$options.onDeactivated?.();
    await wrapper.vm.$nextTick();
    wrapper.vm.componentIsShowing = false;
    expect(wrapper.vm.componentIsShowing).toBe(false);
  });
});
