//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { describe, it, expect } from 'vitest';
import Date from '@/utils/date.ts';

describe('Date.prototype.pattern Tests', () => {
  const date = new Date('2024-03-15T12:34:56.789Z');

  it('should format year correctly', () => {
    expect(date.pattern('yyyy')).toBe('2024');
    expect(date.pattern('yy')).toBe('24');
  });

  it('should format month correctly', () => {
    expect(date.pattern('MM')).toBe('03');
    expect(date.pattern('M')).toBe('3');
  });

  it('should format day correctly', () => {
    expect(date.pattern('dd')).toBe('15');
    expect(date.pattern('d')).toBe('15');
  });

  it('should format weekly correctly', () => {
    expect(date.pattern('E')).toBe('/u4e94');
    expect(date.pattern('EE')).toBe('/u5468/u4e94');
    expect(date.pattern('EEE')).toBe('/u661f/u671f/u4e94');
  });

  it('should format hour correctly', () => {
    expect(date.pattern('HH')).toBe('20');
    expect(date.pattern('H')).toBe('20');
    expect(date.pattern('hh')).toBe('08');
    expect(date.pattern('h')).toBe('8');
  });

  it('should format minute correctly', () => {
    expect(date.pattern('mm')).toBe('34');
    expect(date.pattern('m')).toBe('34');
  });

  it('should format second correctly', () => {
    expect(date.pattern('ss')).toBe('56');
    expect(date.pattern('s')).toBe('56');
  });

  it('should format quarter correctly', () => {
    expect(date.pattern('q')).toBe('1');
    expect(date.pattern('qq')).toBe('01');
  });

  it('should format millisecond correctly', () => {
    expect(date.pattern('S')).toBe('789');
  });
});

describe('Date.prototype.format Tests', () => {
  const date = new Date('2024-03-15T12:34:56.789Z');

  it('should format year correctly', () => {
    expect(date.format('yyyy')).toBe('2024');
    expect(date.format('yy')).toBe('24');
  });

  it('should format month correctly', () => {
    expect(date.format('MM')).toBe('03');
    expect(date.format('M')).toBe('3');
  });

  it('should format day correctly', () => {
    expect(date.format('dd')).toBe('15');
    expect(date.format('d')).toBe('15');
  });

  it('should format hour correctly', () => {
    expect(date.format('HH')).toBe('HH');
    expect(date.format('H')).toBe('H');
    expect(date.format('hh')).toBe('12');
    expect(date.format('h')).toBe('12');
  });

  it('should format minute correctly', () => {
    expect(date.format('mm')).toBe('34');
    expect(date.format('m')).toBe('34');
  });

  it('should format second correctly', () => {
    expect(date.format('ss')).toBe('56');
    expect(date.format('s')).toBe('56');
  });

  it('should format quarter correctly', () => {
    expect(date.format('q')).toBe('1');
    expect(date.format('qq')).toBe('01');
  });

  it('should format millisecond correctly', () => {
    expect(date.format('S')).toBe('789');
  });
});
