//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { createI18n } from 'vue-i18n';

import * as zh from '../assets/baseI18n/zh.json';
import * as en from '../assets/baseI18n/en.json';
import * as ja from '../assets/baseI18n/ja.json';
import * as fr from '../assets/baseI18n/fr.json';
import * as ru from '../assets/baseI18n/ru.json';

import * as zhErr from '../assets/errorI18n/zh.json';
import * as enErr from '../assets/errorI18n/en.json';
import * as jaErr from '../assets/errorI18n/ja.json';
import * as frErr from '../assets/errorI18n/fr.json';
import * as ruErr from '../assets/errorI18n/ru.json';

const instance = createI18n({
  locale: 'en',
  messages: {
    zh: { ...zh, ...zhErr },
    en: { ...en, ...enErr },
    ja: { ...ja, ...jaErr },
    fr: { ...fr, ...frErr },
    ru: { ...ru, ...ruErr },
  },
  globalInjection: true,
  legacy: false,
});

export function translate(key: string, param?: any) {
  return instance.global.t(key, param);
}

export default instance;
